/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.util.plist.PropertyList;
import com.apple.xsr.net.AcpxConnection;
import com.apple.xsr.net.BasicResponse;
import com.apple.xsr.net.CommShutdownException;
import com.apple.xsr.net.CommunicationHandler;
import com.apple.xsr.net.RequestMessage;
import com.apple.xsr.net.Response;
import com.apple.xsr.som.RaidSystem;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import sun.io.MalformedInputException;

public class CommunicationsManager
implements Runnable {
    private static final int CONNECT_BACKOFF_CEILING = 3600000;
    private AcpxConnection connection;
    private LinkedList queue = new LinkedList();
    private RaidSystem system;
    private String primary;
    private String secondary;
    private Thread thread;
    private boolean stopped = false;
    private boolean connected = false;
    private boolean connectionFailureSent = false;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$net$CommunicationsManager != null ? class$com$apple$xsr$net$CommunicationsManager : (class$com$apple$xsr$net$CommunicationsManager = CommunicationsManager.class$("com.apple.xsr.net.CommunicationsManager")));
    static /* synthetic */ Class class$com$apple$xsr$net$CommunicationsManager;

    public CommunicationsManager(RaidSystem system) {
        this.system = system;
        this.thread = new Thread(this);
        this.thread.setName("CommMgr");
        this.thread.start();
    }

    public void postMessageAsync(CommunicationHandler handler, RequestMessage message) {
        this.postMessageAsync(handler, message, null);
    }

    public void postMessageAsync(CommunicationHandler handler, RequestMessage message, Object context) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(new Transaction(handler, (RequestMessage)message.clone(), context));
            this.queue.notifyAll();
        }
    }

    public Response postMessage(RequestMessage message) throws IOException {
        if (this.isStopped()) {
            throw new CommShutdownException();
        }
        SyncSender sender = new SyncSender((RequestMessage)message.clone());
        Response response = sender.getResponse();
        if (response != null) {
            if (response.getException() != null) {
                Exception e = response.getException();
                if (e instanceof ConnectException) {
                    throw (ConnectException)e;
                }
                if (e instanceof CommShutdownException) {
                    throw (CommShutdownException)e;
                }
                throw new IOException(response.getException().getMessage());
            }
        } else {
            logger.error("Reponse for sync postMessage was null");
        }
        return response;
    }

    public synchronized boolean isConnected() {
        return this.connected && this.connection != null;
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized void exit() {
        this.shutdown();
    }

    public synchronized void shutdown() {
        this.stopped = true;
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.notifyAll();
        }
    }

    public void run() {
        try {
            while (true) {
                Transaction transaction;
                LinkedList linkedList = this.queue;
                synchronized (linkedList) {
                    while (this.queue.size() == 0 && !this.isStopped()) {
                        this.queue.wait();
                    }
                    if (this.queue.size() == 0 && this.isStopped()) {
                        Object var3_3 = null;
                        break;
                    }
                    transaction = (Transaction)this.queue.removeFirst();
                }
                if (logger.isDebugEnabled()) {
                    RequestMessage r = transaction.getMessage();
                    String c = r.getCommand();
                    RequestMessage.Target t = r.getTargetController();
                    logger.info("TX: Sending " + r.getPath() + (c != null ? "/" + c : "") + " to " + (t != null ? String.valueOf(String.valueOf(t)) : "default"));
                }
                CommunicationHandler handler = transaction.getHandler();
                PropertyList plist = null;
                BasicResponse response = null;
                try {
                    if (!this.isConnected() && !this.isStopped()) {
                        this.doConnect(handler);
                    }
                    if (!this.isStopped()) {
                        RequestMessage request = transaction.getMessage();
                        plist = this.connection.send(transaction.getMessage());
                        response = new BasicResponse(2, plist);
                    } else if (!this.connectionFailureSent) {
                        CommShutdownException exception = new CommShutdownException();
                        response = new BasicResponse(2, null, -102, exception);
                    }
                }
                catch (MalformedInputException e) {
                    logger.error((Object)e, e);
                    response = new BasicResponse(2, null, -102, (Exception)((Object)e));
                }
                catch (IOException e) {
                    if (e.getMessage().startsWith("PropertyListException")) {
                        response = new BasicResponse(2, null, -103, e);
                        logger.error(e, e);
                    }
                    Object object = this;
                    synchronized (object) {
                        this.connected = false;
                    }
                    object = this.queue;
                    synchronized (object) {
                        this.queue.addFirst(transaction);
                    }
                    logger.error(e, e);
                    this.system.setUserMessageIndex(5);
                    this.doConnect(handler);
                    handler = null;
                }
                catch (Exception e) {
                    logger.error(e, e);
                    response = new BasicResponse(2, null, -102, e);
                }
                if (handler != null && response != null) {
                    handler.handleResponse(this.system, response, transaction.getContext());
                }
                this.connectionFailureSent = false;
            }
        }
        catch (InterruptedException interruptedException) {}
        logger.info("Message dispatching stopped");
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {}
    }

    private void doConnect(CommunicationHandler handler) {
        String address = null;
        long attempts = 0L;
        int interfacesAvailable = 0;
        boolean failurePosted = false;
        this.connectionFailureSent = false;
        long delay = 5000L + (long)(Math.random() * 5000.0);
        while (!this.isStopped()) {
            BasicResponse response;
            Object e;
            String primary = this.system.getPrimaryHostAddress();
            String secondary = this.system.getSecondaryHostAddress();
            if (this.isValidAddress(primary) && this.isValidAddress(secondary)) {
                String secondAddressToTry;
                String firstAddressToTry;
                interfacesAvailable = 2;
                String previousAddress = null;
                if (this.connection != null) {
                    previousAddress = this.connection.getHostAddress();
                }
                if (previousAddress == null) {
                    firstAddressToTry = primary;
                    secondAddressToTry = secondary;
                } else if (previousAddress.equals(primary)) {
                    firstAddressToTry = secondary;
                    secondAddressToTry = primary;
                } else {
                    firstAddressToTry = primary;
                    secondAddressToTry = secondary;
                }
                address = (attempts & 1L) == 0L ? firstAddressToTry : secondAddressToTry;
                logger.info("Attempt " + attempts + " to connect to " + address + " (" + (address.equals(primary) ? "primary" : "secondary") + ")");
            } else if (this.isValidAddress(primary)) {
                interfacesAvailable = 1;
                address = primary;
                logger.info("Attempt " + attempts + " to connect to " + address + " (secondary not available)");
            } else if (this.isValidAddress(secondary)) {
                interfacesAvailable = 1;
                address = secondary;
                logger.info("Attempt " + attempts + " to connect to " + address + " (primary not available)");
            } else {
                String msg = "No valid host address for system \"" + this.system.getName() + "\"";
                e = new ConnectException(msg);
                response = new BasicResponse(0, null, -101, (Exception)e);
                logger.error(msg);
                handler.handleResponse(this.system, response, null);
                return;
            }
            try {
                this.connection = new AcpxConnection(address);
                this.system.setHostAddress(address);
                this.system.setPollingEnabled(true);
                CommunicationsManager msg = this;
                synchronized (msg) {
                    this.connected = true;
                }
                logger.info("Connected to " + address + " successfully");
                return;
            }
            catch (IOException e2) {
                e = this;
                synchronized (e) {
                    this.connected = false;
                }
                if (!(failurePosted || handler == null || interfacesAvailable >= 2 && ++attempts <= 1L)) {
                    ConnectException exception = new ConnectException(e2.getMessage());
                    response = new BasicResponse(0, null, -101, exception);
                    handler.handleResponse(this.system, response, null);
                    failurePosted = true;
                    this.connectionFailureSent = true;
                }
                if (this.isStopped()) break;
                logger.warn("Failed to connect to " + address + ". Will retry in " + delay / 1000L + " secs.");
                try {
                    Thread.sleep(delay);
                    if (delay > 3600000L) continue;
                    delay = delay * 3L / 2L + 1L;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        logger.info("Stopped while attempting to connect to " + address);
    }

    private boolean isValidAddress(String address) {
        if (address == null || address.length() < 7) {
            return false;
        }
        return !address.equals("0.0.0.0");
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static class Transaction {
        CommunicationHandler handler;
        RequestMessage message;
        Object context;

        public Transaction(CommunicationHandler handler, RequestMessage message, Object context) {
            this.handler = handler;
            this.message = message;
            this.context = context;
        }

        public CommunicationHandler getHandler() {
            return this.handler;
        }

        public RequestMessage getMessage() {
            return this.message;
        }

        public Object getContext() {
            return this.context;
        }
    }

    private class SyncSender
    implements CommunicationHandler {
        Response response;
        boolean handled = false;

        public SyncSender(RequestMessage request) {
            CommunicationsManager.this.postMessageAsync(this, request);
            SyncSender syncSender = this;
            synchronized (syncSender) {
                while (!this.handled) {
                    try {
                        if (Thread.currentThread() == CommunicationsManager.this.thread) {
                            throw new IllegalStateException("Attempt to post message synchronously from handler callback");
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptedIOException exception = new InterruptedIOException("communications shutdown");
                        this.response = new BasicResponse(2, null, -102, exception);
                        this.handled = true;
                        break;
                    }
                }
            }
        }

        public synchronized void handleResponse(RaidSystem system, Response response, Object context) {
            this.response = response;
            this.handled = true;
            this.notifyAll();
        }

        public synchronized Response getResponse() {
            return this.response;
        }
    }
}

