/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.xsr.net.HttpConnection;
import com.apple.xsr.net.HttpMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.ProtocolException;
import org.apache.log4j.Logger;

public class HttpResponse
extends HttpMessage {
    private HttpConnection connection;
    private InputStream inStream;
    private HttpInputStream httpInputStream;
    private boolean close = false;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$net$HttpResponse != null ? class$com$apple$xsr$net$HttpResponse : (class$com$apple$xsr$net$HttpResponse = HttpResponse.class$("com.apple.xsr.net.HttpResponse")));
    static /* synthetic */ Class class$com$apple$xsr$net$HttpResponse;

    HttpResponse(HttpConnection connection) throws IOException {
        if (connection == null) {
            throw new NullPointerException("connection cannot be null");
        }
        this.connection = connection;
        this.inStream = this.connection.getInputStream();
        this.parseHeaders();
    }

    public InputStream getInputStream() throws IOException {
        if (this.httpInputStream == null) {
            this.httpInputStream = new HttpInputStream(this.getBody());
        }
        return this.httpInputStream;
    }

    public byte[] getBody() throws IOException {
        int length = 0;
        String l = this.getHeaderField("Content-Length");
        if (l != null) {
            this.contentLength = length = Integer.parseInt(l);
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(length);
        try {
            int i = length;
            while (i > 0) {
                int b = this.inStream.read();
                if (b == -1) {
                    throw new IOException("Premature end of stream. Content-Length = " + length + ". Actual bytes = " + (length - i));
                }
                bytes.write(b);
                --i;
            }
        }
        finally {
            Object var6_8 = null;
            if (!this.connection.isPersistent() || this.close) {
                try {
                    this.inStream.close();
                }
                catch (IOException ignored) {
                    logger.error("Should not happen: " + ignored);
                }
            }
        }
        this.connection.setRequestOutstanding(false);
        return bytes.toByteArray();
    }

    private void parseHeaders() throws IOException {
        String line;
        String startLine = this.readLine();
        if (startLine.equals("")) {
            logger.error("Expected HTTP start line");
            throw new EOFException("Expected HTTP start line");
        }
        while (!(line = this.readLine()).equals("")) {
            int i = line.indexOf(58);
            if (i != -1 && i > 0) {
                String key = line.substring(0, i).trim();
                String value = line.substring(i + 1).trim();
                this.setHeaderField(key, value);
                if (!key.toLowerCase().equals("connection") || !value.toLowerCase().equals("close")) continue;
                this.close = true;
                continue;
            }
            throw new ProtocolException("Invalid HTTP header: " + line);
        }
    }

    private String readLine() throws IOException {
        StringWriter line = new StringWriter();
        boolean eol = false;
        while (true) {
            int b;
            if ((b = this.inStream.read()) == -1) {
                logger.warn("Hit end-of-stream");
                break;
            }
            if (b == 10 || b == 13) {
                if (eol) break;
                eol = true;
                continue;
            }
            line.write(b);
        }
        return line.toString();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private class HttpInputStream
    extends ByteArrayInputStream {
        public HttpInputStream(byte[] buf) {
            super(buf);
        }

        public void close() throws IOException {
            super.close();
            HttpResponse.this.connection.setRequestOutstanding(false);
        }
    }
}

