/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;

public class Disk
extends AbstractSystemElement
implements Comparable {
    public static final int STATE_EMPTY = -2;
    public static final int STATE_OFFLINE = 0;
    public static final int STATE_ONLINE = 1;
    public static final int STATE_PREDICTIVE_FAILURE = 2;
    public static final int OFFLINE = 0;
    public static final int ONLINE = 1;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_UNASSIGNED = 0;
    public static final int TYPE_RAID_MEMBER = 1;
    public static final int TYPE_SPARE = 0;
    public static final int TYPE_JBOD = 3;
    public static final int TYPE_ORPHAN = 4;
    public static final int RAID_SET_NONE = -2;
    public static final int OP_NONE = 0;
    public static final int OP_REBUILDING = 1;
    public static final int OP_INITIALIZING = 2;
    private static final int SMART_NUM_ATTR = 30;
    private static final int SMART_ATTR_SIZE = 12;
    private static final int SMART_POWER_ON_HOURS_ATTR_ID = 9;
    private static final int SMART_BUFFER_SIZE = 512;
    private static final String IBM_MODEL = "IBM";
    private static final String HITACHI_MODEL = "Hitachi";
    private static final String HITACHI_VANCOUVER_4_MODEL = "HDT";
    private static final String MAXTOR_MODEL = "Maxtor";
    public static final int CACHE_DISABLED = 0;
    public static final int CACHE_ENABLED = 1;
    public static final int SMART_THRESHOLD_NOT_EXCEEDED = 0;
    public static final int SMART_STATUS_OK = 0;
    public static final int SMART_THRESHOLD_EXCEEDED = 2;
    public static final int BLOCK_SIZE = 512;
    public static final int MEMBER_STATE_NORMAL = 0;
    public static final int MEMBER_STATE_ORPHANED = 1;
    public static final int MEMBER_STATE_RAID_SET_ID_CONFLICT = 2;
    public static final int MEMBER_STATE_RAID_MEMBER_CONFLICT = 3;
    public static final int MEMBER_STATE_HOT_PLUG = 4;
    public static final int RAID_TYPE_REGULAR = 0;
    public static final int RAID_TYPE_RAID_NOW = 1;
    public static final int HANDLE_OPEN = 0;
    public static final int HANDLE_CLOSED = 1;
    private int handleState = -1;
    private int nativeId;
    private int id;
    private int state = -1;
    private int type = -1;
    private int operation = -1;
    private long capacity = -1L;
    private int raidset = -1;
    private String vendor = "";
    private String product = "";
    private String revision = "";
    private int badBlockCount = -1;
    private int remappedBlockCount = -1;
    private int cacheState = -1;
    private int smartStatus = -1;
    private byte[] smartData = null;
    private int powerOnHours = -1;
    private OrphanMemberInfo orphanMemberInfo = null;
    RaidController controller;

    public Disk(int id, RaidController controller) {
        if (controller == null) {
            throw new NullPointerException("controller cannot be null");
        }
        this.nativeId = id;
        this.controller = controller;
        int controllerId = this.controller.getId();
        if (controllerId == 1) {
            this.id = this.nativeId;
        } else if (controllerId == 2) {
            this.id = this.nativeId + 7;
        } else {
            throw new IllegalArgumentException("Unrecognized RAID controller \"" + controller + "\"");
        }
    }

    public Disk(Disk disk) {
        this.nativeId = disk.nativeId;
        this.id = disk.id;
        this.state = disk.state;
        this.type = disk.type;
        this.operation = disk.operation;
        this.capacity = disk.capacity;
        this.raidset = disk.raidset;
        this.vendor = disk.vendor;
        this.product = disk.product;
        this.revision = disk.revision;
        this.badBlockCount = disk.badBlockCount;
        this.remappedBlockCount = disk.remappedBlockCount;
        this.cacheState = disk.cacheState;
        this.smartStatus = disk.smartStatus;
        this.smartData = disk.smartData != null ? (byte[])disk.smartData.clone() : null;
        this.powerOnHours = disk.powerOnHours;
        this.handleState = disk.handleState;
        this.orphanMemberInfo = disk.orphanMemberInfo != null ? new OrphanMemberInfo(disk.orphanMemberInfo) : null;
        this.controller = disk.controller;
    }

    public int getNativeId() {
        return this.nativeId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "Disk " + this.getId();
    }

    public int getStatus() {
        if (this.state == 1) {
            if (this.smartStatus == 2) {
                return 1;
            }
            return 0;
        }
        if (this.state == 0 && this.type == 1) {
            return 2;
        }
        return -1;
    }

    void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    void setOperation(int operation) {
        this.operation = operation;
    }

    public int getOperation() {
        return this.operation;
    }

    void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getCapacityBytes() {
        return this.capacity * 512L;
    }

    void setRaidSet(int raidsetId) {
        this.raidset = raidsetId;
    }

    public RaidSet getRaidSet() {
        if (this.raidset != -2) {
            return this.controller.getRaidSet(this.raidset);
        }
        return null;
    }

    void setVendor(String vendor) {
        if (vendor == null) {
            throw new NullPointerException("vendor cannot be null");
        }
        this.vendor = vendor;
    }

    public String getVendor() {
        return this.vendor;
    }

    void setModel(String model) {
        if (model == null) {
            throw new NullPointerException("model cannot be null");
        }
        this.product = model;
    }

    public String getModel() {
        return this.product;
    }

    void setRevision(String revision) {
        if (revision == null) {
            throw new NullPointerException("revision cannot be null");
        }
        this.revision = revision;
    }

    public String getRevision() {
        return this.revision;
    }

    void setBadBlockCount(int count) {
        this.badBlockCount = count;
    }

    public int getBadBlockCount() {
        return this.badBlockCount;
    }

    void setRemappedBlockCount(int count) {
        this.remappedBlockCount = count;
    }

    public int getRemappedBlockCount() {
        return this.remappedBlockCount;
    }

    void setCacheState(int state) {
        if (state != 0 && state != 1 && state != -1) {
            throw new IllegalArgumentException("Illegal cache state: " + state);
        }
        this.cacheState = state;
    }

    public int getCacheState() {
        return this.cacheState;
    }

    public void setSmartData(byte[] data) {
        this.smartData = data;
        int hours = this.parsePowerOnHoursFromSmartData(data);
        this.setPowerOnHours(hours);
    }

    public byte[] getSmartData() {
        return this.smartData;
    }

    protected void setPowerOnHours(int hours) {
        this.powerOnHours = hours;
    }

    public int getPowerOnHours() {
        return this.powerOnHours;
    }

    void setSmartStatus(int status) {
        if (status != 0 && status != 2 && status != -1) {
            throw new IllegalArgumentException("Illegal SMART status (" + status + ")");
        }
        this.smartStatus = status;
    }

    public int getSmartStatus() {
        return this.smartStatus;
    }

    void setOrphanRaidMember(OrphanMemberInfo info) {
        this.orphanMemberInfo = info;
        if (info != null) {
            this.type = 4;
        }
    }

    public boolean isOrphanRaidMember() {
        return this.orphanMemberInfo != null;
    }

    public int getMemberState() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.memberState : -1;
    }

    public long getFloatingId() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.floatingId : -1L;
    }

    public long getMetaDataUpdateCount() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.metaDataUpdateCount : -1L;
    }

    public int getOrphanRaidSetId() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.raidSetId : -1;
    }

    public int getOrphanRaidLevel() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.raidLevel : -1;
    }

    public int getOrphanRaidMemberCount() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.diskCount : -1;
    }

    public int getOrphanRaidMemberIndex() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.memberIndex : -1;
    }

    public int getOrphanRaidType() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.raidType : -1;
    }

    public String getRaidControllerSerialNumber() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.serialNumber : "";
    }

    public RaidController getRaidController() {
        return this.controller;
    }

    void setHandleState(int state) {
        if (state != 0 && state != 1 && state != -1) {
            throw new IllegalArgumentException("illegal handle state (" + state + ")");
        }
        this.handleState = state;
    }

    public int getHandleState() {
        return this.handleState;
    }

    protected int parsePowerOnHoursFromSmartData(byte[] smartData) {
        int hours = -1;
        String model = this.getModel();
        if (model.regionMatches(0, IBM_MODEL, 0, IBM_MODEL.length()) || model.regionMatches(0, MAXTOR_MODEL, 0, MAXTOR_MODEL.length()) || model.regionMatches(0, HITACHI_MODEL, 0, HITACHI_MODEL.length()) || model.regionMatches(0, HITACHI_VANCOUVER_4_MODEL, 0, HITACHI_VANCOUVER_4_MODEL.length())) {
            int offset = 2;
            if (smartData != null && smartData.length == 512) {
                int i = 0;
                while (i < 30) {
                    if (smartData[offset] == 9) {
                        hours = (smartData[offset + 8] >= 0 ? smartData[offset + 8] : smartData[offset + 8] + 256) << 24 | (smartData[offset + 7] >= 0 ? smartData[offset + 7] : smartData[offset + 7] + 256) << 16 | (smartData[offset + 6] >= 0 ? smartData[offset + 6] : smartData[offset + 6] + 256) << 8 | (smartData[offset + 5] >= 0 ? smartData[offset + 5] : smartData[offset + 5] + 256);
                        if (model.regionMatches(0, MAXTOR_MODEL, 0, MAXTOR_MODEL.length())) {
                            hours /= 60;
                        }
                    } else {
                        offset += 12;
                    }
                    ++i;
                }
            }
        }
        return hours;
    }

    void clear() {
        this.state = -1;
        this.type = -1;
        this.operation = -1;
        this.capacity = -1L;
        this.raidset = -1;
        this.vendor = "";
        this.product = "";
        this.revision = "";
        this.remappedBlockCount = -1;
        this.smartStatus = -1;
        this.orphanMemberInfo = null;
        this.handleState = -1;
    }

    public int compareTo(Object o) {
        Disk disk = (Disk)o;
        return this.id - disk.id;
    }

    public String paramString() {
        String s = "";
        s = String.valueOf(s) + "nativeId=" + this.nativeId + ",";
        s = String.valueOf(s) + "id=" + this.id + ",";
        s = String.valueOf(s) + "state=" + this.state + ",";
        s = String.valueOf(s) + "type=" + this.type + ",";
        s = String.valueOf(s) + "operation=" + this.operation + ",";
        s = String.valueOf(s) + "capacity=" + this.capacity + ",";
        s = String.valueOf(s) + "raidset=" + this.raidset + ",";
        s = String.valueOf(s) + "vendor=" + this.vendor + ",";
        s = String.valueOf(s) + "model=" + this.product + ",";
        s = String.valueOf(s) + "revision=" + this.revision + ",";
        s = String.valueOf(s) + "badBlockCount=" + this.badBlockCount + ",";
        s = String.valueOf(s) + "remappedBlockCount=" + this.remappedBlockCount + ",";
        s = String.valueOf(s) + "cacheState=" + this.cacheState + ",";
        s = String.valueOf(s) + "smartStatus=" + this.smartStatus + ",";
        s = String.valueOf(s) + this.orphanMemberInfo + ",";
        s = String.valueOf(s) + "handleState=" + this.handleState;
        return s;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }

    public static class OrphanMemberInfo {
        public int memberState = -1;
        public long floatingId = -1L;
        public long metaDataUpdateCount = -1L;
        public int raidSetId = -1;
        public int raidLevel = -1;
        public int diskCount = -1;
        public int memberIndex = -1;
        public int raidType = -1;
        public String serialNumber = "";

        public OrphanMemberInfo() {
        }

        public OrphanMemberInfo(int memberState, long floatingId, long metaDataUpdateCount, int raidSetId, int raidLevel, int diskCount, int memberIndex, int raidType, String serialNumber) {
            this.memberState = memberState;
            this.floatingId = floatingId;
            this.metaDataUpdateCount = metaDataUpdateCount;
            this.raidSetId = raidSetId;
            this.raidLevel = raidLevel;
            this.diskCount = diskCount;
            this.memberIndex = memberIndex;
            this.raidType = raidType;
            this.serialNumber = serialNumber;
        }

        public OrphanMemberInfo(OrphanMemberInfo orphanMemberInfo) {
            this.memberState = orphanMemberInfo.memberState;
            this.floatingId = orphanMemberInfo.floatingId;
            this.metaDataUpdateCount = orphanMemberInfo.metaDataUpdateCount;
            this.raidSetId = orphanMemberInfo.raidSetId;
            this.raidLevel = orphanMemberInfo.raidLevel;
            this.diskCount = orphanMemberInfo.diskCount;
            this.memberIndex = orphanMemberInfo.memberIndex;
            this.raidType = orphanMemberInfo.raidType;
            this.serialNumber = orphanMemberInfo.serialNumber;
        }

        public String toString() {
            String s = "";
            s = String.valueOf(s) + "memberState=" + this.memberState;
            s = String.valueOf(s) + ",floatingId=" + this.floatingId;
            s = String.valueOf(s) + ",metaDataUpdateCount=" + this.metaDataUpdateCount;
            s = String.valueOf(s) + ",raidSetId=" + this.raidSetId;
            s = String.valueOf(s) + ",raidLevel=" + this.raidLevel;
            s = String.valueOf(s) + ",diskCount=" + this.diskCount;
            s = String.valueOf(s) + ",memberIndex=" + this.memberIndex;
            s = String.valueOf(s) + ",raidType=" + this.raidType;
            s = String.valueOf(s) + ",serialNumber=" + this.serialNumber;
            return s;
        }
    }
}

