/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.RaidController;

public class DiskSlot
extends AbstractSystemElement
implements Comparable {
    private int nativeId;
    private int id;
    private int dmaMode = -1;
    private int ultraDmaMode = -1;
    private boolean populated = false;
    private Disk disk;
    RaidController controller;

    public DiskSlot(int id, RaidController controller) {
        if (controller == null) {
            throw new NullPointerException("controller cannot be null");
        }
        this.nativeId = id;
        this.controller = controller;
        int controllerId = this.controller.getId();
        if (controllerId == 1) {
            this.id = this.nativeId;
        } else if (controllerId == 2) {
            this.id = this.nativeId + 7;
        } else {
            throw new IllegalArgumentException("Unrecognized RAID controller \"" + controller + "\"");
        }
    }

    public DiskSlot(DiskSlot diskSlot) {
        this.nativeId = diskSlot.nativeId;
        this.id = diskSlot.id;
        this.dmaMode = diskSlot.dmaMode;
        this.ultraDmaMode = diskSlot.ultraDmaMode;
        this.populated = diskSlot.populated;
        this.disk = diskSlot.disk;
        this.controller = diskSlot.controller;
    }

    public int getNativeId() {
        return this.nativeId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "Disk Slot " + this.id;
    }

    public int getStatus() {
        return 0;
    }

    void setDmaMode(int mode) {
        this.dmaMode = mode;
    }

    public int getDmaMode() {
        return this.dmaMode;
    }

    void setUltraDmaMode(int mode) {
        this.ultraDmaMode = mode;
    }

    public int getUltraDmaMode() {
        return this.ultraDmaMode;
    }

    void setDisk(Disk disk) {
        this.disk = disk;
    }

    public Disk getDisk() {
        return this.disk;
    }

    void setPopulated(boolean populated) {
        this.populated = populated;
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public RaidController getRaidController() {
        return this.controller;
    }

    public int compareTo(Object o) {
        DiskSlot slot = (DiskSlot)o;
        return this.id - slot.id;
    }

    public String paramString() {
        String s = "";
        s = String.valueOf(s) + "nativeId=" + this.nativeId + ",";
        s = String.valueOf(s) + "id=" + this.id + ",";
        s = String.valueOf(s) + "dmaMode=" + this.dmaMode + ",";
        s = String.valueOf(s) + "ultraDmaMode=" + this.ultraDmaMode + ",";
        s = String.valueOf(s) + "populated=" + this.populated + ",";
        s = String.valueOf(s) + "disk=" + this.disk;
        return s;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }
}

