/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.HostInterface;
import com.apple.xsr.som.RaidController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class FibreChannelInterface
extends HostInterface {
    public static final int LINK_DOWN = 0;
    public static final int LINK_UP = 1;
    public static final int TOPOLOGY_ARBITRATED_LOOP = 0;
    public static final int TOPOLOGY_POINT_TO_POINT = 1;
    public static final int TOPOLOGY_AUTO_DETECT = 2;
    public static final int LUN_MIN_ID = 1;
    public static final int LUN_MAX_ID = 8;
    public static final int HARD_LOOP_DISABLED = 0;
    public static final int HARD_LOOP_ENABLED = 1;
    private int linkState = -1;
    private String wwn = "";
    private String wwpn = "";
    private String wwnn = "";
    private int topology = -1;
    private int actualTopology = -1;
    private int hardLoopId = -1;
    private int hardLoopIdEnabled = -1;
    private int protocolErrorCount = -1;
    private int invalidTransmissionWordCount = -1;
    private int invalidCrcCount = -1;
    private int lossOfSignalCount = -1;
    private int lossOfSyncCount = -1;
    private int linkFailureCount = -1;
    private Map lunMap = new TreeMap();
    private ArrayList lunMaskHostList = new ArrayList();

    public FibreChannelInterface(int id, RaidController controller) {
        super(id, controller);
        int i = 1;
        while (i <= 8) {
            Lun l = new Lun(null, i);
            this.lunMap.put(new Integer(l.id), l);
            ++i;
        }
    }

    public FibreChannelInterface(FibreChannelInterface fibreChannelInterface) {
        super(fibreChannelInterface);
        this.linkState = fibreChannelInterface.linkState;
        this.wwn = fibreChannelInterface.wwn;
        this.wwpn = fibreChannelInterface.wwpn;
        this.wwnn = fibreChannelInterface.wwnn;
        this.topology = fibreChannelInterface.topology;
        this.actualTopology = fibreChannelInterface.actualTopology;
        this.hardLoopId = fibreChannelInterface.hardLoopId;
        this.hardLoopIdEnabled = fibreChannelInterface.hardLoopIdEnabled;
        this.protocolErrorCount = fibreChannelInterface.protocolErrorCount;
        this.invalidTransmissionWordCount = fibreChannelInterface.invalidTransmissionWordCount;
        this.invalidCrcCount = fibreChannelInterface.invalidCrcCount;
        this.lossOfSignalCount = fibreChannelInterface.lossOfSignalCount;
        this.lossOfSyncCount = fibreChannelInterface.lossOfSyncCount;
        this.linkFailureCount = fibreChannelInterface.linkFailureCount;
        this.lunMap = (Map)((TreeMap)fibreChannelInterface.lunMap).clone();
        this.lunMaskHostList = (ArrayList)fibreChannelInterface.lunMaskHostList.clone();
    }

    public String getName() {
        return "Fibre Channel Interface " + this.id;
    }

    public int getStatus() {
        Collection localRaidSets;
        Collection drives;
        int status = this.linkState == 1 ? 0 : (this.linkState == -1 ? -1 : ((drives = this.controller.getDisks()) == null ? 0 : (drives.size() > 0 ? ((localRaidSets = this.controller.getRaidSets()) == null ? 1 : (localRaidSets.size() > 0 ? 2 : 1)) : 0)));
        return status;
    }

    void setLinkState(int state) {
        this.linkState = state;
    }

    public int getLinkState() {
        return this.linkState;
    }

    void setWorldWidePortName(String wwpn) {
        String wwnn;
        this.wwpn = wwpn;
        int index = wwpn.indexOf(":");
        String substring = wwpn.substring(0, index);
        int octet = Integer.parseInt(substring, 16);
        if (!wwpn.startsWith("50")) {
            octet -= 16;
        }
        this.wwnn = wwnn = String.valueOf(Integer.toString(octet, 16)) + wwpn.substring(index);
    }

    public String getWorldWidePortName() {
        return this.wwpn;
    }

    void setWorldWideNodeName(String wwnn) {
        this.wwnn = wwnn;
    }

    public String getWorldWideNodeName() {
        return this.wwnn;
    }

    void setTopology(int topology) {
        if (topology != 0 && topology != 1 && topology != 2 && topology != -1) {
            throw new IllegalArgumentException("illegal topology " + topology);
        }
        this.topology = topology;
    }

    public int getTopology() {
        return this.topology;
    }

    void setActualTopology(int topology) {
        if (topology != 0 && topology != 1 && topology != -1) {
            throw new IllegalArgumentException("illegal topology " + topology);
        }
        this.actualTopology = topology;
    }

    public int getActualTopology() {
        return this.actualTopology;
    }

    void setHardLoopId(int id) {
        this.hardLoopId = id;
    }

    public int getHardLoopId() {
        return this.hardLoopId;
    }

    void setHardLoopIdEnabled(int state) {
        this.hardLoopIdEnabled = state;
    }

    public int getHardLoopIdEnabled() {
        return this.hardLoopIdEnabled;
    }

    void setProtocolErrorCount(int count) {
        this.protocolErrorCount = count;
    }

    public int getProtocolErrorCount(int count) {
        return this.protocolErrorCount;
    }

    void setInvalidTransmissionWordCount(int count) {
        this.invalidTransmissionWordCount = count;
    }

    public int getInvalidTransmissionWordCount() {
        return this.invalidTransmissionWordCount;
    }

    void setInvalidCyclicRedundancyCodeCount(int count) {
        this.invalidCrcCount = count;
    }

    public int getInvalidCyclicRedundancyCodeCount() {
        return this.invalidCrcCount;
    }

    void setLossOfSignalCount(int count) {
        this.lossOfSignalCount = count;
    }

    public int getLossOfSignalCount() {
        return this.lossOfSignalCount;
    }

    void setLossOfSyncCount(int count) {
        this.lossOfSyncCount = count;
    }

    public int getLossOfSyncCount() {
        return this.lossOfSyncCount;
    }

    void setLinkFailureCount(int count) {
        this.linkFailureCount = count;
    }

    public int getLinkFailureCount() {
        return this.linkFailureCount;
    }

    void setLunMaskList(ArrayList list) {
        this.lunMaskHostList = list;
    }

    public ArrayList getLunMaskList() {
        return this.lunMaskHostList;
    }

    public Lun getLun(int id) {
        return (Lun)this.lunMap.get(new Integer(id));
    }

    void mapLun(int lunId, int raidSetId) {
        Lun l = this.getLun(lunId);
        if (l == null) {
            throw new IllegalArgumentException("Invalid LUN ID " + lunId);
        }
        l.raidset = raidSetId;
    }

    public String paramString() {
        String s = String.valueOf(super.paramString()) + ",";
        s = String.valueOf(s) + "linkState=" + this.linkState + ",";
        s = String.valueOf(s) + "wwn=" + this.wwn + ",";
        s = String.valueOf(s) + "topology=" + this.topology + ",";
        s = String.valueOf(s) + "hardLoopId=" + this.hardLoopId + ",";
        s = String.valueOf(s) + "hardLoopIdEnabled=" + this.hardLoopIdEnabled + ",";
        s = String.valueOf(s) + "protocolErrorCount=" + this.protocolErrorCount + ",";
        s = String.valueOf(s) + "invalidTransmissionWordCount=" + this.invalidTransmissionWordCount + ",";
        s = String.valueOf(s) + "invalidCrcCount=" + this.invalidCrcCount + ",";
        s = String.valueOf(s) + "lossOfSignalCount=" + this.lossOfSignalCount + ",";
        s = String.valueOf(s) + "lossOfSyncCount=" + this.lossOfSyncCount + ",";
        s = String.valueOf(s) + "linkFailureCount=" + this.linkFailureCount + ",";
        Iterator iter = this.lunMap.values().iterator();
        while (iter.hasNext()) {
            s = String.valueOf(s) + iter.next();
            if (!iter.hasNext()) continue;
            s = String.valueOf(s) + ",";
        }
        return s;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }

    public static final class Lun {
        public static final int NOT_MAPPED = -1;
        private int id;
        private int raidset = -1;

        private Lun(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public int getRaidSet() {
            return this.raidset;
        }

        public String paramString() {
            String s = "";
            s = String.valueOf(s) + "id=" + this.id + ",";
            s = String.valueOf(s) + "raidSet=" + this.raidset;
            return s;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
        }

        /* synthetic */ Lun(1 $0, int $1) {
            this($1);
        }

        static /* synthetic */ int access$1(Lun $0) {
            return $0.raidset;
        }
    }

    static class 1 {
        /* synthetic */ 1() {
        }
    }
}

