/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.RaidController;

public abstract class HostInterface
extends AbstractSystemElement
implements Comparable {
    public static final int SPEED_AUTO = 0;
    public static final int SPEED_1GBPS = 1;
    public static final int SPEED_2GBPS = 2;
    protected int nativeId;
    protected int id;
    protected int speed = -1;
    protected int actualSpeed = -1;
    protected int maxSpeed = -1;
    RaidController controller;

    public HostInterface(int id, RaidController controller) {
        this.nativeId = id;
        this.controller = controller;
        this.id = controller.getId();
    }

    public HostInterface(HostInterface hostInterface) {
        this.nativeId = hostInterface.nativeId;
        this.id = hostInterface.id;
        this.speed = hostInterface.speed;
        this.actualSpeed = hostInterface.actualSpeed;
        this.maxSpeed = hostInterface.maxSpeed;
        this.controller = hostInterface.controller;
    }

    public int getNativeId() {
        return this.nativeId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "Host Interface " + this.id;
    }

    public abstract int getStatus();

    void setSpeed(int speed) {
        if (speed != 0 && speed != 1 && speed != 2 && speed != -1) {
            throw new IllegalArgumentException("illegal speed " + speed);
        }
        this.speed = speed;
    }

    public int getSpeed() {
        return this.speed;
    }

    void setActualSpeed(int speed) {
        if (speed != 1 && speed != 2 && speed != -1) {
            throw new IllegalArgumentException("illegal speed " + speed);
        }
        this.actualSpeed = speed;
    }

    public int getActualSpeed() {
        return this.actualSpeed;
    }

    void setMaximumSpeed(int maxSpeed) {
        if (maxSpeed != 1 && maxSpeed != 2 && maxSpeed != -1) {
            throw new IllegalArgumentException("illegal maximum speed " + maxSpeed);
        }
        this.maxSpeed = maxSpeed;
    }

    public int getMaximumSpeed() {
        return this.maxSpeed;
    }

    public RaidController getController() {
        return this.controller;
    }

    public int compareTo(Object o) {
        HostInterface hostIf = (HostInterface)o;
        return this.id - hostIf.id;
    }

    public String paramString() {
        String s = "";
        s = String.valueOf(s) + "nativeId=" + this.nativeId + ",";
        s = String.valueOf(s) + "id=" + this.id + ",";
        s = String.valueOf(s) + "speed=" + this.speed + ",";
        s = String.valueOf(s) + "maxSpeed=" + this.maxSpeed;
        return s;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }
}

