/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.net.IPAddress;
import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.SystemController;
import java.net.UnknownHostException;

public class NetworkInterface
extends AbstractSystemElement
implements Comparable {
    public static final int LINK_DOWN = 0;
    public static final int LINK_UP = 1;
    public static final int DHCP = 512;
    public static final int STATIC = 1024;
    public static final int BOOTP = 8192;
    private static final int CONFIGURATION_METHOD_DYNAMIC = 256;
    public static final int SPEED_10MBIT = 0;
    public static final int SPEED_100MBIT = 1;
    public static final int SPEED_1000MBIT = 2;
    public static final int SPEED_1GBIT = 2;
    public static final int DUPLEX_HALF = 0;
    public static final int DUPLEX_FULL = 1;
    private int nativeId;
    private int id;
    private int status = -1;
    private int linkState = -1;
    private int configurationMethod = -1;
    private String macAddress;
    private IPAddress address;
    private IPAddress subnetMask;
    private IPAddress gatewayAddress;
    private IPAddress[] dns = new IPAddress[0];
    private int speed = -1;
    private int maxSpeed = -1;
    private int duplex = -1;
    private String dhcpClientId = "";
    SystemController controller;

    public NetworkInterface(int id, SystemController controller) {
        if (controller == null) {
            throw new NullPointerException("controller cannot be null");
        }
        this.nativeId = id;
        this.controller = controller;
        this.id = controller.getId();
    }

    public NetworkInterface(NetworkInterface networkInterface) {
        this.nativeId = networkInterface.nativeId;
        this.id = networkInterface.id;
        this.status = networkInterface.status;
        this.linkState = networkInterface.linkState;
        this.configurationMethod = networkInterface.configurationMethod;
        this.macAddress = networkInterface.macAddress;
        this.address = networkInterface.address;
        this.subnetMask = networkInterface.subnetMask;
        this.gatewayAddress = networkInterface.gatewayAddress;
        this.dns = (IPAddress[])networkInterface.dns.clone();
        this.speed = networkInterface.speed;
        this.maxSpeed = networkInterface.maxSpeed;
        this.duplex = networkInterface.duplex;
        this.dhcpClientId = networkInterface.dhcpClientId;
        this.controller = networkInterface.controller;
    }

    public int getNativeId() {
        return this.nativeId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "Network Interface " + this.id;
    }

    void setStatus(int status) {
        if (status != 0 && status != 1 && status != 2 && status != -1) {
            throw new IllegalArgumentException("illegal status argument (" + status + ")");
        }
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    void setLinkState(int state) {
        this.linkState = state;
        this.status = state == 1 ? 0 : 1;
    }

    public int getLinkState() {
        return this.linkState;
    }

    void setConfigurationMethod(int method) {
        if (method != 512 && method != 1024 && method != 8192 && method != -1) {
            throw new IllegalArgumentException("illegal configuration method " + method);
        }
        this.configurationMethod = method;
    }

    public int getConfigurationMethod() {
        return this.configurationMethod;
    }

    void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getMacAddressString() {
        return this.macAddress != null ? this.macAddress.toString() : "";
    }

    void setAddress(String address) throws UnknownHostException {
        this.address = new IPAddress(address);
    }

    public IPAddress getAddress() {
        return this.address;
    }

    public String getAddressString() {
        return this.address != null ? this.address.toString() : "";
    }

    void setSubnetMask(String subnet) throws UnknownHostException {
        this.subnetMask = new IPAddress(subnet);
    }

    public IPAddress getSubnetMask() {
        return this.subnetMask;
    }

    public String getSubnetMaskString() {
        return this.subnetMask != null ? this.subnetMask.toString() : "";
    }

    void setGateway(String gateway) throws UnknownHostException {
        this.gatewayAddress = new IPAddress(gateway);
    }

    public IPAddress getGateway() {
        return this.gatewayAddress;
    }

    void setDns(String[] dns) throws UnknownHostException {
        IPAddress[] ip = new IPAddress[dns.length];
        int i = 0;
        while (i < dns.length) {
            if (dns[i] != null) {
                ip[i] = new IPAddress(dns[i]);
            }
            ++i;
        }
        this.dns = ip;
    }

    public IPAddress[] getDns() {
        if (this.dns != null) {
            return (IPAddress[])this.dns.clone();
        }
        return new IPAddress[0];
    }

    void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getSpeed() {
        return this.speed;
    }

    void setDuplex(int duplex) {
        this.duplex = duplex;
    }

    public int getDuplex() {
        return this.duplex;
    }

    void setDhcpClientId(String id) {
        this.dhcpClientId = id;
    }

    public String getDhcpClientId() {
        return this.dhcpClientId;
    }

    public int compareTo(Object o) {
        NetworkInterface networkIf = (NetworkInterface)o;
        return this.id - networkIf.id;
    }

    public String paramString() {
        String s = "";
        s = String.valueOf(s) + "id=" + this.id + ",";
        s = String.valueOf(s) + "linkState=" + this.linkState + ",";
        s = String.valueOf(s) + "configurationMethod=" + this.configurationMethod + ",";
        s = String.valueOf(s) + "macAddress=" + this.macAddress + ",";
        s = String.valueOf(s) + "address=" + this.address + ",";
        s = String.valueOf(s) + "subnetMask=" + this.subnetMask + ",";
        s = String.valueOf(s) + "gatewayAddress=" + this.gatewayAddress + ",";
        int i = 0;
        while (i < this.dns.length) {
            s = String.valueOf(s) + "dns" + (i + 1) + "=" + this.dns[i] + ",";
            ++i;
        }
        s = String.valueOf(s) + "speed=" + this.speed + ",";
        s = String.valueOf(s) + "maxSpeed=" + this.maxSpeed + ",";
        s = String.valueOf(s) + "duplex=" + this.duplex + ",";
        s = String.valueOf(s) + "dhcpClientId=" + this.dhcpClientId + ",";
        return s;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }
}

