/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.DiskSlot;
import com.apple.xsr.som.FibreChannelInterface;
import com.apple.xsr.som.HostInterface;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.Slice;
import com.apple.xsr.som.SystemEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class RaidController
extends AbstractSystemElement
implements Comparable {
    public static final int DISABLED = 0;
    public static final int ENABLED = 1;
    public static final int ACCESS_MODE_SEQUENTIAL = 0;
    public static final int ACCESS_MODE_RANDOM = 1;
    public static final int CONTROLLER_NOT_READY = 0;
    public static final int CONTROLLER_READY = 1;
    public static final int WRITE_CACHE_DISABLED = 0;
    public static final int WRITE_CACHE_ENABLED = 1;
    public static final int DISK_CHANNEL_MIN_ID = 1;
    public static final int DISK_CHANNEL_MAX_ID = 7;
    public static final int DISK_CHANNEL_COUNT = 7;
    public static final int HOST_INTERFACE_MIN_ID = 1;
    public static final int HOST_INTERFACE_MAX_ID = 1;
    public static final int HOST_INTERFACE_1 = 1;
    public static final int RAID_SET_MIN_ID = 1;
    public static final int RAID_SET_MAX_ID = 4;
    public static final int SLICE_MIN_ID = 0;
    public static final int SLICE_MAX_ID = 7;
    public static final int RAID_SET_MAX_SLICES = 8;
    public static final int LUN_MIN_ID = 0;
    public static final int LUN_MAX_ID = 7;
    public static final int LUN_MASK_DISABLED = 0;
    public static final int LUN_MASK_ENABLED = 1;
    public static final int NO_RAIDSET_ID_AVAILABLE = -1;
    private static final int REBUILD_RATE_MIN = 1;
    private static final int REBUILD_RATE_MAX = 7;
    private static final int[] STRIPE_SIZES = new int[]{8, 16, 32, 64, 128};
    private final int id;
    private String productId = "";
    private String modelName = "";
    private String serialNumber = "";
    private int stripeSize = -1;
    private int writeCacheState = -1;
    private int hostInterfaceCount = -1;
    private int diskChannelCount = -1;
    private int slotCount = -1;
    private int memorySize = -1;
    private int cacheHitRatio = -1;
    private int readyState = -1;
    private int clientCount = -1;
    private String firmwareVersion = "";
    private int accessMode = -1;
    private int prefetchSize = -1;
    private boolean autoRebuildEnabled = false;
    private int rebuildRate = -1;
    private boolean checkDataGenerationEnabled = false;
    private int lunMaskEnabled = -1;
    private boolean jbodMaskEnabled = true;
    private int jbodModeState = -1;
    private int slowReadBypassModeState = -1;
    private int diagnosticFunctionStatus = -1;
    private int cpuTemperature = -1;
    private int tempStatus = -1;
    private int bgrwConditioningPriority = -1;
    private int syncCacheState = -1;
    private final Map raidSets = new TreeMap();
    private final Map disks = new TreeMap();
    private final Map hostInterfaces = new TreeMap();
    private final Map slots = new TreeMap();
    RaidSystem system;

    public RaidController(int id, RaidSystem system) {
        if (system == null) {
            throw new NullPointerException("system cannot be null");
        }
        this.id = id;
        this.system = system;
        int i = 1;
        while (i <= 7) {
            DiskSlot slot = new DiskSlot(i, this);
            this.slots.put(new Integer(i), slot);
            Disk disk = new Disk(i, this);
            this.disks.put(new Integer(i), disk);
            slot.setDisk(disk);
            ++i;
        }
        int i2 = 1;
        while (i2 <= 1) {
            FibreChannelInterface hostIf = new FibreChannelInterface(i2, this);
            this.hostInterfaces.put(new Integer(i2), hostIf);
            ++i2;
        }
    }

    public RaidController(RaidController raidController) {
        this.id = raidController.id;
        this.productId = raidController.productId;
        this.modelName = raidController.modelName;
        this.serialNumber = raidController.serialNumber;
        this.stripeSize = raidController.stripeSize;
        this.writeCacheState = raidController.writeCacheState;
        this.hostInterfaceCount = raidController.hostInterfaceCount;
        this.diskChannelCount = raidController.diskChannelCount;
        this.slotCount = raidController.slotCount;
        this.memorySize = raidController.memorySize;
        this.cacheHitRatio = raidController.cacheHitRatio;
        this.readyState = raidController.readyState;
        this.clientCount = raidController.clientCount;
        this.firmwareVersion = raidController.firmwareVersion;
        this.accessMode = raidController.accessMode;
        this.prefetchSize = raidController.prefetchSize;
        this.autoRebuildEnabled = raidController.autoRebuildEnabled;
        this.rebuildRate = raidController.rebuildRate;
        this.checkDataGenerationEnabled = raidController.checkDataGenerationEnabled;
        this.lunMaskEnabled = raidController.lunMaskEnabled;
        this.jbodMaskEnabled = raidController.jbodMaskEnabled;
        this.jbodModeState = raidController.jbodModeState;
        this.slowReadBypassModeState = raidController.slowReadBypassModeState;
        this.diagnosticFunctionStatus = raidController.diagnosticFunctionStatus;
        this.cpuTemperature = raidController.cpuTemperature;
        this.tempStatus = raidController.tempStatus;
        this.bgrwConditioningPriority = raidController.bgrwConditioningPriority;
        this.syncCacheState = raidController.syncCacheState;
        Iterator iter = raidController.disks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object value = entry.getValue();
            if (value == null) continue;
            Disk copy = new Disk((Disk)value);
            copy.controller = this;
            this.disks.put(entry.getKey(), copy);
        }
        Map raidSetsCopy = (Map)((TreeMap)raidController.raidSets).clone();
        Iterator iter2 = raidSetsCopy.entrySet().iterator();
        while (iter2.hasNext()) {
            Map.Entry entry = iter2.next();
            Object value = entry.getValue();
            if (value == null) continue;
            RaidSet raidSetCopy = new RaidSet((RaidSet)value);
            Collection members = raidSetCopy.getMembers();
            Iterator memberIter = members.iterator();
            while (memberIter.hasNext()) {
                Disk originalMember = (Disk)memberIter.next();
                raidSetCopy.removeMember(originalMember);
                Disk memberCopy = (Disk)this.disks.get(new Integer(originalMember.getNativeId()));
                if (memberCopy != null) {
                    raidSetCopy.addMember(memberCopy);
                    continue;
                }
                throw new NullPointerException("Disk with native ID " + originalMember.getNativeId() + " was null");
            }
            raidSetCopy.controller = this;
            this.raidSets.put(entry.getKey(), raidSetCopy);
        }
        Iterator iter3 = raidController.hostInterfaces.entrySet().iterator();
        while (iter3.hasNext()) {
            Map.Entry entry = iter3.next();
            Object value = entry.getValue();
            if (value == null) continue;
            FibreChannelInterface copy = new FibreChannelInterface((FibreChannelInterface)value);
            this.hostInterfaces.put(entry.getKey(), copy);
        }
        Iterator iter4 = raidController.slots.entrySet().iterator();
        while (iter4.hasNext()) {
            Map.Entry entry = iter4.next();
            Object value = entry.getValue();
            if (value == null) continue;
            DiskSlot slotCopy = new DiskSlot((DiskSlot)value);
            Disk diskCopy = (Disk)this.disks.get(new Integer(slotCopy.getNativeId()));
            if (diskCopy == null) {
                throw new NullPointerException("Disk with native ID " + slotCopy.getNativeId() + " was null");
            }
            slotCopy.setDisk(diskCopy);
            slotCopy.controller = this;
            this.slots.put(entry.getKey(), slotCopy);
        }
        this.system = raidController.system;
    }

    public int getNativeId() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "RAID Controller " + this.id;
    }

    public int getStatus() {
        int status = this.readyState == 1 ? this.tempStatus : (this.readyState == 0 ? 1 : -1);
        return status;
    }

    public boolean isTop() {
        return this.id == 1;
    }

    public boolean isBottom() {
        return this.id == 2;
    }

    void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductId() {
        return this.productId;
    }

    void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    void setStripeSize(int size) throws IllegalArgumentException {
        if (!RaidController.isValidStripeSize(size)) {
            throw new IllegalArgumentException("Illegal stripe size: " + size);
        }
        this.stripeSize = size;
    }

    public int getStripeSize() {
        return this.stripeSize;
    }

    void setWriteCacheState(int writeCacheState) {
        this.writeCacheState = writeCacheState;
    }

    public int getWriteCacheState() {
        return this.writeCacheState;
    }

    void setHostInterfaceCount(int count) {
        this.hostInterfaceCount = count;
    }

    public int getHostInterfaceCount() {
        return this.hostInterfaceCount;
    }

    void setDiskChannelCount(int count) {
        this.diskChannelCount = count;
    }

    public int getDiskChannelCount() {
        return this.diskChannelCount;
    }

    void setSlotCount(int count) {
        this.slotCount = count;
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    void setMemorySize(int size) {
        this.memorySize = size;
    }

    public int getMemorySize() {
        return this.memorySize;
    }

    void setCacheHitRatio(int hitRatio) {
        this.cacheHitRatio = hitRatio;
    }

    public int getCacheHitRatio() {
        return this.cacheHitRatio;
    }

    void setReadyState(int state) {
        if (state == 1) {
            this.system.notifyRaidControllerOnline(this.id);
        }
        if (state != this.readyState) {
            int oldState = this.readyState;
            this.readyState = state;
            if (state == 1) {
                this.fireStateChanged(new SystemEvent(this, 1));
            } else if (state == 0) {
                this.fireStateChanged(new SystemEvent(this, 2));
            }
        }
    }

    public int getReadyState() {
        return this.readyState;
    }

    public boolean isOnline() {
        return this.readyState == 1;
    }

    void setClientCount(int count) {
        this.clientCount = count;
    }

    public int getClientCount() {
        return this.clientCount;
    }

    void setFirmwareVersion(String version) {
        this.firmwareVersion = version;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    void setAccessMode(int mode) throws IllegalArgumentException {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Illegal access mode: " + mode);
        }
        this.accessMode = mode;
    }

    public int getAccessMode() {
        return this.accessMode;
    }

    void setPrefetchSize(int size) {
        this.prefetchSize = size;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    void setAutoRebuildEnabled(boolean enabled) {
        this.autoRebuildEnabled = enabled;
    }

    public boolean getAutoRebuildEnabled() {
        return this.autoRebuildEnabled;
    }

    void setRebuildRate(int rate) throws IllegalArgumentException {
        if (rate < 1 || rate > 7) {
            throw new IllegalArgumentException("Illegal rebuild rate: " + rate);
        }
        this.rebuildRate = rate;
    }

    public int getRebuildRate() {
        return this.rebuildRate;
    }

    void setCheckDataGenerationEnabled(boolean enable) {
        this.checkDataGenerationEnabled = enable;
    }

    public boolean getCheckDataGenerationEnabled() {
        return this.checkDataGenerationEnabled;
    }

    void setLunMaskEnabled(int enable) {
        this.lunMaskEnabled = enable;
    }

    public int getLunMaskEnabled() {
        return this.lunMaskEnabled;
    }

    void setJbodMaskEnabled(boolean enable) {
        this.jbodMaskEnabled = enable;
    }

    public boolean getJbodMaskEnabled() {
        return this.jbodMaskEnabled;
    }

    void setJbodModeState(int state) {
        this.jbodModeState = state;
    }

    public int getJbodModeState() {
        return this.jbodModeState;
    }

    void setSlowReadBypassModeState(int state) {
        this.slowReadBypassModeState = state;
    }

    public int getSlowReadBypassModeState() {
        return this.slowReadBypassModeState;
    }

    void setDiagnosticFunctionStatus(int status) {
        this.diagnosticFunctionStatus = status;
    }

    public int getDiagnosticFunctionStatus() {
        return this.diagnosticFunctionStatus;
    }

    void setCpuTemperature(int temperature) {
        this.cpuTemperature = temperature;
    }

    public int getCpuTemperature() {
        return this.cpuTemperature;
    }

    public void setBackgroundConditioningPriority(int priority) {
        this.bgrwConditioningPriority = priority;
    }

    public int getBackgroundConditioningPriority() {
        return this.bgrwConditioningPriority;
    }

    void setSyncCacheState(int state) {
        this.syncCacheState = state;
    }

    public int getSyncCacheState() {
        return this.syncCacheState;
    }

    void setTemperatureStatus(int status) {
        this.tempStatus = status;
    }

    public RaidSystem getRaidSystem() {
        return this.system;
    }

    void addRaidSet(RaidSet raidset) {
        this.raidSets.put(new Integer(raidset.getNativeId()), raidset);
        this.system.updateGlobalRaidSetIdentifiers();
    }

    RaidSet removeRaidSet(int id) {
        RaidSet removed = (RaidSet)this.raidSets.remove(new Integer(id));
        if (removed != null) {
            this.system.updateGlobalRaidSetIdentifiers();
        }
        return removed;
    }

    public RaidSet getRaidSet(int id) {
        return (RaidSet)this.raidSets.get(new Integer(id));
    }

    public Collection getRaidSets() {
        Map copy = (Map)((TreeMap)this.raidSets).clone();
        return Collections.unmodifiableCollection(copy.values());
    }

    public Disk getDisk(int id) {
        return (Disk)this.disks.get(new Integer(id));
    }

    public Collection getDisks() {
        return Collections.unmodifiableCollection(this.disks.values());
    }

    public HostInterface getHostInterface(int id) {
        return (FibreChannelInterface)this.hostInterfaces.get(new Integer(id));
    }

    public Collection getHostInterfaces() {
        return Collections.unmodifiableCollection(this.hostInterfaces.values());
    }

    public DiskSlot getDiskSlot(int id) {
        return (DiskSlot)this.slots.get(new Integer(id));
    }

    public Collection getDiskSlots() {
        return Collections.unmodifiableCollection(this.slots.values());
    }

    public Collection getMappedLuns() {
        TreeSet<Integer> mappedLuns = new TreeSet<Integer>();
        Iterator rsIter = this.getRaidSets().iterator();
        while (rsIter.hasNext()) {
            Collection mappedSlices = ((RaidSet)rsIter.next()).getMappedSlices();
            Iterator sliceIter = mappedSlices.iterator();
            while (sliceIter.hasNext()) {
                Slice slice = (Slice)sliceIter.next();
                mappedLuns.add(new Integer(slice.getLunId()));
            }
        }
        return mappedLuns;
    }

    public Collection getUnmappedLuns() {
        TreeSet<Integer> unmappedLuns = new TreeSet<Integer>();
        Collection mappedLuns = this.getMappedLuns();
        int i = 0;
        while (i <= 7) {
            Integer id = new Integer(i);
            if (!mappedLuns.contains(id)) {
                unmappedLuns.add(id);
            }
            ++i;
        }
        return unmappedLuns;
    }

    public int getLunsAllocated() {
        int currentLuns = 0;
        Iterator iter = this.getRaidSets().iterator();
        while (iter.hasNext()) {
            currentLuns += ((RaidSet)iter.next()).getMappedSlices().size();
        }
        return currentLuns;
    }

    public int getLunsRemaining() {
        return 8 - this.getLunsAllocated();
    }

    public int getLunsRemainingForCreation() {
        return this.getLunsRemaining();
    }

    public int getLunsRemainingForSlicing() {
        return this.getLunsRemaining();
    }

    public static boolean isValidStripeSize(int size) {
        int i = 0;
        while (i < STRIPE_SIZES.length) {
            if (size == STRIPE_SIZES[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int nextRaidSetId() {
        int next = -1;
        Collection sets = this.getRaidSets();
        int id = 1;
        while (id <= 4) {
            boolean found = false;
            Iterator iter = sets.iterator();
            while (iter.hasNext()) {
                if (((RaidSet)iter.next()).getNativeId() != id) continue;
                found = true;
                break;
            }
            if (!found) {
                next = id;
                break;
            }
            ++id;
        }
        return next;
    }

    public int compareTo(Object o) {
        RaidController controller = (RaidController)o;
        return this.id - controller.id;
    }

    public String paramString() {
        String s = "";
        s = String.valueOf(s) + "id=" + this.id + ",";
        s = String.valueOf(s) + "productId=" + this.productId + ",";
        s = String.valueOf(s) + "modelName=" + this.modelName + ",";
        s = String.valueOf(s) + "serialNumber=" + this.serialNumber + ",";
        s = String.valueOf(s) + "stripeSize=" + this.stripeSize + ",";
        s = String.valueOf(s) + "writeCacheEnabled=" + this.writeCacheState + ",";
        s = String.valueOf(s) + "hostInterfaceCount=" + this.hostInterfaceCount + ",";
        s = String.valueOf(s) + "diskChannelCount=" + this.diskChannelCount + ",";
        s = String.valueOf(s) + "slotCount=" + this.slotCount + ",";
        s = String.valueOf(s) + "memorySize=" + this.memorySize + ",";
        s = String.valueOf(s) + "cacheHitRatio=" + this.cacheHitRatio + ",";
        s = String.valueOf(s) + "readyState=" + this.readyState + ",";
        s = String.valueOf(s) + "clientCount=" + this.clientCount + ",";
        s = String.valueOf(s) + "firmwareVersion=" + this.firmwareVersion + ",";
        s = String.valueOf(s) + "accessMode=" + this.accessMode + ",";
        s = String.valueOf(s) + "prefetchSize=" + this.prefetchSize + ",";
        s = String.valueOf(s) + "autoRebuildEnabled=" + this.autoRebuildEnabled + ",";
        s = String.valueOf(s) + "rebuildRate=" + this.rebuildRate + ",";
        s = String.valueOf(s) + "checkDataGenerationEnabled=" + this.checkDataGenerationEnabled + ",";
        s = String.valueOf(s) + "lunMaskEnabled=" + this.lunMaskEnabled + ",";
        s = String.valueOf(s) + "jbodMaskEnabled=" + this.jbodMaskEnabled + ",";
        s = String.valueOf(s) + "diagnosticFunctionStatus=" + this.diagnosticFunctionStatus + ",";
        s = String.valueOf(s) + "cpuTemperature=" + this.cpuTemperature + ",";
        s = String.valueOf(s) + "tempStatus=" + this.tempStatus + ",";
        s = String.valueOf(s) + "bgrwConditioningPriority=" + this.bgrwConditioningPriority + ",";
        Iterator iter = this.raidSets.values().iterator();
        while (iter.hasNext()) {
            s = String.valueOf(s) + iter.next() + ",";
        }
        Iterator iter2 = this.disks.values().iterator();
        while (iter2.hasNext()) {
            s = String.valueOf(s) + iter2.next() + ",";
        }
        Iterator iter3 = this.hostInterfaces.values().iterator();
        while (iter3.hasNext()) {
            s = String.valueOf(s) + iter3.next() + ",";
        }
        Iterator iter4 = this.slots.values().iterator();
        while (iter4.hasNext()) {
            s = String.valueOf(s) + iter4.next();
            if (!iter4.hasNext()) continue;
            s = String.valueOf(s) + ",";
        }
        return s;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }
}

