/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class RaidSet
extends AbstractSystemElement
implements Comparable {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int DEGRADED = 2;
    public static final int OP_NONE = 0;
    public static final int OP_CREATING = 1;
    public static final int OP_REBUILDING = 2;
    public static final int OP_VERIFYING = 3;
    public static final int OP_EXPANDING = 4;
    public static final int OP_CONDITIONING = 5;
    public static final int RAID_LEVEL_ZERO = 0;
    public static final int RAID_LEVEL_ONE = 1;
    public static final int RAID_LEVEL_THREE = 3;
    public static final int RAID_LEVEL_FOUR = 4;
    public static final int RAID_LEVEL_FIVE = 5;
    public static final int RAID_LEVEL_ZERO_PLUS_ONE = 6;
    public static final int RAID_LEVEL_JBOD = 255;
    public static final int INIT_MODE_FOREGROUND = 0;
    public static final int INIT_MODE_BACKGROUND = 1;
    public static final int BLOCK_SIZE = 512;
    public static final int BGRW_STOPPED = 0;
    public static final int BGRW_PAUSED = 1;
    public static final int BGRW_STARTED = 2;
    public static final int MAX_SLICES = 8;
    private int nativeId;
    private int id;
    private int status = -1;
    private int state = -1;
    private int operation = -1;
    private int progress = -1;
    private int raidLevel = -1;
    private int stripeSize = -1;
    private long capacity = -1L;
    private int initMode = -1;
    private Date timestamp = new Date();
    private int bgrwConditioningState = -1;
    private TreeSet members = new TreeSet();
    private TreeMap slices = new TreeMap();
    RaidController controller;
    private static int guid = 1;

    public RaidSet(int id, RaidController controller) {
        if (controller == null) {
            throw new NullPointerException("controller cannot be null");
        }
        this.nativeId = id;
        this.id = guid++;
        this.controller = controller;
        int i = 0;
        while (i <= 7) {
            this.slices.put(new Integer(i), new Slice(this, i));
            ++i;
        }
    }

    public RaidSet(RaidSet raidSet) {
        this.nativeId = raidSet.nativeId;
        this.id = raidSet.id;
        this.status = raidSet.status;
        this.state = raidSet.state;
        this.operation = raidSet.operation;
        this.progress = raidSet.progress;
        this.raidLevel = raidSet.raidLevel;
        this.stripeSize = raidSet.stripeSize;
        this.capacity = raidSet.capacity;
        this.initMode = raidSet.initMode;
        this.timestamp = raidSet.timestamp;
        this.bgrwConditioningState = raidSet.bgrwConditioningState;
        this.members = (TreeSet)raidSet.members.clone();
        this.controller = raidSet.controller;
        Iterator iter = raidSet.slices.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object value = entry.getValue();
            if (value == null) continue;
            Slice sliceCopy = new Slice((Slice)value);
            sliceCopy.raidSet = this;
            this.slices.put(entry.getKey(), sliceCopy);
        }
    }

    public int getNativeId() {
        return this.nativeId;
    }

    void setGlobalId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "RAID set " + this.id;
    }

    public int getStatus() {
        this.status = this.state == 0 ? (this.operation == 2 ? 1 : 0) : (this.state == 1 ? 2 : (this.state == 2 ? 1 : -1));
        return this.status;
    }

    void setState(int state) {
        if (state != 0 && state != 1 && state != 2 && state != -1) {
            throw new IllegalArgumentException("Illegal state (" + state + ")");
        }
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    void setOperation(int operation) {
        if (operation != 1 && operation != 2 && operation != 3 && operation != 4 && operation != 5 && operation != 0 && operation != -1) {
            throw new IllegalArgumentException("Illegal operation (" + operation + ")");
        }
        this.operation = operation;
    }

    public int getOperation() {
        return this.operation;
    }

    void setProgress(int progress) {
        this.progress = progress;
        if (this.progress < 0) {
            this.progress = 0;
        } else if (this.progress > 100) {
            this.progress = 100;
        }
    }

    public int getProgress() {
        return this.progress;
    }

    void setRaidLevel(int raidLevel) {
        switch (raidLevel) {
            default: {
                throw new IllegalArgumentException("Illegal RAID Level: " + raidLevel);
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 255: 
        }
        this.raidLevel = raidLevel;
    }

    public int getRaidLevel() {
        return this.raidLevel;
    }

    void setStripeSize(int stripeSize) {
        if (!RaidController.isValidStripeSize(stripeSize)) {
            throw new IllegalArgumentException("Illegal Stripe Size: " + stripeSize);
        }
        this.stripeSize = stripeSize;
    }

    public int getStripeSize() {
        return this.stripeSize;
    }

    void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getCapacityBytes() {
        return this.capacity * 512L;
    }

    void setInitializationMode(int mode) {
        if (mode != 0 && mode != 1 && mode != -1) {
            throw new IllegalArgumentException("Illegal mode : " + mode);
        }
        this.initMode = mode;
    }

    public int getInitializationMode() {
        return this.initMode;
    }

    void setTimeStamp(int year, int month, int date, int hour, int minute, int second) {
        GregorianCalendar cal = new GregorianCalendar(year, month, date, hour, minute, second);
        this.timestamp = cal.getTime();
    }

    public Date getTimeStamp() {
        return this.timestamp;
    }

    void setBackgroundConditioningState(int state) {
        if (state != -1 && state != 2 && state != 1 && state != 0) {
            throw new IllegalArgumentException("Illegal background conditioning state: " + state);
        }
        this.bgrwConditioningState = state;
    }

    public int getBackgroundConditioningState() {
        return this.bgrwConditioningState;
    }

    public Slice getSlice(int id) {
        return (Slice)this.slices.get(new Integer(id));
    }

    public Collection getSlices() {
        return Collections.unmodifiableCollection(this.slices.values());
    }

    public Collection getLiveSlices() {
        TreeSet<Slice> liveSlices = new TreeSet<Slice>();
        Iterator iter = this.slices.values().iterator();
        while (iter.hasNext()) {
            Slice slice = (Slice)iter.next();
            if (slice.getSize() <= 0) continue;
            liveSlices.add(slice);
        }
        return liveSlices;
    }

    public Collection getMappedSlices() {
        ArrayList<Slice> mappedSlices = new ArrayList<Slice>();
        Iterator iter = this.slices.values().iterator();
        while (iter.hasNext()) {
            Slice slice = (Slice)iter.next();
            if (!slice.isMapped()) continue;
            mappedSlices.add(slice);
        }
        return mappedSlices;
    }

    public Collection getUnmappedSlices() {
        ArrayList<Slice> unmappedSlices = new ArrayList<Slice>();
        Iterator iter = this.slices.values().iterator();
        while (iter.hasNext()) {
            Slice slice = (Slice)iter.next();
            if (slice.isMapped() || slice.getSize() <= 0) continue;
            unmappedSlices.add(slice);
        }
        return unmappedSlices;
    }

    public int getLiveSliceCount() {
        int count = 0;
        Iterator iter = this.slices.values().iterator();
        while (iter.hasNext()) {
            Slice slice = (Slice)iter.next();
            if (slice.getSize() <= 0) continue;
            ++count;
        }
        return count;
    }

    boolean addMember(Disk member) {
        if (member == null) {
            throw new NullPointerException("member cannot be null");
        }
        return this.members.add(member);
    }

    boolean removeMember(Disk member) {
        if (member == null) {
            throw new NullPointerException("member cannot be null");
        }
        return this.members.remove(member);
    }

    public Collection getMembers() {
        TreeSet copy = (TreeSet)this.members.clone();
        return Collections.unmodifiableSet(copy);
    }

    public boolean isPhantom() {
        boolean phantom = true;
        Iterator iter = this.getMembers().iterator();
        while (iter.hasNext()) {
            Disk disk = (Disk)iter.next();
            if (disk.getRaidSet() == null) continue;
            phantom = false;
            break;
        }
        return phantom;
    }

    public RaidController getController() {
        return this.controller;
    }

    public int compareTo(Object o) {
        RaidSet rs = (RaidSet)o;
        return this.id - rs.id;
    }

    public String paramString() {
        String s = "";
        s = String.valueOf(s) + "id=" + this.id + ",";
        s = String.valueOf(s) + "status=" + this.status + ",";
        s = String.valueOf(s) + "state=" + this.state + ",";
        s = String.valueOf(s) + "operation=" + this.operation + ",";
        s = String.valueOf(s) + "progress=" + this.progress + ",";
        s = String.valueOf(s) + "raidLevel=" + this.raidLevel + ",";
        s = String.valueOf(s) + "stripeSize=" + this.stripeSize + ",";
        s = String.valueOf(s) + "capacity=" + this.capacity + ",";
        s = String.valueOf(s) + "timestamp=" + this.timestamp + ",";
        s = String.valueOf(s) + "initMode=" + this.initMode + ",";
        s = String.valueOf(s) + "members={";
        Iterator iter = this.members.iterator();
        while (iter.hasNext()) {
            s = String.valueOf(s) + ((Disk)iter.next()).getId();
            if (!iter.hasNext()) continue;
            s = String.valueOf(s) + ",";
        }
        s = String.valueOf(s) + "}";
        s = String.valueOf(s) + "slices={";
        Iterator iter2 = this.getSlices().iterator();
        while (iter2.hasNext()) {
            s = String.valueOf(s) + ((Slice)iter2.next()).getSize();
            if (!iter2.hasNext()) continue;
            s = String.valueOf(s) + ",";
        }
        s = String.valueOf(s) + "}";
        return s;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }
}

