/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.net.acp.AcpEventLog;
import com.apple.net.acp.AcpPropertyCode;
import com.apple.util.plist.PListUtils;
import com.apple.util.plist.PropertyList;
import com.apple.util.plist.PropertyListException;
import com.apple.util.plist.PropertyListUtilities;
import com.apple.xsr.EmailNotifications;
import com.apple.xsr.LunMaskSetting;
import com.apple.xsr.OperationManager;
import com.apple.xsr.net.AcpxCommandException;
import com.apple.xsr.net.AcpxConstants;
import com.apple.xsr.net.AcpxMessageFactory;
import com.apple.xsr.net.CommShutdownException;
import com.apple.xsr.net.CommunicationHandler;
import com.apple.xsr.net.CommunicationsManager;
import com.apple.xsr.net.IPAddress;
import com.apple.xsr.net.MessageFactory;
import com.apple.xsr.net.RequestMessage;
import com.apple.xsr.net.Response;
import com.apple.xsr.som.Battery;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.DiskSlot;
import com.apple.xsr.som.Fan;
import com.apple.xsr.som.FibreChannelInterface;
import com.apple.xsr.som.HostInterface;
import com.apple.xsr.som.NetworkInterface;
import com.apple.xsr.som.PowerSupply;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.Slice;
import com.apple.xsr.som.SystemController;
import java.io.IOException;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

class RaidSystemAgent
extends Thread {
    static final long DEFAULT_POLLING_DELAY = 15000L;
    static final RequestMessage.Target TARGET_MASTER = RequestMessage.Target.MASTER;
    static final RequestMessage.Target TARGET_COMPANION = RequestMessage.Target.COMPANION;
    static final RequestMessage.Target TARGET_TOP = RequestMessage.Target.TOP;
    static final RequestMessage.Target TARGET_BOTTOM = RequestMessage.Target.BOTTOM;
    private static final AcpPropertyCode[] properties = new AcpPropertyCode[]{AcpPropertyCode.SYS_NAME, AcpPropertyCode.SYS_DNS_NAME, AcpPropertyCode.SYS_PRESENTATION_NAME, AcpPropertyCode.SYS_CONTACT, AcpPropertyCode.SYS_DESCRIPTION, AcpPropertyCode.SYS_LOCATION, AcpPropertyCode.SYS_VERSION, AcpPropertyCode.SYS_PASSWORD_RO, AcpPropertyCode.SYS_GUEST_PASSWORD, AcpPropertyCode.SYS_UP_TIME, AcpPropertyCode.SYS_FLAGS, AcpPropertyCode.LAN_MAC_ADDRESS, AcpPropertyCode.LAN_CONFIGURE_VIA, AcpPropertyCode.LAN_IP_ADDRESS, AcpPropertyCode.LAN_SUBNET_MASK, AcpPropertyCode.LAN_ROUTER_ADDRESS, AcpPropertyCode.WAN_CURRENT_DNS_1, AcpPropertyCode.WAN_CURRENT_DNS_2, AcpPropertyCode.WAN_CURRENT_DNS_3, AcpPropertyCode.LAN_DHCP_CLIENT_ID, AcpPropertyCode.LAN_INTERFACE_STATE, AcpPropertyCode.SMTP_SERVER, AcpPropertyCode.NTP_CONFIG, AcpPropertyCode.SNMP_ACCESS_FLAGS, AcpPropertyCode.SERVER_MODE, AcpPropertyCode.EFFECT_FLAGS, AcpPropertyCode.EMAIL_NOTIFICATION};
    private RaidSystem system;
    private CommunicationsManager comms;
    private MessageFactory msgFactory;
    private long pollDelay = 15000L;
    private boolean pollingEnabled = true;
    private boolean stopped = false;
    private boolean updateImmediately = false;
    private boolean sleeping = false;
    private final Object POLL_MONITOR = new Object();
    private List page1SlotsArray;
    private List lunList;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$som$RaidSystemAgent != null ? class$com$apple$xsr$som$RaidSystemAgent : (class$com$apple$xsr$som$RaidSystemAgent = RaidSystemAgent.class$("com.apple.xsr.som.RaidSystemAgent")));
    private final String hostAddress;
    static /* synthetic */ Class class$com$apple$xsr$som$RaidSystemAgent;

    public RaidSystemAgent(RaidSystem system) {
        this.setName("Agent");
        this.system = system;
        this.comms = system.getCommunicationsManager();
        this.hostAddress = this.system.getHostAddress();
        this.msgFactory = new AcpxMessageFactory();
    }

    public synchronized void connect(CommunicationHandler handler, String user, String password) {
        ((AcpxMessageFactory)this.msgFactory).setDefaultUser(user);
        ((AcpxMessageFactory)this.msgFactory).setDefaultPassword(password);
        RequestMessage request = this.msgFactory.newGetPropertiesRequest(properties);
        request.setTargetController(null);
        1 delegate = new 1(this, handler);
        logger.info(String.valueOf(this.hostAddress) + " -> Sending connect message");
        this.comms.postMessageAsync(delegate, request);
    }

    public synchronized void authenticate(CommunicationHandler handler, String user, String password) {
        RequestMessage request = this.msgFactory.newGetPropertiesRequest(properties);
        request.setTargetController(null);
        request.setUser(user);
        request.setPassword(password);
        if (user.equals("guest")) {
            ((AcpxMessageFactory)this.msgFactory).setDefaultUser(user);
            ((AcpxMessageFactory)this.msgFactory).setDefaultPassword(password);
        }
        2 delegate = new 2(this, handler);
        logger.info(String.valueOf(this.hostAddress) + " -> Sending authentication message");
        this.comms.postMessageAsync(delegate, request);
    }

    private void completeClientRequest(CommunicationHandler handler) {
        RequestMessage request = this.msgFactory.newGetPowerStateRequest();
        request.setTargetController(null);
        3 delegate = new 3(this, handler);
        logger.info(String.valueOf(this.hostAddress) + " -> Completing connect/authentication request");
        this.comms.postMessageAsync(delegate, request);
    }

    public synchronized void updateImmediately() {
        if (this.isPollingEnabled() && this.sleeping) {
            this.updateImmediately = true;
            this.interrupt();
        }
    }

    public void setPollingEnabled(boolean enabled) {
        Object object = this.POLL_MONITOR;
        synchronized (object) {
            if (this.pollingEnabled != enabled) {
                this.pollingEnabled = enabled;
                this.POLL_MONITOR.notifyAll();
            }
        }
    }

    public boolean isPollingEnabled() {
        Object object = this.POLL_MONITOR;
        synchronized (object) {
            boolean $return = this.pollingEnabled;
            Object var3_3 = null;
            return $return;
        }
    }

    public synchronized boolean isPolling() {
        return this.sleeping ^ true;
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public void setPollDelay(int seconds) {
        this.pollDelay = (long)seconds * 1000L;
        logger.info("Poll delay set to " + this.pollDelay);
    }

    public int getPollDelay() {
        return (int)(this.pollDelay / 1000L);
    }

    public void run() {
        int pollCount = 0;
        while (!this.isStopped()) {
            logger.info("**************************************** " + ++pollCount + " ****************************************");
            try {
                RaidSystemAgent raidSystemAgent;
                Object var3_7;
                Object object = this.POLL_MONITOR;
                synchronized (object) {
                    block37: {
                        try {
                            while (!this.pollingEnabled) {
                                this.POLL_MONITOR.wait();
                            }
                        }
                        catch (InterruptedException e) {
                            if (this.isStopped()) break block37;
                            logger.error("Interrupted while waiting for polling to be reenabled: " + e);
                        }
                    }
                }
                if (this.isStopped()) break;
                this.system.notifyUpdateStarted();
                this.doPowerStateUpdate();
                if (this.system.getPowerState() == 1) {
                    this.doThermalUpdate();
                    this.doSystemControllerUpdate();
                    this.doTimeUpdate();
                    this.doEventLogUpdate();
                    this.doDeviceUpdate();
                    RaidController rcTop = this.system.getRaidController(1);
                    RaidController rcBottom = this.system.getRaidController(2);
                    if (rcTop.getReadyState() == 1 && rcBottom.getReadyState() == 1) {
                        this.system.setUserMessageIndex(0);
                    } else if (rcTop.getReadyState() == 0 || rcBottom.getReadyState() == 0) {
                        this.system.setUserMessageIndex(10);
                    }
                    if (rcTop.getReadyState() == 1) {
                        this.doRaidControllerUpdate(1);
                    }
                    if (rcBottom.getReadyState() == 1) {
                        this.doRaidControllerUpdate(2);
                    }
                } else {
                    this.system.setUserMessageIndex(6);
                    this.doStandbyUpdate();
                }
                this.system.setChanged();
                this.system.notifyUpdateFinished();
                if (this.isStopped()) break;
                try {
                    try {
                        RaidSystemAgent e = this;
                        synchronized (e) {
                            this.sleeping = true;
                        }
                        Thread.sleep(this.pollDelay);
                    }
                    catch (InterruptedException e) {
                        RaidSystemAgent raidSystemAgent2 = this;
                        synchronized (raidSystemAgent2) {
                            if (this.updateImmediately) {
                                this.updateImmediately = false;
                            } else if (!this.isStopped()) {
                                logger.error("Interrupted while sleeping between polls: " + e);
                            }
                        }
                    }
                    var3_7 = null;
                    raidSystemAgent = this;
                }
                catch (Throwable rcTop) {
                    var3_7 = null;
                    raidSystemAgent = this;
                    synchronized (raidSystemAgent) {
                        this.sleeping = false;
                    }
                    throw rcTop;
                }
                synchronized (raidSystemAgent) {
                    this.sleeping = false;
                }
            }
            catch (AuthenticationException e) {
                logger.error(e);
                this.system.notifyUpdateFinished();
                this.setPollingEnabled(false);
                this.system.setUserMessageIndex(11);
                this.system.setPowerState(-1);
                this.system.setChanged();
            }
            catch (ConnectException e) {
                logger.error(e);
                this.updateConnectionFailure();
                this.system.notifyUpdateFinished();
                this.setPollingEnabled(false);
            }
            catch (CommShutdownException commShutdownException) {
                logger.info("Caught communication shutdown exception");
                this.system.notifyUpdateFinished();
                break;
            }
            catch (Exception e) {
                logger.error(e);
                this.system.setUserMessageIndex(5);
                this.system.notifyUpdateFinished();
            }
        }
        logger.info(String.valueOf(this.hostAddress) + " ->  ** Terminating Updates **");
    }

    public synchronized void terminate() {
        this.shutdown();
    }

    public synchronized void shutdown() {
        this.stopped = true;
        this.setPollingEnabled(true);
    }

    MessageFactory getMessageFactory() {
        return this.msgFactory;
    }

    private void doPowerStateUpdate() throws IOException {
        RequestMessage request = this.msgFactory.newGetPowerStateRequest();
        request.setTargetController(null);
        try {
            Response rsp = this.comms.postMessage(request);
            if (rsp.getResultCode() == 0) {
                this.updatePowerState((PropertyList)rsp.getContent());
            } else if (rsp.getResultCode() == -16) {
                throw new AuthenticationException("authentication failure attempting to get power state");
            }
        }
        catch (PropertyListException e) {
            logger.error(e);
        }
    }

    private void doStandbyUpdate() throws IOException {
        RequestMessage request = this.msgFactory.newGetPropertiesRequest(properties);
        request.setTargetController(null);
        try {
            Response rsp = this.comms.postMessage(request);
            this.updateStandbyProperties((PropertyList)rsp.getContent());
        }
        catch (AcpxCommandException e) {
            logger.error(e);
        }
        catch (PropertyListException e) {
            logger.error(e);
        }
    }

    private void doSystemControllerUpdate() throws IOException {
        SystemController top = this.system.getSystemController(1);
        SystemController bottom = this.system.getSystemController(2);
        try {
            RequestMessage request = this.msgFactory.newGetPropertiesRequest(properties);
            request.setTargetController(TARGET_TOP);
            Response topProps = this.comms.postMessage(request);
            request.setTargetController(TARGET_BOTTOM);
            Response bottomProps = this.comms.postMessage(request);
            request = this.msgFactory.newGetStatusRequest();
            request.setTargetController(TARGET_TOP);
            Response topStatus = this.comms.postMessage(request);
            request.setTargetController(TARGET_BOTTOM);
            Response bottomStatus = this.comms.postMessage(request);
            this.updateSystemController(top, (PropertyList)topProps.getContent());
            this.updateSystemStatus(top, (PropertyList)topStatus.getContent());
            this.updateSystemController(bottom, (PropertyList)bottomProps.getContent());
            this.updateSystemStatus(bottom, (PropertyList)bottomStatus.getContent());
            this.updateUpsStatus((PropertyList)topStatus.getContent(), (PropertyList)bottomStatus.getContent());
        }
        catch (AcpxCommandException e) {
            logger.error(e);
        }
        catch (PropertyListException e) {
            logger.error(e);
        }
    }

    private void doTimeUpdate() throws IOException {
        RequestMessage request = this.msgFactory.newGetTimeRequest();
        request.setTargetController(null);
        try {
            Response rsp = this.comms.postMessage(request);
            this.updateSystemTime((PropertyList)rsp.getContent());
        }
        catch (AcpxCommandException e) {
            logger.error(e);
        }
        catch (PropertyListException e) {
            logger.error(e);
        }
    }

    private void doEventLogUpdate() throws IOException {
        block17: {
            PropertyList plist;
            Response rsp;
            Date lastEventDate;
            AcpEventLog.Event lastEvent;
            SimpleDateFormat format;
            boolean bottomLogSupported;
            boolean topLogSupported;
            RequestMessage request = null;
            RequestMessage.Target target = null;
            SystemController topController = this.system.getSystemController(1);
            SystemController bottomController = this.system.getSystemController(2);
            try {
                topLogSupported = OperationManager.isSupported(this.system, 1, OperationManager.OP_READ_EVENT_LOG);
            }
            catch (Exception e) {
                topLogSupported = true;
                logger.error("Error determining top event log support: " + e);
            }
            try {
                bottomLogSupported = OperationManager.isSupported(this.system, 1, OperationManager.OP_READ_EVENT_LOG);
            }
            catch (Exception e) {
                bottomLogSupported = true;
                logger.error("Error determining bottom event log support: " + e);
            }
            if (logger.isInfoEnabled()) {
                format = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'");
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                format = null;
            }
            if (topController != null && topLogSupported) {
                lastEvent = null;
                lastEventDate = null;
                target = RequestMessage.TARGET_TOP;
                lastEvent = this.system.getEventLog().getLastEvent(topController.getId());
                if (lastEvent != null) {
                    lastEventDate = lastEvent.getTime();
                    if (logger.isInfoEnabled()) {
                        logger.info("Getting top events > " + format.format(lastEventDate));
                    }
                }
                request = this.msgFactory.newGetEventLogRequest(lastEventDate);
                request.setTargetController(target);
                try {
                    rsp = this.comms.postMessage(request);
                    plist = (PropertyList)rsp.getContent();
                    this.updateEventLog(topController, plist);
                }
                catch (AcpxCommandException e) {
                    logger.error(e);
                }
                catch (PropertyListException e) {
                    logger.error(e);
                }
            }
            if (bottomController == null || !bottomLogSupported) break block17;
            lastEvent = null;
            lastEventDate = null;
            target = RequestMessage.TARGET_BOTTOM;
            lastEvent = this.system.getEventLog().getLastEvent(bottomController.getId());
            if (lastEvent != null) {
                lastEventDate = lastEvent.getTime();
                if (logger.isInfoEnabled()) {
                    logger.info("Getting bottom events > " + format.format(lastEventDate));
                }
            }
            request = this.msgFactory.newGetEventLogRequest(lastEventDate);
            request.setTargetController(target);
            try {
                rsp = this.comms.postMessage(request);
                plist = (PropertyList)rsp.getContent();
                this.updateEventLog(bottomController, plist);
            }
            catch (AcpxCommandException e) {
                logger.error(e);
            }
            catch (PropertyListException e) {
                logger.error(e);
            }
        }
    }

    private void doDeviceUpdate() throws IOException {
        Response rsp;
        RequestMessage request;
        try {
            request = this.msgFactory.newGetDevicePropertiesRequest("keylock", null);
            request.setTargetController(TARGET_TOP);
            rsp = this.comms.postMessage(request);
            this.updateLockState((PropertyList)rsp.getContent());
        }
        catch (AcpxCommandException e) {
            logger.error(e);
        }
        catch (PropertyListException e) {
            logger.error(e);
        }
        try {
            Integer id = new Integer(1);
            request = this.msgFactory.newGetDevicePropertiesRequest("power-supply", id);
            rsp = this.comms.postMessage(request);
            this.updatePowerSupply(1, (PropertyList)rsp.getContent());
            id = new Integer(2);
            request = this.msgFactory.newGetDevicePropertiesRequest("power-supply", id);
            rsp = this.comms.postMessage(request);
            this.updatePowerSupply(2, (PropertyList)rsp.getContent());
        }
        catch (AcpxCommandException e) {
            logger.error(e);
        }
        catch (PropertyListException e) {
            logger.error(e);
        }
        try {
            request = this.msgFactory.newGetDevicePropertiesRequest("battery", null);
            request.setTargetController(TARGET_TOP);
            rsp = this.comms.postMessage(request);
            this.updateBattery(1, (PropertyList)rsp.getContent());
            request = this.msgFactory.newGetDevicePropertiesRequest("battery", null);
            request.setTargetController(TARGET_BOTTOM);
            rsp = this.comms.postMessage(request);
            this.updateBattery(2, (PropertyList)rsp.getContent());
        }
        catch (AcpxCommandException e) {
            logger.error(e);
        }
        catch (PropertyListException e) {
            logger.error(e);
        }
        try {
            request = this.msgFactory.newGetDevicePropertiesRequest("blower", null);
            request.setTargetController(TARGET_TOP);
            rsp = this.comms.postMessage(request);
            this.updateFan(1, (PropertyList)rsp.getContent());
            request = this.msgFactory.newGetDevicePropertiesRequest("blower", null);
            request.setTargetController(TARGET_BOTTOM);
            rsp = this.comms.postMessage(request);
            this.updateFan(2, (PropertyList)rsp.getContent());
        }
        catch (AcpxCommandException e) {
            logger.error(e);
        }
        catch (PropertyListException e) {
            logger.error(e);
        }
    }

    private void doRaidControllerUpdate(int controller) throws IOException {
        block17: {
            Response response;
            RequestMessage request;
            boolean page32Supported = false;
            boolean page0Updated = false;
            boolean page1Updated = false;
            boolean page32Updated = false;
            boolean slotPage1Updated = false;
            this.page1SlotsArray = null;
            this.lunList = null;
            RaidController raidController = this.system.getRaidController(controller);
            RequestMessage.Target target = controller == 1 ? TARGET_TOP : TARGET_BOTTOM;
            try {
                page32Supported = OperationManager.isSupported(this.system, OperationManager.OP_DELETE_ORPHAN);
            }
            catch (Exception e) {
                logger.error(e);
            }
            try {
                request = this.msgFactory.newGetControllerPageRequest(AcpxConstants.CONTROLLER_INFO);
                request.setTargetController(target);
                response = this.comms.postMessage(request);
                this.processPage0(raidController, (PropertyList)response.getContent());
                page0Updated = true;
            }
            catch (Exception e) {
                logger.error(e);
            }
            try {
                request = this.msgFactory.newGetControllerPageRequest(AcpxConstants.RAID_INFO);
                request.setTargetController(target);
                response = this.comms.postMessage(request);
                this.processPage1(raidController, (PropertyList)response.getContent());
                page1Updated = true;
            }
            catch (Exception e) {
                logger.error(e);
            }
            try {
                request = this.msgFactory.newGetControllerPageRequest(AcpxConstants.CONTROLLER_SLOT_PAGE_1);
                request.setTargetController(target);
                response = this.comms.postMessage(request);
                this.updateDisks(raidController, (PropertyList)response.getContent());
                slotPage1Updated = true;
            }
            catch (Exception e) {
                logger.error(e);
            }
            if (page32Supported) {
                try {
                    request = this.msgFactory.newGetControllerPageRequest(new Integer(32));
                    request.setTargetController(target);
                    response = this.comms.postMessage(request);
                    this.processPage32(raidController, (PropertyList)response.getContent());
                    page32Updated = true;
                }
                catch (Exception e) {
                    logger.error(e);
                }
            } else {
                logger.info("Skipping page 32. Coprocessor below minimum version (" + OperationManager.OP_DELETE_ORPHAN + ").");
            }
            if (this.page1SlotsArray != null) {
                try {
                    this.updatePage1Slots(raidController, this.page1SlotsArray);
                }
                catch (PropertyListException e) {
                    logger.error(e);
                }
            }
            if (this.lunList == null) break block17;
            try {
                this.updateLunMap(raidController, this.lunList);
            }
            catch (PropertyListException e) {
                logger.error(e);
            }
        }
    }

    private void doThermalUpdate() throws IOException {
        SystemController topController = this.system.getSystemController(1);
        SystemController bottomController = this.system.getSystemController(2);
        RequestMessage request = this.msgFactory.newGetTemperatureRequest("ambient");
        try {
            request.setTargetController(TARGET_TOP);
            Response rsp = this.comms.postMessage(request);
            this.updateThermal(topController, (PropertyList)rsp.getContent());
            request.setTargetController(TARGET_BOTTOM);
            rsp = this.comms.postMessage(request);
            this.updateThermal(bottomController, (PropertyList)rsp.getContent());
        }
        catch (AcpxCommandException e) {
            logger.error(e);
        }
        catch (PropertyListException e) {
            logger.error(e);
        }
    }

    private int updatePowerState(PropertyList plist) throws PropertyListException {
        String cmd = "power-state-get";
        logger.info(String.valueOf(this.hostAddress) + " -> Updating power state");
        Map rootDict = PListUtils.toDictionary(plist.getRootElement(), "power-state-get root dict");
        Map cmdDict = PListUtils.toDictionary(rootDict.get("power-state-get"), "power-state-get command dict");
        int state = PListUtils.toInteger(cmdDict.get("power-state"), "power-state").intValue();
        if (state == 1) {
            this.system.setPowerState(1);
        } else if (state == 0) {
            this.system.setPowerState(0);
        } else {
            String msg = "Unknown power state \"" + state + "\"";
            logger.error(msg);
        }
        return state;
    }

    private int updateStandbyProperties(PropertyList plist) throws PropertyListException, AcpxCommandException {
        logger.info(String.valueOf(this.hostAddress) + " -> Updating standby ACP properties");
        Map rootDict = PListUtils.toDictionary(plist.getRootElement(), "get-properties root dict");
        Object cmdStatus = rootDict.get("status");
        if (cmdStatus != null) {
            int err = PListUtils.toInteger(cmdStatus, "get-properties status").intValue();
            if (err == -16) {
                return err;
            }
            if (err == -28) {
                return err;
            }
            String msg = "ACP error for \"get-properties\" command (status = " + err + ")";
            logger.error(msg);
            throw new AcpxCommandException(msg);
        }
        Iterator iter = rootDict.entrySet().iterator();
        while (iter.hasNext()) {
            Object property;
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Map propDict = PListUtils.toDictionary(entry.getValue(), "get-properties property dict");
            int status = this.getCommandStatus(propDict);
            if (status != 0) {
                if (status == -10) {
                    logger.warn("Unknown ACP property \"" + key + "\" (status = " + status + ")");
                    continue;
                }
                String msg = "ACP error for property \"" + key + "\" (status = " + status + ")";
                logger.error(msg);
            }
            if ((property = propDict.get("data")) == null) {
                logger.warn("ACP property \"" + key + "\" has no data");
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_PRESENTATION_NAME)))) {
                this.system.setName(PListUtils.toString(property, key));
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_CONTACT)))) {
                this.system.setContact(PListUtils.toString(property, key));
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_DESCRIPTION)))) {
                this.system.setDescription(PListUtils.toString(property, key));
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_LOCATION)))) {
                this.system.setLocation(PListUtils.toString(property, key));
                continue;
            }
            if (!key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_UP_TIME)))) continue;
            this.system.setUpTime(PListUtils.toInteger(property, key).intValue());
        }
        return 0;
    }

    private void updateSystemController(SystemController controller, PropertyList plist) throws PropertyListException, AcpxCommandException {
        int err;
        logger.info(String.valueOf(this.hostAddress) + " -> Updating ACP properties for " + controller.getName());
        NetworkInterface networkInterface = controller.getNetworkInterface();
        String[] dns = new String[3];
        Map rootDict = PListUtils.toDictionary(plist.getRootElement(), "get-properties root dict");
        Object cmdStatus = rootDict.get("status");
        if (cmdStatus != null && (err = PListUtils.toInteger(cmdStatus, "get-properties status").intValue()) != 0) {
            String msg = "ACP error for \"get-properties\" command (status = " + err + ")";
            logger.error(msg);
            throw new AcpxCommandException(msg);
        }
        Iterator iter = rootDict.entrySet().iterator();
        while (iter.hasNext()) {
            Object property;
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Map propDict = PListUtils.toDictionary(entry.getValue(), "get-properties property dict");
            int status = this.getCommandStatus(propDict);
            if (status != 0) {
                if (status == -10) {
                    logger.warn("Unknown ACP property \"" + key + "\" (status = " + status + ")");
                    continue;
                }
                String msg = "ACP error for property \"" + key + "\" (status = " + status + ")";
                logger.error(msg);
            }
            if ((property = propDict.get("data")) == null) {
                logger.warn("ACP property \"" + key + "\" has no data");
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_NAME)))) {
                controller.setSystemName(PListUtils.toString(property, key));
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_DNS_NAME)))) {
                controller.setSystemDnsName(PListUtils.toString(property, key));
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_PRESENTATION_NAME)))) {
                controller.setSystemPresentationName(PListUtils.toString(property, key));
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_CONTACT)))) {
                controller.setSystemContact(PListUtils.toString(property, key));
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_DESCRIPTION)))) {
                controller.setSystemDescription(PListUtils.toString(property, key));
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_LOCATION)))) {
                controller.setSystemLocation(PListUtils.toString(property, key));
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_VERSION)))) {
                controller.setSystemVersion(PListUtils.toString(property, key));
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_PASSWORD_RO))) || key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_GUEST_PASSWORD)))) continue;
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_UP_TIME)))) {
                controller.setUpTime(PListUtils.toInteger(property, key).intValue());
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SYS_FLAGS)))) {
                int flags = PListUtils.toInteger(property, key).intValue();
                boolean forceReload = (flags & 0x4000) != 0;
                boolean softReset = (flags & 0x2000) != 0;
                boolean topModule = (flags & 0x1000) != 0;
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.LAN_MAC_ADDRESS)))) {
                networkInterface.setMacAddress(PListUtils.toString(property, key));
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.LAN_CONFIGURE_VIA)))) {
                int method = PListUtils.toInteger(property, key).intValue();
                if ((method & 0x200) != 0) {
                    networkInterface.setConfigurationMethod(512);
                    continue;
                }
                if ((method & 0x400) != 0) {
                    networkInterface.setConfigurationMethod(1024);
                    continue;
                }
                if ((method & 0x2000) != 0) {
                    networkInterface.setConfigurationMethod(8192);
                    continue;
                }
                networkInterface.setConfigurationMethod(-1);
                logger.warn("Unknown network interface configuration method \"" + method + "\"");
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.LAN_IP_ADDRESS)))) {
                String address = PListUtils.toString(property, key);
                try {
                    logger.info(String.valueOf(this.hostAddress) + " setting " + networkInterface.getName() + " to " + address);
                    networkInterface.setAddress(address);
                    logger.info(String.valueOf(this.hostAddress) + " -> Comparing primary address " + this.system.getPrimaryHostAddress() + " to " + address);
                    if (new IPAddress(address).equals(new IPAddress(this.system.getPrimaryHostAddress()))) continue;
                    logger.info(String.valueOf(this.hostAddress) + " -> Setting secondary host address " + address);
                    this.system.setSecondaryHostAddress(address);
                }
                catch (UnknownHostException e) {
                    logger.error("Failed to set LAN IP address : " + e);
                }
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.LAN_SUBNET_MASK)))) {
                try {
                    networkInterface.setSubnetMask(PListUtils.toString(property, key));
                }
                catch (UnknownHostException e) {
                    logger.error("Failed to set LAN subnet mask : " + e);
                }
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.LAN_ROUTER_ADDRESS)))) {
                try {
                    networkInterface.setGateway(PListUtils.toString(property, key));
                }
                catch (UnknownHostException e) {
                    logger.error("Failed to set LAN router address : " + e);
                }
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.WAN_CURRENT_DNS_1)))) {
                dns[0] = PListUtils.toString(property, key);
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.WAN_CURRENT_DNS_2)))) {
                dns[1] = PListUtils.toString(property, key);
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.WAN_CURRENT_DNS_3)))) {
                dns[2] = PListUtils.toString(property, key);
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.LAN_DHCP_CLIENT_ID)))) {
                networkInterface.setDhcpClientId(PListUtils.toString(property, key));
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.LAN_INTERFACE_STATE)))) {
                int state = PListUtils.toInteger(property, key).intValue();
                int speed = state & 0xFF;
                if (speed == 1) {
                    networkInterface.setSpeed(0);
                } else if (speed == 2) {
                    networkInterface.setSpeed(1);
                } else if (speed == 3) {
                    networkInterface.setSpeed(2);
                } else if (speed == 0) {
                    networkInterface.setSpeed(-1);
                } else {
                    networkInterface.setSpeed(-1);
                    logger.warn("Unknown network interface speed \"" + speed + "\"");
                }
                int link = state & 0x100;
                networkInterface.setLinkState(link != 0 ? 1 : 0);
                int duplex = state & 0x200;
                networkInterface.setDuplex(duplex != 0 ? 1 : 0);
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SMTP_SERVER)))) {
                try {
                    controller.setSmtpServerAddress(PListUtils.toString(property, key));
                }
                catch (UnknownHostException e) {
                    logger.error("Failed to set SMTP server address : " + e);
                }
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.NTP_CONFIG)))) {
                controller.setNtpServerAddress(PListUtils.toString(property, key));
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SNMP_ACCESS_FLAGS)))) {
                int flags = PListUtils.toInteger(property, key).intValue();
                int state = (flags & 2) != 0 ? 0 : 1;
                controller.setSnmpState(state);
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.SERVER_MODE)))) {
                int mode = PListUtils.toInteger(property, key).intValue();
                controller.setAutoRebootState(mode == 1 ? 1 : 0);
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.EFFECT_FLAGS)))) {
                int mode = PListUtils.toInteger(property, key).intValue();
                controller.setAudibleAlarmState((mode & 1) != 0 ? 0 : 1);
                continue;
            }
            if (key.equals(String.valueOf(String.valueOf(AcpPropertyCode.EMAIL_NOTIFICATION)))) {
                StringReader reader = new StringReader(PListUtils.toString(property, key));
                Object hierarchy = null;
                try {
                    hierarchy = PropertyListUtilities.readXML(reader);
                }
                catch (Exception exception) {}
                if (hierarchy == null || !(hierarchy instanceof List)) continue;
                List list = (List)hierarchy;
                Map map = PListUtils.toDictionary(list.get(0));
                EmailNotifications notifications = EmailNotifications.fromMap(map);
                controller.setEmailNotificationsData(notifications);
                continue;
            }
            logger.warn("unrecognized ACP property \"" + key + "\" = \"" + property + "\"");
        }
        try {
            networkInterface.setDns(dns);
        }
        catch (UnknownHostException e) {
            logger.error("Failed to DNS addresses : " + e);
        }
    }

    private void updateSystemStatus(SystemController controller, PropertyList plist) throws PropertyListException, AcpxCommandException {
        String cmd = "/system/get-system-status";
        int id = controller.getId();
        RaidController rc = this.system.getRaidController(id);
        FibreChannelInterface fcInterface = (FibreChannelInterface)rc.getHostInterface(1);
        Fan fan = this.system.getFan(id);
        Battery battery = this.system.getBattery(id);
        PowerSupply ps = this.system.getPowerSupply(id);
        logger.info(String.valueOf(this.hostAddress) + " -> Updating system status for " + controller.getName());
        Map rootDict = PListUtils.toDictionary(plist.getRootElement(), "/system/get-system-status root dict");
        List responseArray = PListUtils.toArray(rootDict.get("responses"), "/system/get-system-status response array");
        Map responseDict = PListUtils.toDictionary(responseArray.get(0), "/system/get-system-status response dict");
        String method = PListUtils.toString(responseDict.get("method"), "method");
        if (!"/system/get-system-status".equals(method)) {
            String msg = "Response method \"" + method + "\" does not match command \"" + "/system/get-system-status" + "\"";
            logger.error(msg);
            throw new AcpxCommandException(msg);
        }
        int err = this.getCommandStatus(responseDict);
        if (err != 0) {
            String msg = "ACP error for \"/system/get-system-status\" command (status = " + err + ")";
            logger.error(msg);
            throw new AcpxCommandException(msg);
        }
        Map outputsDict = PListUtils.toDictionary(responseDict.get("outputs"), "/system/get-system-status outputs dict");
        Map statusDict = PListUtils.toDictionary(outputsDict.get("status"), "status");
        Map rcDict = PListUtils.toDictionary(statusDict.get("raid-controller"), "raid-controller");
        String state = PListUtils.toString(rcDict.get("fibre-link-state"), "fibre-link-state");
        if (state.equalsIgnoreCase("down")) {
            fcInterface.setLinkState(0);
        } else if (state.equalsIgnoreCase("up")) {
            fcInterface.setLinkState(1);
        } else {
            logger.warn("Unknown power Fibre Channel link state \"" + state + "\"");
            fcInterface.setLinkState(-1);
        }
        state = PListUtils.toString(rcDict.get("state"), "state");
        logger.info(String.valueOf(this.hostAddress) + " -> RAID controller ready state \"" + state + "\"");
        if (state.equalsIgnoreCase("on")) {
            rc.setReadyState(1);
        } else if (state.equalsIgnoreCase("off")) {
            rc.setReadyState(0);
        } else {
            logger.warn("Unknown RAID controller ready state \"" + state + "\"");
        }
        Map enclosureDict = PListUtils.toDictionary(statusDict.get("enclosure"), "enclosure");
        String syncState = PListUtils.toString(enclosureDict.get("xsync-state"), "xsync-state");
        if (syncState.equalsIgnoreCase("master")) {
            state = PListUtils.toString(enclosureDict.get("service-id"), "service-id");
            logger.info(String.valueOf(this.hostAddress) + " -> Service ID \"" + state + "\"");
            if (state.equalsIgnoreCase("on")) {
                this.system.setServiceIdState(1);
            } else if (state.equalsIgnoreCase("off")) {
                this.system.setServiceIdState(0);
            } else {
                logger.warn("Unknown service ID state \"" + state + "\"");
                this.system.setServiceIdState(-1);
            }
        }
        List smartArray = PListUtils.toArray(statusDict.get("smart"), "smart");
        Iterator iter = smartArray.iterator();
        while (iter.hasNext()) {
            byte[] data;
            Map smartEntry = PListUtils.toDictionary(iter.next(), "smart dict");
            int diskId = PListUtils.toInteger(smartEntry.get("drive-id"), "drive-id").intValue();
            state = PListUtils.toString(smartEntry.get("state"), "state");
            int status = PListUtils.toInteger(smartEntry.get("status"), "status").intValue();
            if (state.equalsIgnoreCase("slot-is-empty") || status != 0) continue;
            Disk disk = rc.getDisk(diskId);
            if (disk == null) {
                String msg = "Failed to retrieve disk ID " + diskId + " from " + rc.getName() + "while processing SMART.";
                logger.error(msg);
                continue;
            }
            logger.info(String.valueOf(this.hostAddress) + " -> Updating SMART status for " + disk.getName() + " = " + state);
            if (state.equalsIgnoreCase("drive-tested-ok")) {
                disk.setSmartStatus(0);
            } else if (state.equalsIgnoreCase("threshold-exceeded")) {
                disk.setSmartStatus(2);
            } else if (state.equalsIgnoreCase("controller-not-ready") || state.equalsIgnoreCase("slot-state-unknown") || state.equalsIgnoreCase("slot-failed-error") || state.equalsIgnoreCase("slot-enabled-smart")) {
                disk.setSmartStatus(-1);
            } else {
                logger.warn("Unrecognized SMART status (" + status + ")");
            }
            try {
                data = PListUtils.toData(smartEntry.get("smart-data"), "smart-data");
            }
            catch (PropertyListException propertyListException) {
                logger.warn("Could not retrieve smart data.");
                data = null;
            }
            disk.setSmartData(data);
        }
        Map monitorDict = PListUtils.toDictionary(statusDict.get("monitor"), "monitor");
        boolean emailSent = false;
        Iterator iter2 = monitorDict.entrySet().iterator();
        while (iter2.hasNext()) {
            int status;
            Map.Entry entry = iter2.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            state = PListUtils.toString(value, key);
            if (state.equalsIgnoreCase("ok")) {
                status = 0;
            } else if (state.equalsIgnoreCase("bad")) {
                status = 2;
                emailSent = true;
            } else {
                status = -1;
                logger.warn("Unknown monitor state \"" + state + "\"");
            }
            logger.info(String.valueOf(this.hostAddress) + " -> Monitored property \"" + key + "\" = " + state);
            if (key.equalsIgnoreCase("emu-temperature")) {
                controller.setTemperatureStatus(status);
                continue;
            }
            if (key.equalsIgnoreCase("blower-speed")) {
                if (fan == null) continue;
                fan.setSpeedStatus(status);
                continue;
            }
            if (key.equalsIgnoreCase("raid-controller-temperature")) {
                if (rc == null) continue;
                rc.setTemperatureStatus(status);
                continue;
            }
            if (key.equalsIgnoreCase("blower-temperature")) continue;
            if (key.equalsIgnoreCase("battery")) {
                if (battery == null) continue;
                battery.setStatus(status);
                continue;
            }
            if (key.equalsIgnoreCase("ambient-temperature") || key.equalsIgnoreCase("drive-temperature") || key.equalsIgnoreCase("raid-communication") || key.equalsIgnoreCase("smart")) continue;
            key.equalsIgnoreCase("power-supply");
        }
        if (emailSent) {
            this.system.setEmailNotificationStatus(1);
        }
    }

    private void updateUpsStatus(PropertyList sysStatusTop, PropertyList sysStatusBottom) throws PropertyListException {
        String cmd = "/system/get-system-status";
        int[] upsStatus = new int[2];
        int i = 0;
        while (i < upsStatus.length) {
            PropertyList plist = i == 0 ? sysStatusTop : sysStatusBottom;
            Map rootDict = PListUtils.toDictionary(plist.getRootElement(), "/system/get-system-status root dict");
            List responseArray = PListUtils.toArray(rootDict.get("responses"), "/system/get-system-status response array");
            Map responseDict = PListUtils.toDictionary(responseArray.get(0), "/system/get-system-status response dict");
            Map outputsDict = PListUtils.toDictionary(responseDict.get("outputs"), "/system/get-system-status outputs dict");
            Map statusDict = PListUtils.toDictionary(outputsDict.get("status"), "status");
            if (statusDict.containsKey("ups")) {
                Map upsDict = PListUtils.toDictionary(statusDict.get("ups"), "ups");
                boolean batteryInUse = PListUtils.toBoolean(upsDict.get("battery-in-use"), "battery-in-use");
                boolean batteryIsLow = PListUtils.toBoolean(upsDict.get("battery-is-low"), "battery-is-low");
                boolean linePowerDown = PListUtils.toBoolean(upsDict.get("line-power-is-down"), "line-power-is-down");
                upsStatus[i] = -1;
                if (batteryInUse || linePowerDown) {
                    upsStatus[i] = 0;
                }
                if (batteryIsLow) {
                    upsStatus[i] = 1;
                }
            } else {
                logger.error(String.valueOf(this.hostAddress) + " -> ERROR - no \"ups\" dictionary found in the " + (i == 0 ? "top" : "bottom") + " system status response plist");
            }
            ++i;
        }
        if (upsStatus[0] == 1 || upsStatus[1] == 1) {
            this.system.setUpsStatus(1);
            logger.info(String.valueOf(this.hostAddress) + " -> Setting UPS status to UPS_POWER_FAILURE");
        } else if (upsStatus[0] == 0 || upsStatus[1] == 0) {
            this.system.setUpsStatus(0);
            logger.info(String.valueOf(this.hostAddress) + " -> Setting UPS status to UPS_POWER_FAILURE");
        } else {
            this.system.setUpsStatus(-1);
        }
    }

    private void updateSystemTime(PropertyList plist) throws PropertyListException, AcpxCommandException {
        String cmd = "get-rtc";
        Map rootDict = PListUtils.toDictionary(plist.getRootElement(), "get-rtc root dict");
        Map cmdDict = PListUtils.toDictionary(rootDict.get("get-rtc"), "get-rtc command dict");
        int err = this.getCommandStatus(cmdDict);
        if (err != 0) {
            String msg = "ACP error for \"get-rtc\" command (status = " + err + ")";
            throw new AcpxCommandException(msg);
        }
        Date rtc = PListUtils.toDate(cmdDict.get("rtc"), "rtc");
        this.system.setTimeOffset(new Date().getTime() - rtc.getTime());
        logger.info(String.valueOf(this.hostAddress) + " -> Xserve RAID Time " + rtc);
    }

    private void updateDisks(RaidController controller, PropertyList plist) throws PropertyListException, AcpxCommandException {
        String cmd = "get-page";
        logger.info(String.valueOf(this.hostAddress) + " -> Processing slot page 1 for " + controller.getName());
        Map rootDict = PListUtils.toDictionary(plist.getRootElement(), "get-page root dict");
        Map cmdDict = PListUtils.toDictionary(rootDict.get("get-page"), "get-page command dict");
        int err = this.getCommandStatus(cmdDict);
        if (err != 0) {
            String msg = "ACP error for \"get-page\" command (status = " + err + ")";
            logger.error(msg);
            throw new AcpxCommandException(msg);
        }
        List slotsArray = PListUtils.toArray(cmdDict.get("slots"), "slots");
        HashSet<Disk> existing = new HashSet<Disk>();
        Iterator iter = slotsArray.iterator();
        while (iter.hasNext()) {
            Map slotDict = PListUtils.toDictionary(iter.next(), "slot dict");
            int diskId = PListUtils.toInteger(slotDict.get("id"), "id").intValue();
            Disk disk = controller.getDisk(diskId);
            if (disk == null) {
                String msg = "Disk ID " + diskId + " not found";
                logger.error(msg);
                throw new Error(msg);
            }
            this.updateDisk(disk, slotDict);
            controller.getDiskSlot(diskId).setPopulated(true);
            existing.add(disk);
        }
        Iterator iter2 = controller.getDisks().iterator();
        while (iter2.hasNext()) {
            Disk disk = (Disk)iter2.next();
            DiskSlot slot = controller.getDiskSlot(disk.getNativeId());
            if (existing.contains(disk) || disk.getState() == -2) continue;
            disk.clear();
            disk.setState(-2);
            slot.setPopulated(false);
            logger.info(String.valueOf(this.hostAddress) + " -> Clearing " + disk.getName());
        }
    }

    private void updateDisk(Disk disk, Map diskDict) throws PropertyListException {
        logger.info(String.valueOf(this.hostAddress) + " -> Updating " + disk.getName());
        disk.setModel(PListUtils.toString(diskDict.get("disk-vendor-id"), "disk-vendor-id"));
        disk.setRevision(PListUtils.toString(diskDict.get("disk-firmware-version"), "disk-firmware-version"));
        disk.setCapacity(PListUtils.toInteger(diskDict.get("disk-sector-capacity"), "disk-sector-capacity").intValue());
        disk.setBadBlockCount(PListUtils.toInteger(diskDict.get("disk-bad-block-count"), "disk-bad-block-count").intValue());
        disk.setRemappedBlockCount(PListUtils.toInteger(diskDict.get("disk-remap-count"), "disk-remap-count").intValue());
    }

    private void updateLockState(PropertyList plist) throws PropertyListException, AcpxCommandException {
        String cmd = "get-device-properties";
        Map deviceDict = this.getCommandDictionary(plist, "get-device-properties");
        String state = PListUtils.toString(deviceDict.get("state"), "state");
        if (state.equals("locked")) {
            this.system.setLockState(1);
        } else if (state.equals("unlocked")) {
            this.system.setLockState(0);
        } else {
            logger.error("Unrecognized lock state \"" + state + "\"");
        }
    }

    private void updatePowerSupply(int id, PropertyList plist) throws PropertyListException, AcpxCommandException {
        String cmd = "get-device-properties";
        Map deviceDict = this.getCommandDictionary(plist, "get-device-properties");
        int idEntry = PListUtils.toInteger(deviceDict.get("id"), "id").intValue();
        if (id != idEntry) {
            String msg = "Power supply ID returned in response (" + idEntry + ") does not match requested ID (" + id + ")";
            logger.error(msg);
            throw new AcpxCommandException(msg);
        }
        PowerSupply ps = this.system.getPowerSupply(id);
        if (ps == null) {
            String msg = "Power supply ID " + id + " does not exist";
            logger.error(msg);
            throw new Error(msg);
        }
        String state = PListUtils.toString(deviceDict.get("state"), "state");
        if (state.equalsIgnoreCase("okay")) {
            ps.setStatus(0);
        } else if (state.equalsIgnoreCase("predictive-failure")) {
            ps.setStatus(1);
        } else if (state.equalsIgnoreCase("failed")) {
            ps.setStatus(2);
        } else {
            logger.warn("Unknown power supply state \"" + state + "\"");
            ps.setStatus(-1);
        }
    }

    private void updateBattery(int id, PropertyList plist) throws PropertyListException, AcpxCommandException {
        Battery removed;
        String cmd = "get-device-properties";
        Map deviceDict = this.getCommandDictionary(plist, "get-device-properties");
        Battery battery = this.system.getBattery(id);
        boolean present = PListUtils.toBoolean(deviceDict.get("present"), "present");
        if (present) {
            boolean created = false;
            if (battery == null) {
                battery = new Battery(id);
                created = true;
            }
            if (deviceDict.containsKey("charging")) {
                boolean charging = PListUtils.toBoolean(deviceDict.get("charging"), "charging");
                battery.setIsCharging(charging);
            } else {
                battery.setIsCharging(true);
            }
            int charge = PListUtils.toInteger(deviceDict.get("charge-percentage"), "charge-percentage").intValue();
            battery.setChargePercent(charge);
            if (created) {
                this.system.addBattery(battery);
            }
        } else if (battery != null && (removed = this.system.removeBattery(id)) == null) {
            logger.error("Attempt to remove battery ID " + id + " failed");
        }
    }

    private void updateFan(int id, PropertyList plist) throws PropertyListException, AcpxCommandException {
        Fan removed;
        String cmd = "get-device-properties";
        Map deviceDict = this.getCommandDictionary(plist, "get-device-properties");
        Fan fan = this.system.getFan(id);
        boolean present = PListUtils.toBoolean(deviceDict.get("present"), "present");
        if (present) {
            boolean created = false;
            if (fan == null) {
                fan = new Fan(id);
                created = true;
            }
            int rpm = PListUtils.toInteger(deviceDict.get("rpm"), "rpm").intValue();
            fan.setRpm(rpm);
            if (created) {
                this.system.addFan(fan);
            }
        } else if (fan != null && (removed = this.system.removeFan(id)) == null) {
            logger.error("Attempt to remove fan ID " + id + " failed");
        }
    }

    private void updateSystemControllerLocation(SystemController controller, PropertyList plist) throws PropertyListException, AcpxCommandException {
        String cmd = "get-device-properties";
        Map deviceDict = this.getCommandDictionary(plist, "get-device-properties");
        String location = PListUtils.toString(deviceDict.get("location"), "location");
        if (!(location.equals("top") || location.equals("bottom") || location.equals("unknown"))) {
            String msg = "Unrecognized system controller location \"" + location + "\"";
            logger.error(msg);
        }
    }

    private void updateDiskHandle(int id, PropertyList plist) throws PropertyListException, AcpxCommandException {
        Disk disk;
        String cmd = "get-device-properties";
        Map deviceDict = this.getCommandDictionary(plist, "get-device-properties");
        RaidController rc = this.system.getRaidControllerForDiskSlot(id);
        if (rc != null && (disk = rc.getDisk(id)) != null) {
            String state = PListUtils.toString(deviceDict.get("handle-state"), "handle-state");
            if (state.equalsIgnoreCase("open")) {
                disk.setHandleState(0);
            } else if (state.equalsIgnoreCase("closed")) {
                disk.setHandleState(1);
            } else {
                logger.warn("Unknown disk handle state \"" + state + "\"");
            }
        }
    }

    private void processPage0(RaidController controller, PropertyList plist) throws PropertyListException, AcpxCommandException {
        String cmd = "get-page";
        List diskChannelArray = null;
        List hostInterfaceArray = null;
        List maskArray = null;
        FibreChannelInterface fc = (FibreChannelInterface)controller.getHostInterface(1);
        logger.info(String.valueOf(this.hostAddress) + " -> Processing RAID controller page 0 for " + controller.getName());
        Map rootDict = PListUtils.toDictionary(plist.getRootElement(), "get-page root dict");
        Map cmdDict = PListUtils.toDictionary(rootDict.get("get-page"), "get-page command dict");
        int err = this.getCommandStatus(cmdDict);
        if (err != 0) {
            String msg = "ACP error for \"get-page\" command (status = " + err + ")";
            logger.error(msg);
            throw new AcpxCommandException(msg);
        }
        Iterator iter = cmdDict.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                logger.warn("raid controller property \"" + value + "\" has no data");
                continue;
            }
            if (key.equals("id")) continue;
            if (key.equals("production-id")) {
                controller.setProductId(PListUtils.toString(value, key));
                continue;
            }
            if (key.equals("model-name")) {
                controller.setModelName(PListUtils.toString(value, key));
                continue;
            }
            if (key.equals("serial-number")) {
                controller.setSerialNumber(PListUtils.toString(value, key));
                continue;
            }
            if (key.equals("stripe-size")) {
                controller.setStripeSize(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("write-buffer-enabled")) {
                boolean enabled = PListUtils.toBoolean(value, key);
                controller.setWriteCacheState(enabled ? 1 : 0);
                continue;
            }
            if (key.equals("host-interface-count")) {
                controller.setHostInterfaceCount(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("drive-channel-count")) {
                controller.setDiskChannelCount(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("slot-count")) {
                controller.setSlotCount(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("memory-size")) {
                controller.setMemorySize(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("cache-hit-ratio")) {
                controller.setCacheHitRatio(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("ready-state")) continue;
            if (key.equals("client-count")) {
                controller.setClientCount(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("firmware-version")) {
                controller.setFirmwareVersion(PListUtils.toString(value, key));
                continue;
            }
            if (key.equals("fibre-channel-mac-address")) {
                fc.setWorldWidePortName(PListUtils.toString(value, key));
                continue;
            }
            if (key.equals("access-mode")) {
                String mode = PListUtils.toString(value, key);
                if (mode.equalsIgnoreCase("sequential")) {
                    controller.setAccessMode(0);
                    continue;
                }
                if (mode.equalsIgnoreCase("random")) {
                    controller.setAccessMode(1);
                    continue;
                }
                controller.setAccessMode(-1);
                logger.warn("unknown RAID controller access mode  \"" + mode + "\"");
                continue;
            }
            if (key.equals("prefetch-size")) {
                controller.setPrefetchSize(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("auto-rebuild-enabled")) {
                controller.setAutoRebuildEnabled(PListUtils.toBoolean(value, key));
                continue;
            }
            if (key.equals("rebuild-rate")) {
                controller.setRebuildRate(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("check-data-generation-enabled")) {
                controller.setCheckDataGenerationEnabled(PListUtils.toBoolean(value, key));
                continue;
            }
            if (key.equals("lun-mask-enabled")) {
                int enabled = PListUtils.toBoolean(value, key) != false ? 1 : 0;
                controller.setLunMaskEnabled(enabled);
                continue;
            }
            if (key.equals("jbod-mask-enabled")) {
                controller.setJbodMaskEnabled(PListUtils.toBoolean(value, key));
                continue;
            }
            if (key.equals("jbod-enabled")) {
                controller.setJbodModeState(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("diagnostic-function-status")) {
                String status = PListUtils.toString(value, key);
                if (status.equalsIgnoreCase("ready")) {
                    controller.setDiagnosticFunctionStatus(1);
                    continue;
                }
                controller.setDiagnosticFunctionStatus(-1);
                continue;
            }
            if (key.equals("protocol-error-count")) {
                fc.setProtocolErrorCount(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("invalid-transmission-word-count")) {
                fc.setInvalidTransmissionWordCount(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("invalid-crc-count")) {
                fc.setInvalidCyclicRedundancyCodeCount(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("loss-of-signal-count")) {
                fc.setLossOfSignalCount(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("loss-of-sync-count")) {
                fc.setLossOfSyncCount(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("link-failure-count")) {
                fc.setLinkFailureCount(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("bgrw-threshold")) {
                controller.setBackgroundConditioningPriority(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("slow-read-bypass-mode")) {
                controller.setSlowReadBypassModeState(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("synchronize-cache-mode")) {
                controller.setSyncCacheState(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("drive-channels")) {
                diskChannelArray = PListUtils.toArray(value, key);
                continue;
            }
            if (key.equals("host-interfaces")) {
                hostInterfaceArray = PListUtils.toArray(value, key);
                continue;
            }
            if (key.equals("lun-masks")) {
                maskArray = PListUtils.toArray(value, key);
                continue;
            }
            logger.warn("unrecognized RAID controller property \"" + key + "\" = \"" + value + "\"");
        }
        if (diskChannelArray != null) {
            this.updateDiskChannels(controller, diskChannelArray, controller.getDiskChannelCount());
        } else {
            logger.warn("\"drive-channels\" property was not encountered");
        }
        if (hostInterfaceArray != null) {
            this.updateHostInterfaces(controller, hostInterfaceArray, controller.getHostInterfaceCount());
        } else {
            logger.warn("\"host-interfaces\" property was not encountered");
        }
        if (maskArray != null) {
            this.updateLunMasks(controller, maskArray);
        } else {
            logger.warn("\"lun-masks\" property was not encountered");
        }
    }

    private void updateDiskChannels(RaidController controller, List channels, int count) throws PropertyListException {
        Iterator iter = channels.iterator();
        while (iter.hasNext()) {
            Map channelDict = PListUtils.toDictionary(iter.next(), "channel dict");
            int id = PListUtils.toInteger(channelDict.get("id"), "id").intValue();
            if (id > count) continue;
            DiskSlot slot = controller.getDiskSlot(id);
            if (slot == null) {
                String msg = "disk slot " + id + " not found";
                logger.error(msg);
                throw new Error(msg);
            }
            Object mode = channelDict.get("dma-mode");
            if (mode != null) {
                slot.setDmaMode(PListUtils.toInteger(mode, "dma-mode").intValue());
            }
            if ((mode = channelDict.get("ultra-dma-mode")) != null) {
                slot.setUltraDmaMode(PListUtils.toInteger(mode, "ultra-dma-mode").intValue());
            }
            logger.info(String.valueOf(this.hostAddress) + " -> Disk channel " + id + " mode = " + mode);
        }
    }

    private void updateHostInterfaces(RaidController controller, List interfaceArray, int count) throws PropertyListException {
        Iterator iter = interfaceArray.iterator();
        while (iter.hasNext()) {
            Map interfaceDict = PListUtils.toDictionary(iter.next(), "host interface dict");
            int id = PListUtils.toInteger(interfaceDict.get("id"), "id").intValue();
            if (id > count) continue;
            HostInterface hostIf = controller.getHostInterface(id);
            if (hostIf == null) {
                logger.warn("host interface ID " + id + " not found");
                continue;
            }
            this.updateHostInterface(hostIf, interfaceDict);
        }
    }

    private void updateHostInterface(HostInterface hostInterface, Map interfaceDict) throws PropertyListException {
        if (hostInterface == null) {
            throw new NullPointerException("host interface cannot be null");
        }
        if (interfaceDict == null) {
            throw new NullPointerException("interface dictionary cannot be null");
        }
        if (!(hostInterface instanceof FibreChannelInterface)) {
            String msg = "Only Fibre Channel host interfaces are supported: " + hostInterface.getClass();
            logger.fatal(msg);
            throw new Error(msg);
        }
        FibreChannelInterface fc = (FibreChannelInterface)hostInterface;
        logger.info(String.valueOf(this.hostAddress) + " -> Updating " + fc.getName());
        Iterator iter = interfaceDict.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.equals("id") || key.equals("type")) continue;
            if (key.equals("hard-loop-id")) {
                fc.setHardLoopId(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("hard-loop-id-enabled")) {
                boolean hardloopEnabled = PListUtils.toBoolean(value, key);
                if (hardloopEnabled) {
                    fc.setHardLoopIdEnabled(1);
                    continue;
                }
                fc.setHardLoopIdEnabled(0);
                continue;
            }
            if (key.equals("topology")) {
                String topology = PListUtils.toString(value, key);
                if (topology.equalsIgnoreCase("arbitrated-loop")) {
                    fc.setTopology(0);
                    continue;
                }
                if (topology.equalsIgnoreCase("point-to-point")) {
                    fc.setTopology(1);
                    continue;
                }
                if (topology.equalsIgnoreCase("auto")) {
                    fc.setTopology(2);
                    continue;
                }
                fc.setTopology(-1);
                logger.warn("unknown Fibre Channel topology \"" + topology + "\"");
                continue;
            }
            if (key.equals("actual-topology")) {
                String topology = PListUtils.toString(value, key);
                if (topology.equalsIgnoreCase("arbitrated-loop")) {
                    fc.setActualTopology(0);
                    continue;
                }
                if (topology.equalsIgnoreCase("point-to-point")) {
                    fc.setActualTopology(1);
                    continue;
                }
                fc.setActualTopology(-1);
                logger.warn("unknown Fibre Channel topology \"" + topology + "\"");
                continue;
            }
            if (key.equals("speed")) {
                String speed = PListUtils.toString(value, key);
                if (speed.equalsIgnoreCase("auto-negotiated")) {
                    fc.setSpeed(0);
                    continue;
                }
                if (speed.equalsIgnoreCase("1Gb/sec")) {
                    fc.setSpeed(1);
                    continue;
                }
                if (speed.equalsIgnoreCase("2Gb/sec")) {
                    fc.setSpeed(2);
                    continue;
                }
                fc.setSpeed(-1);
                logger.warn("unknown Fibre Channel speed \"" + speed + "\"");
                continue;
            }
            if (key.equals("actual-speed")) {
                String speed = PListUtils.toString(value, key);
                if (speed.equalsIgnoreCase("1Gb/sec")) {
                    fc.setActualSpeed(1);
                    continue;
                }
                if (speed.equalsIgnoreCase("2Gb/sec")) {
                    fc.setActualSpeed(2);
                    continue;
                }
                fc.setActualSpeed(-1);
                logger.warn("unknown Fibre Channel speed \"" + speed + "\"");
                continue;
            }
            if (key.equals("max-speed")) {
                String speed = PListUtils.toString(value, key);
                if (speed.equalsIgnoreCase("1Gb/sec")) {
                    fc.setMaximumSpeed(1);
                    continue;
                }
                if (speed.equalsIgnoreCase("2Gb/sec")) {
                    fc.setMaximumSpeed(2);
                    continue;
                }
                fc.setMaximumSpeed(-1);
                logger.warn("unknown Fibre Channel maximum speed \"" + speed + "\"");
                continue;
            }
            if (key.equals("lun-map")) {
                this.lunList = PListUtils.toArray(value, key);
                continue;
            }
            logger.warn("Unrecognized host interface property  \"" + key + "\" = \"" + value + "\"");
        }
    }

    private void updateLunMasks(RaidController controller, List luns) throws PropertyListException {
        logger.info(String.valueOf(this.hostAddress) + " -> Updating LUN masks");
        FibreChannelInterface fc = (FibreChannelInterface)controller.getHostInterface(1);
        ArrayList<LunMaskSetting> list = new ArrayList<LunMaskSetting>();
        Iterator iter = luns.iterator();
        while (iter.hasNext()) {
            Map maskDict = PListUtils.toDictionary(iter.next(), "mask dict");
            Integer id = new Integer(PListUtils.toInteger(maskDict.get("id"), "id").intValue());
            String wwn = PListUtils.toString(maskDict.get("fibre-channel-mac-address"), "fibre-channel-mac-address");
            List lunIds = PListUtils.toArray(maskDict.get("lun-ids"), "lun-ids");
            LunMaskSetting settings = new LunMaskSetting(id, wwn, lunIds);
            list.add(settings);
            logger.info("    Mask " + id + " wwn=" + wwn + ", LUN's=" + lunIds);
        }
        fc.setLunMaskList(list);
    }

    private void processPage1(RaidController controller, PropertyList plist) throws PropertyListException, AcpxCommandException {
        String cmd = "get-page";
        logger.info(String.valueOf(this.hostAddress) + " -> Processing RAID controller page 1 for " + controller.getName());
        Map rootDict = PListUtils.toDictionary(plist.getRootElement(), "get-page root dict");
        Map cmdDict = PListUtils.toDictionary(rootDict.get("get-page"), "get-page command dict");
        int err = this.getCommandStatus(cmdDict);
        if (err != 0) {
            String msg = "ACP error for \"get-page\" command (status = " + err + ")";
            logger.error(msg);
            throw new AcpxCommandException(msg);
        }
        Iterator iter = cmdDict.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                logger.warn("raid controller property \"" + value + "\" has no data");
                continue;
            }
            if (key.equals("id")) continue;
            if (key.equals("controller")) {
                Map controllerDict = PListUtils.toDictionary(value, key);
                Map status = PListUtils.toDictionary(controllerDict.get("status"), "status");
                this.updateRaidControllerStatus(controller, status);
                continue;
            }
            if (key.equals("page-status")) {
                Map status = PListUtils.toDictionary(value, key);
                boolean changed = false;
                boolean checking = false;
                Object o = status.get("changed");
                if (o != null) {
                    changed = PListUtils.toBoolean(o, "changed");
                }
                if ((o = status.get("checking-array")) == null) continue;
                checking = PListUtils.toBoolean(o, "checking-array");
                continue;
            }
            if (key.equals("battery-status")) continue;
            if (key.equals("cpu-temperature")) {
                controller.setCpuTemperature(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("arrays")) {
                this.updateRaidSets(controller, PListUtils.toArray(value, key));
                continue;
            }
            if (key.equals("slots")) {
                this.page1SlotsArray = PListUtils.toArray(value, key);
                continue;
            }
            logger.warn("Unrecognized RAID info (page 1) property  \"" + key + "\" = \"" + value + "\"");
        }
    }

    private void updateRaidControllerStatus(RaidController controller, Map statusDict) throws PropertyListException {
        logger.info(String.valueOf(this.hostAddress) + " -> Updating " + controller.getName() + " status");
        Iterator iter = statusDict.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                logger.warn("raid controller status \"" + value + "\" has no data");
                continue;
            }
            if (key.equals("ups-warning") || key.equals("temperature-warning") || key.equals("fan-warning") || key.equals("power-warning")) continue;
            logger.warn("Unrecognized raid controller status property \"" + key + "\" = \"" + value + "\"");
        }
    }

    private void updateRaidSets(RaidController controller, List raidsets) throws PropertyListException {
        HashSet<RaidSet> existing = new HashSet<RaidSet>();
        Iterator iter = raidsets.iterator();
        while (iter.hasNext()) {
            int state;
            Map dict = PListUtils.toDictionary(iter.next(), "array dict");
            int id = PListUtils.toInteger(dict.get("id"), "id").intValue();
            boolean created = false;
            RaidSet rs = controller.getRaidSet(id);
            if (rs == null) {
                rs = new RaidSet(id, controller);
                created = true;
            }
            this.updateRaidSet(controller, rs, dict);
            if (created) {
                controller.addRaidSet(rs);
            }
            if ((state = rs.getState()) == 0 || state == 2) {
                this.system.notifyRaidSetOnline(rs);
            }
            existing.add(rs);
        }
        Iterator iter2 = controller.getRaidSets().iterator();
        while (iter2.hasNext()) {
            RaidSet rs = (RaidSet)iter2.next();
            if (existing.contains(rs)) continue;
            logger.info(String.valueOf(this.hostAddress) + " -> Removing " + rs.getName());
            Iterator members = rs.getMembers().iterator();
            while (members.hasNext()) {
                Disk disk = (Disk)members.next();
                disk.setRaidSet(-2);
            }
            RaidSet removed = controller.removeRaidSet(rs.getNativeId());
            if (removed != null) continue;
            logger.warn("attempt to remove " + rs.getName() + " failed");
        }
    }

    private void updateRaidSet(RaidController controller, RaidSet rs, Map dict) throws PropertyListException {
        int memberCount = 0;
        logger.info(String.valueOf(this.hostAddress) + " -> Updating " + rs.getName());
        Iterator iter = dict.entrySet().iterator();
        while (iter.hasNext()) {
            String state;
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                logger.warn("raid set property \"" + value + "\" has no data");
                continue;
            }
            if (key.equals("id")) continue;
            if (key.equals("stripe-size")) {
                rs.setStripeSize(PListUtils.toInteger(value, key).intValue());
                continue;
            }
            if (key.equals("raid-level")) {
                String level = PListUtils.toString(value, key);
                if (level.equalsIgnoreCase("0")) {
                    rs.setRaidLevel(0);
                    continue;
                }
                if (level.equalsIgnoreCase("1")) {
                    rs.setRaidLevel(1);
                    continue;
                }
                if (level.equalsIgnoreCase("3")) {
                    rs.setRaidLevel(3);
                    continue;
                }
                if (level.equalsIgnoreCase("5")) {
                    rs.setRaidLevel(5);
                    continue;
                }
                if (level.equalsIgnoreCase("0+1")) {
                    rs.setRaidLevel(6);
                    continue;
                }
                if (level.equalsIgnoreCase("JBOD")) {
                    rs.setRaidLevel(255);
                    continue;
                }
                rs.setRaidLevel(-1);
                logger.warn("unknown RAID level \"" + level + "\"");
                continue;
            }
            if (key.equals("member-count")) {
                memberCount = PListUtils.toInteger(value, key).intValue();
                continue;
            }
            if (key.equals("raid-type")) {
                String type = PListUtils.toString(value, key);
                if (type.equalsIgnoreCase("regular")) {
                    rs.setInitializationMode(0);
                    continue;
                }
                if (type.equalsIgnoreCase("raid-now")) {
                    rs.setInitializationMode(1);
                    continue;
                }
                rs.setInitializationMode(-1);
                logger.warn("unknown raid set initialization mode \"" + type + "\"");
                continue;
            }
            if (key.equals("sector-capacity")) {
                rs.setCapacity(PListUtils.toInteger(value, key));
                continue;
            }
            if (key.equals("slices")) {
                this.updateSlices(rs, PListUtils.toArray(value, key));
                continue;
            }
            if (key.equals("bgrw-status")) {
                state = PListUtils.toString(value, key);
                if (state.equalsIgnoreCase("stop")) {
                    rs.setBackgroundConditioningState(0);
                    continue;
                }
                if (state.equalsIgnoreCase("pause")) {
                    rs.setBackgroundConditioningState(1);
                    continue;
                }
                if (state.equalsIgnoreCase("start")) {
                    rs.setBackgroundConditioningState(2);
                    continue;
                }
                rs.setBackgroundConditioningState(-1);
                logger.error("unknown bgrw-status \"" + state + "\"");
                continue;
            }
            if (key.equals("progress")) {
                this.updateRaidSetProgress(rs, PListUtils.toDictionary(value, key));
                continue;
            }
            if (key.equals("members")) {
                this.updateRaidSetMembers(controller, rs, PListUtils.toArray(value, key));
                continue;
            }
            if (key.equals("raid-status")) {
                state = PListUtils.toString(value, key);
                if (state.equalsIgnoreCase("online")) {
                    rs.setState(0);
                    continue;
                }
                if (state.equalsIgnoreCase("offline")) {
                    rs.setState(1);
                    logger.warn(String.valueOf(this.hostAddress) + " -> !!! WARNING: " + rs.getName() + " state = " + state);
                    continue;
                }
                if (state.equalsIgnoreCase("degraded")) {
                    rs.setState(2);
                    continue;
                }
                if (state.equalsIgnoreCase("<unknown>")) {
                    rs.setState(-1);
                    continue;
                }
                rs.setState(-1);
                logger.warn("unknown raid set state = " + state);
                continue;
            }
            logger.warn("Unrecognized raid set property \"" + key + "\" = \"" + value + "\"");
        }
    }

    private void updateRaidSetProgress(RaidSet rs, Map dict) throws PropertyListException {
        int initialize = -1;
        int rebuild = -1;
        int verify = -1;
        int expand = -1;
        int bgrw = -1;
        logger.info(String.valueOf(this.hostAddress) + " -> Updating progress for " + rs.getName());
        Iterator iter = dict.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                logger.warn("raid set progress \"" + key + "\" has no data");
                continue;
            }
            if (key.equals("initialize")) {
                initialize = PListUtils.toInteger(value, key).intValue();
                continue;
            }
            if (key.equals("add-member")) {
                rebuild = PListUtils.toInteger(value, key).intValue();
                continue;
            }
            if (key.equals("verify")) {
                verify = PListUtils.toInteger(value, key).intValue();
                continue;
            }
            if (key.equals("expand")) {
                expand = PListUtils.toInteger(value, key).intValue();
                continue;
            }
            if (key.equals("background-read-write")) {
                bgrw = PListUtils.toInteger(value, key).intValue();
                continue;
            }
            logger.warn("Unrecognized raid set progress \"" + key + "\" = \"" + value + "\"");
        }
        boolean opInProgress = false;
        if (initialize >= 0 && initialize <= 100) {
            rs.setOperation(1);
            rs.setProgress(initialize);
            opInProgress = true;
        } else if (rebuild >= 0 && rebuild <= 100) {
            rs.setOperation(2);
            rs.setProgress(rebuild);
            opInProgress = true;
        } else if (verify >= 0 && verify <= 100) {
            rs.setOperation(3);
            rs.setProgress(verify);
            opInProgress = true;
        } else if (expand >= 0 && expand <= 100) {
            rs.setOperation(4);
            rs.setProgress(expand);
            opInProgress = true;
        } else if (bgrw >= 0 && bgrw <= 100) {
            rs.setOperation(5);
            rs.setProgress(bgrw);
            opInProgress = true;
        }
        if (!opInProgress) {
            int previousOp = rs.getOperation();
            if (previousOp == 1 || previousOp == 2) {
                rs.setState(0);
            }
            rs.setOperation(-1);
            rs.setProgress(-1);
        }
    }

    private void updateRaidSetMembers(RaidController controller, RaidSet rs, List members) throws PropertyListException {
        logger.info(String.valueOf(this.hostAddress) + " -> Updating members for " + rs.getName());
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            Map memberDict = PListUtils.toDictionary(iter.next(), "member dict");
            int slot = PListUtils.toInteger(memberDict.get("slot-id"), "slot-id").intValue();
            if (slot <= 0) continue;
            Disk disk = controller.getDisk(slot);
            if (disk == null) {
                String msg = "Failed to add disk " + slot + " to " + rs.getName() + ". Disk does not exist";
                logger.error(msg);
                continue;
            }
            boolean added = rs.addMember(disk);
            disk.setRaidSet(rs.getNativeId());
            if (!logger.isInfoEnabled()) continue;
            logger.info(String.valueOf(this.hostAddress) + " -> " + disk.getName() + (added ? " added to " : " member of ") + rs.getName() + " (" + rs.getNativeId() + ")");
        }
    }

    private void updateSlices(RaidSet rs, List sliceArray) throws PropertyListException {
        logger.info(String.valueOf(this.hostAddress) + " -> Updating slices for " + rs.getName() + " (ID " + rs.getNativeId() + ")");
        RaidController controller = rs.getController();
        RaidSystem system = controller.getRaidSystem();
        ListIterator iter = sliceArray.listIterator();
        while (iter.hasNext()) {
            Map sliceDict = PListUtils.toDictionary(iter.next(), "slice dict");
            int rawId = PListUtils.toInteger(sliceDict.get("id"), "id").intValue();
            int id = system.translateSliceId(rawId, controller.getId(), 1);
            if (id < 0 || id > 7) {
                logger.error("Error translating slice ID " + rawId + " (was translated to " + id + "). Aborting slice updates.");
                return;
            }
            if (rawId != id) {
                logger.info("updateSlices: Translated legacy slice ID " + rawId + " to " + id);
            }
            int size = PListUtils.toInteger(sliceDict.get("size"), "size").intValue();
            logger.info("     Slice " + id + ": size = " + size);
            Slice slice = rs.getSlice(id);
            if (slice != null) {
                slice.setSize(size);
                continue;
            }
            logger.error("Slice " + id + " was null");
        }
    }

    private void updatePage1Slots(RaidController controller, List slots) throws PropertyListException {
        logger.info(String.valueOf(this.hostAddress) + " -> Updating Page 1 slots for " + controller.getName());
        boolean jbodMode = false;
        if (controller.getRaidSets().isEmpty() && !controller.getJbodMaskEnabled()) {
            jbodMode = true;
        }
        Iterator iter = slots.iterator();
        while (iter.hasNext()) {
            Map slotDict = PListUtils.toDictionary(iter.next(), "slot dict");
            Map statusDict = PListUtils.toDictionary(slotDict.get("status"), "status");
            int id = PListUtils.toInteger(slotDict.get("id"), "id").intValue();
            boolean online = PListUtils.toBoolean(statusDict.get("online"), "online");
            boolean arrayMember = PListUtils.toBoolean(statusDict.get("array-member"), "array-member");
            boolean rebuilding = PListUtils.toBoolean(statusDict.get("rebuilding"), "rebuilding");
            boolean cache = PListUtils.toBoolean(statusDict.get("disk-cache-enabled"), "disk-cache-enabled");
            Disk disk = controller.getDisk(id);
            if (disk != null) {
                if (controller.getDiskSlot(id).isPopulated()) {
                    disk.setState(online ? 1 : 0);
                }
                if (!disk.isOrphanRaidMember()) {
                    if (!jbodMode) {
                        if (arrayMember || rebuilding) {
                            disk.setType(1);
                            if (disk.getRaidSet() == null) {
                                logger.warn(String.valueOf(disk.getName()) + " reported as type RAID_MEMBER with no associated RAID set");
                            }
                        } else {
                            disk.setType(0);
                        }
                    } else {
                        disk.setType(online ? 3 : 0);
                        if (arrayMember) {
                            logger.error("Slot " + id + " reported as array member in JBOD mode!");
                        }
                    }
                }
                disk.setOperation(rebuilding ? 1 : 0);
                disk.setCacheState(cache ? 1 : 0);
            } else {
                logger.error("Disk " + id + " was null");
            }
            logger.info("    Slot " + id + ": online=" + online + ", member=" + arrayMember + ", rebuilding=" + rebuilding + ", cache=" + cache + (jbodMode ? ", JBOD=true" : ""));
        }
    }

    private void processPage32(RaidController controller, PropertyList plist) throws PropertyListException, AcpxCommandException {
        String cmd = "get-page";
        logger.info(String.valueOf(this.hostAddress) + " -> Processing RAID controller Page 32 for " + controller.getName());
        Map rootDict = PListUtils.toDictionary(plist.getRootElement(), "get-page root dict");
        Map cmdDict = PListUtils.toDictionary(rootDict.get("get-page"), "get-page command dict");
        int err = this.getCommandStatus(cmdDict);
        if (err != 0) {
            String msg = "ACP error for \"get-page\" command (status = " + err + ")";
            logger.error(msg);
            throw new AcpxCommandException(msg);
        }
        int pageId = PListUtils.toInteger(cmdDict.get("id"), "page id").intValue();
        if (pageId != 32) {
            String msg = "Expected page ID 32. Got page ID " + pageId;
            logger.error(msg);
            throw new AcpxCommandException(msg);
        }
        List slots = PListUtils.toArray(cmdDict.get("slots"), "page 32 slots");
        if (slots == null) {
            String msg = "Page 32 slots array is null";
            logger.error("Page 32 slots array is null");
            throw new AcpxCommandException("Page 32 slots array is null");
        }
        Iterator slotsIter = slots.iterator();
        while (slotsIter.hasNext()) {
            Map slot = (Map)slotsIter.next();
            int slotId = PListUtils.toInteger(slot.get("id"), "slot id").intValue();
            int reason = PListUtils.toInteger(slot.get("reason"), "reason").intValue();
            Disk disk = controller.getDisk(slotId);
            if (reason != 0) {
                if (disk != null) {
                    Disk.OrphanMemberInfo orphanInfo = new Disk.OrphanMemberInfo();
                    orphanInfo.memberState = reason;
                    orphanInfo.floatingId = PListUtils.toInteger(slot.get("metadata-id-no"), "metadata-id-no");
                    orphanInfo.raidSetId = PListUtils.toInteger(slot.get("raid-no"), "raid-no").intValue();
                    orphanInfo.raidLevel = PListUtils.toInteger(slot.get("raid-level"), "raid-level").intValue();
                    orphanInfo.diskCount = PListUtils.toInteger(slot.get("disk-number"), "disk-number").intValue();
                    orphanInfo.memberIndex = PListUtils.toInteger(slot.get("member-no"), "member-no").intValue();
                    orphanInfo.raidType = PListUtils.toInteger(slot.get("raid-type"), "raid-type").intValue();
                    orphanInfo.serialNumber = PListUtils.toString(slot.get("sn-no"), "sn-no");
                    orphanInfo.metaDataUpdateCount = PListUtils.toInteger(slot.get("metadata-id-no-3"), "metadata-id-no-3");
                    disk.setOrphanRaidMember(orphanInfo);
                    logger.info(String.valueOf(this.hostAddress) + " -> Page 32 - slotId=" + slotId + "," + orphanInfo);
                    continue;
                }
                logger.error("No disk at reported orphan member slot ID " + slotId);
                continue;
            }
            if (disk == null) continue;
            disk.setOrphanRaidMember(null);
        }
    }

    private void updateLunMap(RaidController controller, List luns) throws PropertyListException {
        int NOT_MAPPED = 15;
        HashSet<Slice> mappedSlices = new HashSet<Slice>();
        logger.info(String.valueOf(this.hostAddress) + " -> Updating LUN mapping");
        if (luns == null) {
            throw new NullPointerException("LUN list cannot be null");
        }
        Iterator iter = luns.iterator();
        while (iter.hasNext()) {
            RaidSet rs;
            Map lunDict = PListUtils.toDictionary(iter.next(), "LUN dict");
            int rawLunId = PListUtils.toInteger(lunDict.get("id"), "id").intValue();
            int id = this.system.translateLunId(rawLunId, controller.getId(), 1);
            if (id < 0 || id > 7) {
                logger.error("Error translating LUN ID " + rawLunId + " (was translated to " + id + "). Aborting LUN map update.");
                return;
            }
            if (id != rawLunId) {
                logger.info("updateLunMap: Translated LUN ID " + rawLunId + " to " + id);
            }
            int arrayId = PListUtils.toInteger(lunDict.get("array-id"), "array-id").intValue();
            int sliceId = PListUtils.toInteger(lunDict.get("slice-id"), "slice-id").intValue();
            logger.info("     LUN " + id + (arrayId != 15 ? " mapped to RAID set " + arrayId + " slice " + sliceId : " not mapped"));
            if (arrayId == 15 || (rs = controller.getRaidSet(arrayId)) == null) continue;
            Slice slice = rs.getSlice(sliceId);
            if (slice != null) {
                slice.setLunId(id);
                mappedSlices.add(slice);
                continue;
            }
            logger.error("Null slice attempting to map LUN " + id + " to RS " + arrayId + ", slice " + id);
        }
        Iterator rsIter = controller.getRaidSets().iterator();
        while (rsIter.hasNext()) {
            Iterator sliceIter = ((RaidSet)rsIter.next()).getSlices().iterator();
            while (sliceIter.hasNext()) {
                Slice slice = (Slice)sliceIter.next();
                if (mappedSlices.contains(slice) || slice.getLunId() == -1) continue;
                slice.setLunId(-1);
                logger.info("     Unmapping RAID set " + slice.getRaidSet().getNativeId() + " slice " + slice.getId());
            }
        }
    }

    private void updateThermal(SystemController controller, PropertyList plist) throws PropertyListException, AcpxCommandException {
        String cmd = "get-temperature";
        Map rootDict = PListUtils.toDictionary(plist.getRootElement(), "get-temperature root dict");
        Map cmdDict = PListUtils.toDictionary(rootDict.get("get-temperature"), "get-temperature command dict");
        int err = this.getCommandStatus(cmdDict);
        if (err != 0) {
            String msg = "ACP error for \"get-temperature\" command (status = " + err + ")";
            logger.error(msg);
            throw new AcpxCommandException(msg);
        }
        int ambientTemp = PListUtils.toInteger(cmdDict.get("temperature"), "temperature").intValue();
        controller.setAmbientTemperature(ambientTemp);
    }

    private void updateEventLog(SystemController controller, PropertyList plist) throws PropertyListException, AcpxCommandException {
        String cmd = "/system/get-event-log";
        logger.info(String.valueOf(this.hostAddress) + " -> Updating " + controller.getName() + " event log");
        Map rootDict = PListUtils.toDictionary(plist.getRootElement(), "/system/get-event-log root dict");
        List responseArray = PListUtils.toArray(rootDict.get("responses"), "/system/get-event-log response array");
        Map responseDict = PListUtils.toDictionary(responseArray.get(0), "/system/get-event-log response dict");
        String method = PListUtils.toString(responseDict.get("method"), "method");
        if (!"/system/get-event-log".equals(method)) {
            String msg = "Response method \"" + method + "\" does not match command \"" + "/system/get-event-log" + "\"";
            logger.error(msg);
            throw new AcpxCommandException(msg);
        }
        int err = this.getCommandStatus(responseDict);
        if (err != 0) {
            String msg = "ACP error for \"/system/get-event-log\" command (status = " + err + ")";
            logger.error(msg);
        }
        Map outputsDict = PListUtils.toDictionary(responseDict.get("outputs"), "/system/get-event-log outputs dict");
        List entries = PListUtils.toArray(outputsDict.get("entries"), "/system/get-event-log entries dict");
        try {
            if (entries.size() > 0) {
                logger.info(String.valueOf(this.hostAddress) + " -> Adding " + entries.size() + " events to event log");
                this.system.getEventLog().appendEvents(entries.iterator(), controller.getId());
            }
        }
        catch (Exception e) {
            logger.error(e, e);
        }
    }

    private void updateConnectionFailure() {
        this.system.setUserMessageIndex(4);
        this.system.setLoggedOn(false);
        Iterator iter = this.system.getNetworkInterfaces().iterator();
        while (iter.hasNext()) {
            NetworkInterface net = (NetworkInterface)iter.next();
            net.setLinkState(-1);
            net.setStatus(-1);
        }
        this.system.setChanged();
    }

    private void updateCommunicationsError() {
        this.system.setUserMessageIndex(5);
        this.system.setChanged();
    }

    private void sendNoOpMessage() throws IOException {
        RequestMessage request = this.msgFactory.newNoOpRequest();
        request.setTargetController(null);
        Response rsp = this.comms.postMessage(request);
        if (rsp.getContent() == null) {
            logger.info(String.valueOf(this.hostAddress) + " -> NO OP message sent successfully");
        } else {
            logger.info(String.valueOf(this.hostAddress) + " -> NO OP message failed");
        }
    }

    private Map getCommandDictionary(PropertyList plist, String command) throws PropertyListException, AcpxCommandException {
        Map rootDict = PListUtils.toDictionary(plist.getRootElement(), String.valueOf(command) + " root dict");
        Map cmdDict = PListUtils.toDictionary(rootDict.get(command), String.valueOf(command) + " command dict");
        int err = this.getCommandStatus(rootDict);
        if (err != 0) {
            String msg = "ACP error for \"" + command + "\" command (status = " + err + ")";
            logger.error(msg);
            throw new AcpxCommandException(msg);
        }
        return cmdDict;
    }

    private int getCommandStatus(Map dictionary) throws PropertyListException {
        int status = 0;
        Object o = null;
        Object v = dictionary.get("status");
        o = v;
        if (v != null) {
            status = PListUtils.toInteger(o, "status dict").intValue();
        }
        return status;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static /* synthetic */ boolean access$6(RaidSystemAgent $0) {
        return $0.stopped;
    }

    private class DelegateHandler
    implements CommunicationHandler {
        CommunicationHandler principal;

        public DelegateHandler(CommunicationHandler principal) {
            this.principal = principal;
        }

        public void handleResponse(RaidSystem system, Response response, Object context) {
        }
    }

    private class AuthenticationException
    extends IOException {
        public AuthenticationException() {
        }

        public AuthenticationException(String s) {
            super(s);
        }
    }

    private final class 1
    extends DelegateHandler {
        public void handleResponse(RaidSystem system, Response response, Object context) {
            int result = response.getResultCode();
            try {
                if (result == 0) {
                    RaidSystemAgent.this.updateStandbyProperties((PropertyList)response.getContent());
                    RaidSystemAgent.this.completeClientRequest(this.principal);
                    return;
                }
                if (result == -16 || result == -27 || result == -28) {
                    logger.warn("Connect failed due to bad credentials (" + result + ")");
                } else if (result == -101) {
                    logger.warn("Connection failure (" + result + ")");
                    RaidSystemAgent.this.updateConnectionFailure();
                } else {
                    logger.warn("Unexpected response (" + result + ") for get-props while connecting");
                }
            }
            catch (Exception e) {
                logger.error(e);
                RaidSystemAgent.this.updateCommunicationsError();
            }
            if (this.principal != null) {
                this.principal.handleResponse(system, response, context);
            }
        }

        /* synthetic */ 1(RaidSystemAgent $0, CommunicationHandler $1) {
            super($1);
        }
    }

    private final class 2
    extends DelegateHandler {
        public void handleResponse(RaidSystem system, Response response, Object context) {
            int result = response.getResultCode();
            try {
                if (result == 0) {
                    RaidSystemAgent.this.updateStandbyProperties((PropertyList)response.getContent());
                    RaidSystemAgent.this.completeClientRequest(this.principal);
                    return;
                }
                if (result == -16 || result == -27 || result == -28) {
                    logger.warn("Authentication failed due to bad credentials (" + result + ")");
                } else if (result == -101) {
                    logger.warn("Authentication failure (" + result + ")");
                    RaidSystemAgent.this.updateConnectionFailure();
                } else {
                    logger.warn("Unexpected response (" + result + ") for get-props while authenticating");
                }
            }
            catch (Exception e) {
                logger.error(e);
                RaidSystemAgent.this.updateCommunicationsError();
            }
            if (this.principal != null) {
                this.principal.handleResponse(system, response, context);
            }
        }

        /* synthetic */ 2(RaidSystemAgent $0, CommunicationHandler $1) {
            super($1);
        }
    }

    private final class 3
    extends DelegateHandler {
        public void handleResponse(RaidSystem system, Response response, Object context) {
            int result = response.getResultCode();
            try {
                block10: {
                    try {
                        if (result == 0) {
                            RaidSystemAgent.this.updatePowerState((PropertyList)response.getContent());
                            RaidSystemAgent.this.setPollingEnabled(true);
                            if (RaidSystemAgent.this.isAlive()) break block10;
                            RaidSystemAgent raidSystemAgent = RaidSystemAgent.this;
                            synchronized (raidSystemAgent) {
                                RaidSystemAgent.this.stopped = false;
                            }
                            RaidSystemAgent.this.start();
                            break block10;
                        }
                        logger.warn("Got error response (" + result + ") for get-power-state " + "while completing connect/authenticate");
                    }
                    catch (Exception e) {
                        logger.error(e);
                    }
                }
                Object var6_7 = null;
                if (this.principal != null) {
                    this.principal.handleResponse(system, response, context);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (this.principal != null) {
                    this.principal.handleResponse(system, response, context);
                }
                throw throwable;
            }
        }

        /* synthetic */ 3(RaidSystemAgent $0, CommunicationHandler $1) {
            super($1);
        }
    }
}

