/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.RaidSet;

public class Slice
extends AbstractSystemElement
implements Comparable {
    public static final int LUN_ID_NONE = -1;
    private final int id;
    private int size = 0;
    private int lunId = -1;
    RaidSet raidSet;

    public Slice(RaidSet parent, int id) {
        this(parent, id, 0);
    }

    public Slice(RaidSet parent, int id, int size) {
        if (parent == null) {
            throw new NullPointerException("parent RAID set cannot be null");
        }
        if (id < 0 || id > 7) {
            throw new IllegalArgumentException("Illegal slice ID " + id);
        }
        this.raidSet = parent;
        this.id = id;
        this.size = size;
    }

    public Slice(Slice slice) {
        this.id = slice.id;
        this.size = slice.size;
        this.lunId = slice.lunId;
        this.raidSet = slice.raidSet;
    }

    public int getNativeId() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "Slice " + this.id;
    }

    public int getStatus() {
        return 0;
    }

    synchronized void setSize(int size) {
        if (this.size != size) {
            this.size = size;
        }
    }

    public synchronized int getSize() {
        return this.size;
    }

    synchronized void setLunId(int id) {
        if ((id < 0 || id > 7) && id != -1) {
            throw new IllegalArgumentException("Invalid LUN ID " + id);
        }
        if (this.lunId != id) {
            this.lunId = id;
        }
    }

    public synchronized int getLunId() {
        return this.lunId;
    }

    public synchronized boolean isMapped() {
        return this.lunId != -1;
    }

    public RaidSet getRaidSet() {
        return this.raidSet;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Slice)) {
            return false;
        }
        Slice slice = (Slice)o;
        return slice.id == this.id && slice.raidSet == this.raidSet;
    }

    public int hashCode() {
        int result = 13;
        result = 37 * result + this.id;
        result = 37 * result + (this.raidSet != null ? this.raidSet.hashCode() : 0);
        return result;
    }

    public int compareTo(Object o) {
        Slice slice = (Slice)o;
        return this.id - slice.id;
    }

    public synchronized String toString() {
        String s = String.valueOf(this.getClass().getName()) + "[";
        s = String.valueOf(s) + "id=" + this.id + ",";
        s = String.valueOf(s) + "size=" + this.size + ",";
        s = String.valueOf(s) + "lunId=" + this.lunId;
        s = String.valueOf(s) + "]";
        return s;
    }
}

