/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.EmailNotifications;
import com.apple.xsr.net.IPAddress;
import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.NetworkInterface;
import com.apple.xsr.som.RaidSystem;
import java.net.UnknownHostException;

public class SystemController
extends AbstractSystemElement
implements Comparable {
    public static final int AUDIBLE_ALARM_DISABLED = 0;
    public static final int AUDIBLE_ALARM_ENABLED = 1;
    public static final int AUTO_REBOOT_DISABLED = 0;
    public static final int AUTO_REBOOT_ENABLED = 1;
    public static final int SNMP_DISABLED = 0;
    public static final int SNMP_ENABLED = 1;
    public static final String DISABLE_NTP_SERVER = ".";
    private int id;
    private String systemName = "";
    private String systemDnsName = "";
    private String systemPresentationName = "";
    private String systemContact = "";
    private String systemDescription = "";
    private String systemLocation = "";
    private String systemVersion = "";
    private String rendezvousName = "";
    private int uptime = -1;
    private int autoRebootState = -1;
    private int audibleAlarmState = 1;
    private int snmpState = -1;
    private IPAddress smtpServer;
    private String ntpServer;
    private int ambientTemp = -1;
    private int tempStatus = -1;
    private NetworkInterface networkInterface;
    RaidSystem system;
    private EmailNotifications notificationsData;

    public SystemController(int id, RaidSystem system) {
        this.id = id;
        this.system = system;
        this.networkInterface = new NetworkInterface(1, this);
    }

    public SystemController(SystemController systemController) {
        this.id = systemController.id;
        this.systemName = systemController.systemName;
        this.systemDnsName = systemController.systemDnsName;
        this.systemPresentationName = systemController.systemPresentationName;
        this.systemContact = systemController.systemContact;
        this.systemDescription = systemController.systemDescription;
        this.systemLocation = systemController.systemLocation;
        this.systemVersion = systemController.systemVersion;
        this.rendezvousName = systemController.rendezvousName;
        this.uptime = systemController.uptime;
        this.autoRebootState = systemController.autoRebootState;
        this.audibleAlarmState = systemController.audibleAlarmState;
        this.snmpState = systemController.snmpState;
        this.smtpServer = systemController.smtpServer;
        this.ntpServer = systemController.ntpServer;
        this.ambientTemp = systemController.ambientTemp;
        this.tempStatus = systemController.tempStatus;
        this.networkInterface = new NetworkInterface(systemController.networkInterface);
        this.notificationsData = systemController.notificationsData;
        this.system = systemController.system;
    }

    public int getNativeId() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "System Controller " + this.id;
    }

    public int getStatus() {
        int status = this.tempStatus;
        return status;
    }

    void setSystemName(String name) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.systemName = name;
    }

    public String getSystemName() {
        return this.systemName;
    }

    void setSystemDnsName(String name) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.systemDnsName = name;
    }

    public String getSystemDnsName() {
        return this.systemDnsName;
    }

    void setSystemPresentationName(String name) {
        if (name == null) {
            throw new NullPointerException("presentation name cannot be null");
        }
        this.systemPresentationName = name;
        this.system.setName(name);
    }

    public String getSystemPresentationName() {
        return this.systemPresentationName;
    }

    void setSystemContact(String contact) {
        this.systemContact = contact;
        this.system.setContact(contact);
    }

    public String getSystemContact() {
        return this.systemContact;
    }

    void setSystemDescription(String description) {
        this.systemDescription = description;
        this.system.setDescription(description);
    }

    public String getSystemDescription() {
        return this.systemDescription;
    }

    void setSystemLocation(String location) {
        this.systemLocation = location;
        this.system.setLocation(location);
    }

    public String getSystemLocation() {
        return this.systemLocation;
    }

    void setSystemVersion(String version) {
        this.systemVersion = version;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    void setRendezvousName(String name) {
        this.rendezvousName = name;
    }

    public String getRendezvousName() {
        return this.rendezvousName;
    }

    void setUpTime(int uptime) {
        this.uptime = uptime;
    }

    public int getUpTime() {
        return this.uptime;
    }

    void setAutoRebootState(int state) {
        this.autoRebootState = state;
        this.system.setAutoRebootState(state);
    }

    public int getAutoRebootState() {
        return this.autoRebootState;
    }

    void setTemperatureStatus(int status) {
        this.tempStatus = status;
    }

    void setAmbientTemperature(int ambientTemp) {
        this.ambientTemp = ambientTemp;
    }

    public int getAmbientTemperature() {
        return this.ambientTemp;
    }

    void setAudibleAlarmState(int state) {
        this.audibleAlarmState = state;
        this.system.setAudibleAlarmState(state);
    }

    public int getAudibleAlarmState() {
        return this.audibleAlarmState;
    }

    void setSnmpState(int state) {
        if (this.snmpState != state) {
            this.snmpState = state;
        }
    }

    public int getSnmpState() {
        return this.snmpState;
    }

    void setSmtpServerAddress(String address) throws UnknownHostException {
        this.smtpServer = new IPAddress(address);
    }

    public IPAddress getSmtpServerAddress() {
        return this.smtpServer;
    }

    void setNtpServerAddress(String address) throws NullPointerException {
        if (address == null) {
            throw new NullPointerException("ntp server address must be non-null");
        }
        this.ntpServer = address;
    }

    public String getNtpServerAddress() {
        return this.ntpServer;
    }

    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    public void setEmailNotificationsData(EmailNotifications data) {
        this.notificationsData = data;
    }

    public EmailNotifications getEmailNotificationsData() {
        return this.notificationsData;
    }

    public int compareTo(Object o) {
        SystemController controller = (SystemController)o;
        return this.id - controller.id;
    }

    public String paramString() {
        String s = "";
        s = String.valueOf(s) + "id=" + this.id + ",";
        s = String.valueOf(s) + "systemName=" + this.systemName + ",";
        s = String.valueOf(s) + "systemDnsName=" + this.systemDnsName + ",";
        s = String.valueOf(s) + "systemPresentationName=" + this.systemPresentationName + ",";
        s = String.valueOf(s) + "systemContact=" + this.systemContact + ",";
        s = String.valueOf(s) + "systemDescription=" + this.systemDescription + ",";
        s = String.valueOf(s) + "systemLocation=" + this.systemLocation + ",";
        s = String.valueOf(s) + "systemVersion=" + this.systemVersion + ",";
        s = String.valueOf(s) + "rendezvousName=" + this.rendezvousName + ",";
        s = String.valueOf(s) + "uptime=" + this.uptime + ",";
        s = String.valueOf(s) + "autoRebootState=" + this.autoRebootState + ",";
        s = String.valueOf(s) + "tempStatus=" + this.tempStatus + ",";
        s = String.valueOf(s) + "ambientTemp=" + this.ambientTemp + ",";
        s = String.valueOf(s) + "audibleAlarmState=" + this.audibleAlarmState + ",";
        s = String.valueOf(s) + "snmpState=" + this.snmpState + ",";
        s = String.valueOf(s) + "smtpServer=" + this.smtpServer + ",";
        s = String.valueOf(s) + "ntpServer=" + this.ntpServer;
        return s;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }
}

