/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.update;

import com.apple.mrj.MRJFileUtils;
import com.apple.net.acp.AcpPropertyCode;
import com.apple.util.Gestalt;
import com.apple.util.VersionNumber;
import com.apple.util.plist.PListUtils;
import com.apple.util.plist.PropertyList;
import com.apple.util.plist.PropertyListException;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertAdapter;
import com.apple.xsr.RaidAdmin;
import com.apple.xsr.Resources;
import com.apple.xsr.net.AcpxCommandException;
import com.apple.xsr.net.AcpxConstants;
import com.apple.xsr.net.MessageFactory;
import com.apple.xsr.net.RequestMessage;
import com.apple.xsr.net.Response;
import com.apple.xsr.net.UpdateFirmwareRequest;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.update.FirmwareBundleConnection;
import com.apple.xsr.update.FirmwareUpdatePane;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FirmwareUpdater
implements ActionListener {
    private RaidSystem system;
    private String password;
    private String bundlePath;
    private JFrame root;
    private FirmwareUpdatePane updatePane;
    private AquaAlert dialog;
    private VersionNumber currentCpTop;
    private VersionNumber currentCpBottom;
    private VersionNumber currentRcTop;
    private VersionNumber currentRcBottom;
    private VersionNumber newCoprocessorUpdateVersion;
    private String newCoprocessorUpdateVersionString = "?";
    private String newCoprocessorUpdateDate;
    private VersionNumber newRaidControllerUpdateVersion;
    private String newRaidControllerUpdateVersionString = "?";
    private String newRaidControllerUpdateDate;
    private boolean[] diskCacheSettingsTop;
    private boolean[] diskCacheSettingsBottom;
    private boolean controllerCacheEnabledTop;
    private boolean controllerCacheEnabledBottom;
    private boolean restoreCacheError = false;
    private Thread updateThread;
    private static final Attributes.Name RAID_CONTROLLER_UPDATE_IMAGE = new Attributes.Name("xserveraid-raid-controller-update-image");
    private static final Attributes.Name COPROCESSOR_FULL_IMAGE = new Attributes.Name("xserveraid-coprocessor-full-image");
    private static final Attributes.Name COPROCESSOR_UPDATE_IMAGE = new Attributes.Name("xserveraid-coprocessor-update-image");
    private static final String FIRMWARE_VERSION = "firmware-version";
    private static final String FIRMWARE_DATE = "firmware-date";
    private static final int IO_ERR = -102;
    private static final int RESPONSE_FORMAT_ERR = -103;
    private static final String EXTENSION = Resources.getString("fwUpdate.bundleExtension");
    private static final int RESTART_DELAY = 40;
    private static final int RC_FLASH_DELAY = 60;
    private static final String MIN_ATLAS_VERSION_FOR_RC_VERSION_PROPERTY = "1.2.0";
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$update$FirmwareUpdater != null ? class$com$apple$xsr$update$FirmwareUpdater : (class$com$apple$xsr$update$FirmwareUpdater = FirmwareUpdater.class$("com.apple.xsr.update.FirmwareUpdater")));
    static /* synthetic */ Class class$com$apple$xsr$update$FirmwareUpdater;

    public FirmwareUpdater(Component parent, RaidSystem system, String pass) {
        if (system == null) {
            throw new NullPointerException("system cannot be null");
        }
        this.system = system;
        Component c = SwingUtilities.getRoot(parent);
        if (c == null || !(c instanceof JFrame)) {
            throw new NullPointerException("Root frame for " + parent.getName() + " not a JFrame");
        }
        this.root = (JFrame)c;
        this.password = pass;
        this.diskCacheSettingsTop = new boolean[7];
        int i = 0;
        while (i < this.diskCacheSettingsTop.length) {
            this.diskCacheSettingsTop[i] = false;
            ++i;
        }
        this.diskCacheSettingsBottom = new boolean[7];
        int i2 = 0;
        while (i2 < this.diskCacheSettingsBottom.length) {
            this.diskCacheSettingsBottom[i2] = false;
            ++i2;
        }
        this.updatePane = new FirmwareUpdatePane(this.system.getName());
        this.bundlePath = this.getBundlePath();
        logger.info("Bundle path = \"" + this.bundlePath + "\"");
        if (this.bundlePath != null) {
            try {
                this.initUpdatePane();
                this.dialog = new AquaAlert(this.updatePane, null, null, null);
                this.dialog.addAquaAlertListener(new UpdateSheetListener());
                this.dialog.showSheet(this.root);
            }
            catch (Exception e) {
                logger.error(e);
            }
        } else {
            logger.info("User cancelled the Open Bundle file dialog");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ACTION_CMD_UPDATE")) {
            this.root.getRootPane().setDefaultButton(null);
            this.updatePane.setMode("UPDATE");
            this.dialog.resizeVertically();
        } else if (e.getActionCommand().equals("ACTION_CMD_CANCEL") || e.getActionCommand().equals("ACTION_CMD_OK")) {
            this.dialog.dismissSheetOrDialog(1);
        }
    }

    private synchronized void startUpdate() {
        if (this.updateThread == null) {
            this.system.setPollingEnabled(false);
            this.updateThread = new UpdateThread();
            this.updateThread.start();
        } else {
            logger.error("Error! Attempt to call startUpdate after an update has already begun.");
        }
    }

    private void updateComplete(int result, String message) {
        this.updatePane.setMode("COMPLETE");
        this.updatePane.setStatusMessage(message);
        this.root.getRootPane().setDefaultButton(this.updatePane.getDefaultButton());
        if (result == 0) {
            String cp = this.newCoprocessorUpdateVersionString;
            String rc = this.newRaidControllerUpdateVersionString;
            this.updatePane.setCurrentCoprocessorVersions(cp, cp);
            this.updatePane.setCurrentRaidControllerVersions(rc, rc);
            this.updatePane.setCoprocessorNeedsUpdate(false);
            this.updatePane.setRaidControllerNeedsUpdate(false);
        }
        if (this.restoreCacheError) {
            this.updatePane.setErrorMessage(Resources.getString("fwUpdate.statusMessage.restoreCache.failure"));
        }
        this.dialog.resizeVertically();
    }

    private String getBundlePath() {
        String path;
        FileDialog dialog;
        block4: {
            dialog = null;
            path = null;
            try {
                dialog = this.createFileDialog();
                dialog.show();
                if (dialog.getDirectory() == null || dialog.getFile() == null) break block4;
                path = String.valueOf(dialog.getDirectory()) + dialog.getFile();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (dialog != null) {
                    dialog.dispose();
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (dialog != null) {
            dialog.dispose();
        }
        return path;
    }

    private FileDialog createFileDialog() {
        String title = Resources.getString("fwUpdate.chooseBundleLabel");
        String startDir = null;
        if (Gestalt.isMacOS()) {
            try {
                startDir = MRJFileUtils.findFolder(MRJFileUtils.kDesktopFolderType).getPath();
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        1 filter = new 1();
        FileDialog dialog = new FileDialog((Frame)this.root, title, 0);
        if (RaidAdmin.lastFirmwareFilePath != null) {
            dialog.setDirectory(RaidAdmin.lastFirmwareFilePath);
        } else if (startDir != null) {
            dialog.setDirectory(startDir);
        }
        dialog.setFilenameFilter(filter);
        return dialog;
    }

    private void initUpdatePane() throws Exception {
        boolean cpNeedsUpdate;
        Attributes attribs;
        try {
            this.currentCpTop = VersionNumber.newAppleVersionNumber(this.system.getSystemController(1).getSystemVersion());
        }
        catch (ParseException parseException) {
            logger.warn("Unable to parse top coprocessor version \"" + this.system.getSystemController(1).getSystemVersion() + "\"");
            this.currentCpTop = null;
        }
        try {
            this.currentCpBottom = VersionNumber.newAppleVersionNumber(this.system.getSystemController(2).getSystemVersion());
        }
        catch (ParseException parseException) {
            logger.warn("Unable to parse bottom coprocessor version \"" + this.system.getSystemController(2).getSystemVersion() + "\"");
            this.currentCpBottom = null;
        }
        try {
            this.currentRcTop = VersionNumber.newAcsVersionNumber(this.system.getRaidController(1).getFirmwareVersion());
        }
        catch (ParseException parseException) {
            logger.warn("Unable to parse top RAID controller version \"" + this.system.getRaidController(1).getFirmwareVersion() + "\"");
            this.currentRcTop = null;
        }
        try {
            this.currentRcBottom = VersionNumber.newAcsVersionNumber(this.system.getRaidController(2).getFirmwareVersion());
        }
        catch (ParseException parseException) {
            logger.warn("Unable to parse bottom RAID controller version \"" + this.system.getRaidController(2).getFirmwareVersion() + "\"");
            this.currentRcBottom = null;
        }
        FirmwareBundleConnection connection = new FirmwareBundleConnection("jar:file:" + this.bundlePath + "!/");
        Manifest mf = connection.getManifest();
        Attributes mainAttribs = mf.getMainAttributes();
        String controllerUpdateEntry = null;
        String coprocessorFullEntry = null;
        String coprocessorUpdateEntry = null;
        if (mainAttribs.containsKey(COPROCESSOR_FULL_IMAGE)) {
            coprocessorFullEntry = mainAttribs.getValue(COPROCESSOR_FULL_IMAGE);
        }
        if (mainAttribs.containsKey(COPROCESSOR_UPDATE_IMAGE)) {
            coprocessorUpdateEntry = mainAttribs.getValue(COPROCESSOR_UPDATE_IMAGE);
        }
        if (mainAttribs.containsKey(RAID_CONTROLLER_UPDATE_IMAGE)) {
            controllerUpdateEntry = mainAttribs.getValue(RAID_CONTROLLER_UPDATE_IMAGE);
        }
        if (coprocessorUpdateEntry != null) {
            attribs = mf.getAttributes(coprocessorUpdateEntry);
            this.newCoprocessorUpdateVersionString = attribs.getValue(FIRMWARE_VERSION);
            try {
                this.newCoprocessorUpdateVersion = VersionNumber.newAppleVersionNumber(attribs.getValue(FIRMWARE_VERSION));
                logger.info("Coprocessor Update     -- Version: " + this.newCoprocessorUpdateVersion);
            }
            catch (ParseException e) {
                logger.warn("Coprocessor Update     -- Version: " + e);
            }
            this.newCoprocessorUpdateDate = attribs.getValue(FIRMWARE_DATE);
            logger.info("Coprocessor Update     -- Date: " + this.newCoprocessorUpdateDate);
        } else {
            logger.info("Coprocessor Update     -- Not found!");
        }
        if (controllerUpdateEntry != null) {
            attribs = mf.getAttributes(controllerUpdateEntry);
            this.newRaidControllerUpdateVersionString = attribs.getValue(FIRMWARE_VERSION);
            try {
                this.newRaidControllerUpdateVersion = VersionNumber.newAcsVersionNumber(attribs.getValue(FIRMWARE_VERSION));
                logger.info("RAID Controller Update -- Version: " + this.newRaidControllerUpdateVersion);
            }
            catch (ParseException e) {
                logger.warn("RAID Controller Update -- Version: " + e);
            }
            this.newRaidControllerUpdateDate = attribs.getValue(FIRMWARE_DATE);
            logger.info("RAID Controller Update -- Date: " + this.newRaidControllerUpdateDate);
        } else {
            logger.info("RAID Controller Update -- Not found!");
        }
        this.updatePane.setCurrentCoprocessorVersions(this.currentCpTop, this.currentCpBottom);
        this.updatePane.setCurrentRaidControllerVersions(this.currentRcTop, this.currentRcBottom);
        if (this.currentCpTop == null || this.currentCpBottom == null || this.newCoprocessorUpdateVersion == null) {
            cpNeedsUpdate = true;
        } else {
            boolean bl = cpNeedsUpdate = this.currentCpTop.compareTo(this.newCoprocessorUpdateVersion) < 0;
        }
        boolean rcNeedsUpdate = this.currentRcTop == null || this.currentRcBottom == null || this.newRaidControllerUpdateVersion == null ? true : this.currentRcTop.compareTo(this.newRaidControllerUpdateVersion) < 0;
        this.updatePane.setCoprocessorNeedsUpdate(cpNeedsUpdate);
        this.updatePane.setRaidControllerNeedsUpdate(rcNeedsUpdate);
        this.updatePane.setNewCoprocessorVersion(this.newCoprocessorUpdateVersionString);
        this.updatePane.setNewRaidControllerVersion(this.newRaidControllerUpdateVersionString);
        this.updatePane.addActionListener(this);
    }

    private int updateRaidController(RequestMessage.Target target) throws IOException, PropertyListException {
        int controller = 1;
        int type = 1;
        FirmwareBundleConnection fb = new FirmwareBundleConnection("jar:file:" + this.bundlePath + "!/raid-controller/updateROM.bin");
        UpdateFirmwareRequest request = new UpdateFirmwareRequest(target, controller, type, fb.getInputStream());
        request.setUser(this.system.getManagementUserId());
        request.setPassword(this.password);
        try {
            VersionNumber currentVersion = target == RequestMessage.TARGET_TOP ? this.currentRcTop : this.currentRcBottom;
            VersionNumber minSupportedVersion = VersionNumber.newAppleVersionNumber(MIN_ATLAS_VERSION_FOR_RC_VERSION_PROPERTY);
            if (currentVersion != null && currentVersion.compareTo(minSupportedVersion) >= 0) {
                request.setRequestProperty("X-Apple-RAID-Firmware-Version", this.newRaidControllerUpdateVersionString);
            }
        }
        catch (ParseException e) {
            logger.error("Error attempting to add RAID firmware version property to request: " + e);
        }
        logger.info("Sending firmware update to " + (target == RequestMessage.TARGET_TOP ? "top" : "bottom") + " RAID controller...");
        Response response = this.system.postMessage(request);
        PropertyList plist = (PropertyList)response.getContent();
        logger.info("Firmware update sent.");
        logger.info("Response:\n" + plist.toString());
        Map root = PListUtils.toDictionary(plist.getRootElement());
        int status = PListUtils.toInteger(root.get("status"), "status").intValue();
        return status;
    }

    private int updateCoprocessor(RequestMessage.Target target) throws IOException, PropertyListException {
        int controller = 0;
        int type = 1;
        FirmwareBundleConnection fb = new FirmwareBundleConnection("jar:file:" + this.bundlePath + "!/coprocessor/updateROM.bin");
        UpdateFirmwareRequest request = new UpdateFirmwareRequest(target, controller, type, fb.getInputStream());
        request.setUser(this.system.getManagementUserId());
        request.setPassword(this.password);
        logger.info("Sending firmware update to " + (target == RequestMessage.TARGET_TOP ? "top" : "bottom") + " coprocessor...");
        Response response = this.system.postMessage(request);
        PropertyList plist = (PropertyList)response.getContent();
        logger.info("Firmware update sent.");
        logger.info("Response:\n" + plist.toString());
        Map root = PListUtils.toDictionary(plist.getRootElement());
        int status = PListUtils.toInteger(root.get("status"), "status").intValue();
        return status;
    }

    private void disableDiskCaches(int controllerId) throws Exception {
        boolean[] cacheSettings = this.system.getDiskCacheSettings(controllerId);
        int errors = 0;
        int i = 0;
        while (i < cacheSettings.length) {
            if (cacheSettings[i]) {
                RequestMessage request = this.system.getMessageFactory().newSetDriveCacheControlRequest(i + 1, false);
                request.setUser(this.system.getManagementUserId());
                request.setPassword(this.password);
                Response response = this.system.postMessage(request, controllerId);
                if (response.getResultCode() != 0) {
                    logger.error("\"/raid/drive/cache-control\" request failed (" + response.getResultCode() + ")");
                    ++errors;
                }
            }
            ++i;
        }
        if (controllerId == 1) {
            this.diskCacheSettingsTop = cacheSettings;
        } else {
            this.diskCacheSettingsBottom = cacheSettings;
        }
        if (errors != 0) {
            throw new AcpxCommandException(String.valueOf(errors) + " \"/raid/drive/cache-control\" request(s) failed");
        }
    }

    private void reenableDiskCaches(int controllerId) throws Exception {
        boolean[] cacheSettings = controllerId == 1 ? this.diskCacheSettingsTop : this.diskCacheSettingsBottom;
        int errors = 0;
        int i = 0;
        while (i < cacheSettings.length) {
            if (cacheSettings[i]) {
                RequestMessage request = this.system.getMessageFactory().newSetDriveCacheControlRequest(i + 1, true);
                request.setUser(this.system.getManagementUserId());
                request.setPassword(this.password);
                Response response = this.system.postMessage(request, controllerId);
                if (response.getResultCode() != 0) {
                    logger.error("\"/raid/drive/cache-control\" request failed (" + response.getResultCode() + ")");
                    ++errors;
                }
            }
            ++i;
        }
        if (errors != 0) {
            throw new AcpxCommandException(String.valueOf(errors) + " \"/raid/drive/cache-control\" request(s) failed");
        }
    }

    private void disableControllerCache(int controllerId) throws Exception {
        boolean cacheEnabled = this.system.getRaidControllerCacheEnabled(controllerId);
        if (cacheEnabled) {
            RequestMessage request = this.system.getMessageFactory().newSetRAIDCacheControlRequest(false);
            request.setUser(this.system.getManagementUserId());
            request.setPassword(this.password);
            Response response = this.system.postMessage(request, controllerId);
            if (response.getResultCode() != 0) {
                logger.error("/raid/cache-control\" request failed (" + response.getResultCode() + ")");
                throw new AcpxCommandException("get-page request failed (" + response.getResultCode() + ")");
            }
        }
        if (controllerId == 1) {
            this.controllerCacheEnabledTop = cacheEnabled;
        } else {
            this.controllerCacheEnabledBottom = cacheEnabled;
        }
    }

    private void reenableControllerCache(int controllerId) throws Exception {
        boolean cacheEnabled;
        boolean bl = cacheEnabled = controllerId == 1 ? this.controllerCacheEnabledTop : this.controllerCacheEnabledBottom;
        if (cacheEnabled) {
            RequestMessage request = this.system.getMessageFactory().newSetRAIDCacheControlRequest(true);
            request.setUser(this.system.getManagementUserId());
            request.setPassword(this.password);
            Response response = this.system.postMessage(request, controllerId);
            if (response.getResultCode() != 0) {
                logger.error("/raid/cache-control\" request failed (" + response.getResultCode() + ")");
                throw new AcpxCommandException("get-page request failed (" + response.getResultCode() + ")");
            }
        }
    }

    private void debugCurrentVersions() {
        Map dict;
        Map root;
        PropertyList plist;
        Response response;
        String atlasTop = "";
        String atlasBottom = "";
        String controllerTop = "";
        String controllerBottom = "";
        MessageFactory mf = this.system.getMessageFactory();
        RequestMessage request = mf.newGetPropertyRequest(AcpPropertyCode.SYS_VERSION);
        try {
            response = this.system.postMessage(request, 1);
            plist = (PropertyList)response.getContent();
            root = PListUtils.toDictionary(plist.getRootElement());
            dict = PListUtils.toDictionary(root.get("syVs"));
            atlasTop = PListUtils.toString(dict.get("data"));
        }
        catch (IOException iOException) {
        }
        catch (PropertyListException propertyListException) {}
        try {
            response = this.system.postMessage(request, 2);
            plist = (PropertyList)response.getContent();
            root = PListUtils.toDictionary(plist.getRootElement());
            dict = PListUtils.toDictionary(root.get("syVs"));
            atlasBottom = PListUtils.toString(dict.get("data"));
        }
        catch (IOException iOException) {
        }
        catch (PropertyListException propertyListException) {}
        request = mf.newGetControllerPageRequest(AcpxConstants.CONTROLLER_PAGE_0);
        try {
            response = this.system.postMessage(request, 1);
            plist = (PropertyList)response.getContent();
            root = PListUtils.toDictionary(plist.getRootElement());
            dict = PListUtils.toDictionary(root.get("get-page"));
            controllerTop = PListUtils.toString(dict.get(FIRMWARE_VERSION));
        }
        catch (IOException iOException) {
        }
        catch (PropertyListException propertyListException) {}
        try {
            response = this.system.postMessage(request, 2);
            plist = (PropertyList)response.getContent();
            root = PListUtils.toDictionary(plist.getRootElement());
            dict = PListUtils.toDictionary(root.get("get-page"));
            controllerBottom = PListUtils.toString(dict.get(FIRMWARE_VERSION));
        }
        catch (IOException iOException) {
        }
        catch (PropertyListException propertyListException) {}
        logger.info("Atlas Top: " + atlasTop);
        logger.info("Atlas Bottom: " + atlasBottom);
        logger.info("RAID Controller Top: " + controllerTop);
        logger.info("RAID Controller Bottom: " + controllerBottom);
    }

    private void dumpManifest(Manifest mf) {
        Set<Map.Entry<Object, Object>> mainAttribs = mf.getMainAttributes().entrySet();
        Iterator<Map.Entry<Object, Object>> iter = mainAttribs.iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            System.out.println("Key: " + entry.getKey());
            System.out.println("Attribute: " + entry.getValue());
        }
        System.out.println();
        Set<Map.Entry<String, Attributes>> entries = mf.getEntries().entrySet();
        Iterator<Map.Entry<String, Attributes>> iter2 = entries.iterator();
        while (iter2.hasNext()) {
            Map.Entry<String, Attributes> entry = iter2.next();
            System.out.println("Key: " + entry.getKey());
            System.out.println("Attributes:");
            Set<Map.Entry<Object, Object>> attributes = entry.getValue().entrySet();
            Iterator<Map.Entry<Object, Object>> attribsIter = attributes.iterator();
            while (attribsIter.hasNext()) {
                Map.Entry<Object, Object> attrib = attribsIter.next();
                System.out.println("Attrib Key: " + attrib.getKey());
                System.out.println("Attrib Value: " + attrib.getValue());
            }
            System.out.println();
        }
    }

    private void debugVersionsForManifest(Manifest mf) {
        Attributes atlasAttribs = mf.getAttributes("coprocessor/updateROM.bin");
        String atlasVersion = atlasAttribs.getValue(FIRMWARE_VERSION);
        String atlasDate = atlasAttribs.getValue(FIRMWARE_DATE);
        Attributes rcAttribs = mf.getAttributes("raid-controller/updateROM.bin");
        String rcVersion = rcAttribs.getValue(FIRMWARE_VERSION);
        String rcDate = rcAttribs.getValue(FIRMWARE_DATE);
        System.out.println("Atlas (Coprocessor) Update Version: " + atlasVersion);
        System.out.println("Atlas (Coprocessor) Date: " + atlasDate);
        System.out.println("RAID Controller Version: " + rcVersion);
        System.out.println("RAID Controller Date: " + rcDate);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static /* synthetic */ boolean access$15(FirmwareUpdater $0) {
        return $0.restoreCacheError;
    }

    private final class 1
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(EXTENSION);
        }

        /* synthetic */ 1() {
        }
    }

    private class UpdateSheetListener
    extends AquaAlertAdapter {
        public void aquaAlertSheetVisible(Object context) {
            FirmwareUpdater.this.root.getRootPane().setDefaultButton(FirmwareUpdater.this.updatePane.getDefaultButton());
        }

        public void aquaAlertResized(Object context) {
            if (FirmwareUpdater.this.updatePane.getMode() == "UPDATE") {
                FirmwareUpdater.this.startUpdate();
            }
        }

        UpdateSheetListener() {
        }
    }

    private class UpdateThread
    extends Thread {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block48: {
                block47: {
                    block46: {
                        block45: {
                            boolean updateAll = FirmwareUpdater.this.updatePane.isUpdateAllSelected();
                            try {
                                try {
                                    Response restartResponse;
                                    VersionNumber secondaryVersion;
                                    String secondaryString;
                                    RequestMessage.Target secondaryTarget;
                                    VersionNumber primaryVersion;
                                    String primaryString;
                                    RequestMessage.Target primaryTarget;
                                    int result;
                                    if (updateAll || FirmwareUpdater.this.newRaidControllerUpdateVersion == null || FirmwareUpdater.this.currentRcTop == null || FirmwareUpdater.this.currentRcBottom == null || FirmwareUpdater.this.currentRcTop.compareTo(FirmwareUpdater.this.newRaidControllerUpdateVersion) != 0) {
                                        FirmwareUpdater.this.updatePane.setStatusMessage(Resources.getStringWithReplacement("fwUpdate.statusMessage.updatingRaidControllers", new Object[]{"version", FirmwareUpdater.this.newRaidControllerUpdateVersionString}));
                                        try {
                                            logger.info("Disabling top disk caches");
                                            FirmwareUpdater.this.disableDiskCaches(1);
                                        }
                                        catch (Exception exception) {}
                                        try {
                                            logger.info("Disabling top controller cache");
                                            FirmwareUpdater.this.disableControllerCache(1);
                                        }
                                        catch (Exception exception) {}
                                        FirmwareUpdater.this.updatePane.setStatusMessage(Resources.getStringWithReplacement("fwUpdate.statusMessage.updatingRaidController", new Object[]{"location", Resources.getString("fwUpdate.topLocation"), "version", FirmwareUpdater.this.newRaidControllerUpdateVersionString}));
                                        result = FirmwareUpdater.this.updateRaidController(RequestMessage.TARGET_TOP);
                                        if (result != 0) {
                                            FirmwareUpdater.this.updateComplete(result, Resources.getStringWithReplacement("fwUpdate.statusMessage.errorUpdatingRaidController", new Object[]{"location", Resources.getString("fwUpdate.topLocation"), "status", String.valueOf(result)}));
                                            logger.error("Error flashing top RAID controller: " + result);
                                            Object var4_3 = null;
                                            FirmwareUpdater.this.system.clear();
                                            FirmwareUpdater.this.system.authenticate(null, FirmwareUpdater.this.system.getMonitoringUserId(), FirmwareUpdater.this.system.getMonitoringPassword(), false);
                                            FirmwareUpdater.this.system.setPollingEnabled(true);
                                            return;
                                        }
                                        try {
                                            logger.info("Waiting 60 secs for top RAID controller to restart...");
                                            Thread.sleep(70000L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                        try {
                                            logger.info("Polling for top RAID controller online...");
                                            FirmwareUpdater.this.system.pollForRaidControllerOnline(1);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                        try {
                                            logger.info("Re-enabling top disk caches");
                                            FirmwareUpdater.this.reenableDiskCaches(1);
                                        }
                                        catch (Exception exception) {
                                            FirmwareUpdater.this.restoreCacheError = true;
                                        }
                                        try {
                                            logger.info("Re-enabling top controller cache");
                                            FirmwareUpdater.this.reenableControllerCache(1);
                                        }
                                        catch (Exception exception) {
                                            FirmwareUpdater.this.restoreCacheError = true;
                                        }
                                    }
                                    if (updateAll || FirmwareUpdater.this.currentRcTop == null || FirmwareUpdater.this.currentRcBottom == null || FirmwareUpdater.this.newRaidControllerUpdateVersion == null || FirmwareUpdater.this.currentRcBottom.compareTo(FirmwareUpdater.this.newRaidControllerUpdateVersion) != 0) {
                                        try {
                                            logger.info("Disabling bottom disk caches");
                                            FirmwareUpdater.this.disableDiskCaches(2);
                                        }
                                        catch (Exception exception) {}
                                        try {
                                            logger.info("Disabling bottom controller cache");
                                            FirmwareUpdater.this.disableControllerCache(2);
                                        }
                                        catch (Exception exception) {}
                                        FirmwareUpdater.this.updatePane.setStatusMessage(Resources.getStringWithReplacement("fwUpdate.statusMessage.updatingRaidController", new Object[]{"location", Resources.getString("fwUpdate.bottomLocation"), "version", FirmwareUpdater.this.newRaidControllerUpdateVersionString}));
                                        result = FirmwareUpdater.this.updateRaidController(RequestMessage.TARGET_BOTTOM);
                                        if (result != 0) {
                                            FirmwareUpdater.this.updateComplete(result, Resources.getStringWithReplacement("fwUpdate.statusMessage.errorUpdatingRaidController", new Object[]{"location", Resources.getString("fwUpdate.bottomLocation"), "status", String.valueOf(result)}));
                                            logger.error("Error flashing bottom RAID controller: " + result);
                                            break block45;
                                        }
                                        try {
                                            logger.info("Waiting 60 secs for bottom RAID controller to restart...");
                                            Thread.sleep(60000L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                        try {
                                            logger.info("Polling for bottom RAID controller online...");
                                            FirmwareUpdater.this.system.pollForRaidControllerOnline(2);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                        try {
                                            logger.info("Re-enabling bottom disk caches");
                                            FirmwareUpdater.this.reenableDiskCaches(2);
                                        }
                                        catch (Exception exception) {
                                            FirmwareUpdater.this.restoreCacheError = true;
                                        }
                                        try {
                                            logger.info("Re-enabling bottom controller cache");
                                            FirmwareUpdater.this.reenableControllerCache(2);
                                        }
                                        catch (Exception exception) {
                                            FirmwareUpdater.this.restoreCacheError = true;
                                        }
                                    }
                                    if (FirmwareUpdater.this.system.getPrimarySystemController().getId() == 1) {
                                        primaryTarget = RequestMessage.TARGET_TOP;
                                        primaryString = Resources.getString("fwUpdate.topLocation");
                                        primaryVersion = FirmwareUpdater.this.currentCpTop;
                                        secondaryTarget = RequestMessage.TARGET_BOTTOM;
                                        secondaryString = Resources.getString("fwUpdate.bottomLocation");
                                        secondaryVersion = FirmwareUpdater.this.currentCpBottom;
                                    } else {
                                        primaryTarget = RequestMessage.TARGET_BOTTOM;
                                        primaryString = Resources.getString("fwUpdate.bottomLocation");
                                        primaryVersion = FirmwareUpdater.this.currentCpBottom;
                                        secondaryTarget = RequestMessage.TARGET_TOP;
                                        secondaryString = Resources.getString("fwUpdate.topLocation");
                                        secondaryVersion = FirmwareUpdater.this.currentCpTop;
                                    }
                                    if (updateAll || primaryVersion == null || secondaryVersion == null || FirmwareUpdater.this.newCoprocessorUpdateVersion == null || secondaryVersion.compareTo(FirmwareUpdater.this.newCoprocessorUpdateVersion) != 0) {
                                        FirmwareUpdater.this.updatePane.setStatusMessage(Resources.getStringWithReplacement("fwUpdate.statusMessage.updatingCoprocessor", new Object[]{"location", secondaryString, "version", FirmwareUpdater.this.newCoprocessorUpdateVersionString}));
                                        result = FirmwareUpdater.this.updateCoprocessor(secondaryTarget);
                                        if (result != 0) {
                                            FirmwareUpdater.this.updateComplete(result, Resources.getStringWithReplacement("fwUpdate.statusMessage.errorUpdatingCoprocessor", new Object[]{"location", secondaryString, "status", String.valueOf(result)}));
                                            logger.error("Error flashing " + secondaryString + " coprocessor: " + result);
                                            break block46;
                                        }
                                    }
                                    if (updateAll || primaryVersion == null || secondaryVersion == null || FirmwareUpdater.this.newCoprocessorUpdateVersion == null || primaryVersion.compareTo(FirmwareUpdater.this.newCoprocessorUpdateVersion) != 0) {
                                        FirmwareUpdater.this.updatePane.setStatusMessage(Resources.getStringWithReplacement("fwUpdate.statusMessage.updatingCoprocessor", new Object[]{"location", primaryString, "version", FirmwareUpdater.this.newCoprocessorUpdateVersionString}));
                                        result = FirmwareUpdater.this.updateCoprocessor(primaryTarget);
                                        if (result != 0) {
                                            FirmwareUpdater.this.updateComplete(result, Resources.getStringWithReplacement("fwUpdate.statusMessage.errorUpdatingCoprocessor", new Object[]{"location", primaryString, "status", String.valueOf(result)}));
                                            logger.error("Error flashing " + primaryString + " coprocessor: " + result);
                                            break block47;
                                        }
                                    }
                                    RequestMessage restart = FirmwareUpdater.this.system.getMessageFactory().newRestartSystemRequest();
                                    restart.setUser(FirmwareUpdater.this.system.getManagementUserId());
                                    restart.setPassword(FirmwareUpdater.this.password);
                                    if (updateAll || primaryVersion == null || secondaryVersion == null || FirmwareUpdater.this.newCoprocessorUpdateVersion == null || secondaryVersion.compareTo(FirmwareUpdater.this.newCoprocessorUpdateVersion) != 0) {
                                        FirmwareUpdater.this.updatePane.setStatusMessage(Resources.getStringWithReplacement("fwUpdate.statusMessage.restartingControllerModule", new Object[]{"location", secondaryString}));
                                        logger.info("Restarting " + secondaryString + " coprocessor...");
                                        restart.setTargetController(secondaryTarget);
                                        restartResponse = FirmwareUpdater.this.system.postMessage(restart);
                                        restartResponse.getResultCode();
                                        logger.info("Pausing 40 seconds before restarting " + primaryString + " coprocessor...");
                                        try {
                                            Thread.sleep(40000L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    if (updateAll || primaryVersion == null || secondaryVersion == null || FirmwareUpdater.this.newCoprocessorUpdateVersion == null || primaryVersion.compareTo(FirmwareUpdater.this.newCoprocessorUpdateVersion) != 0) {
                                        FirmwareUpdater.this.updatePane.setStatusMessage(Resources.getStringWithReplacement("fwUpdate.statusMessage.restartingControllerModule", new Object[]{"location", primaryString}));
                                        logger.info("Restarting " + primaryString + " coprocessor...");
                                        restart.setTargetController(primaryTarget);
                                        restartResponse = FirmwareUpdater.this.system.postMessage(restart);
                                        restartResponse.getResultCode();
                                        logger.info("Pausing 40 seconds to allow " + primaryString + " coprocessor to finish rebooting...");
                                        try {
                                            Thread.sleep(40000L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    FirmwareUpdater.this.updateComplete(0, Resources.getString("fwUpdate.statusMessage.updateComplete.success"));
                                }
                                catch (IOException e) {
                                    FirmwareUpdater.this.updateComplete(-102, Resources.getString("fwUpdate.statusMessage.updateComplete.failure"));
                                    logger.error(e);
                                }
                                catch (PropertyListException e) {
                                    FirmwareUpdater.this.updateComplete(-103, Resources.getString("fwUpdate.statusMessage.updateComplete.failure"));
                                    logger.error("PropertyListException: " + e);
                                }
                                break block48;
                            }
                            catch (Throwable throwable) {
                                Object var4_8 = null;
                                FirmwareUpdater.this.system.clear();
                                FirmwareUpdater.this.system.authenticate(null, FirmwareUpdater.this.system.getMonitoringUserId(), FirmwareUpdater.this.system.getMonitoringPassword(), false);
                                FirmwareUpdater.this.system.setPollingEnabled(true);
                                throw throwable;
                            }
                        }
                        Object var4_4 = null;
                        FirmwareUpdater.this.system.clear();
                        FirmwareUpdater.this.system.authenticate(null, FirmwareUpdater.this.system.getMonitoringUserId(), FirmwareUpdater.this.system.getMonitoringPassword(), false);
                        FirmwareUpdater.this.system.setPollingEnabled(true);
                        return;
                    }
                    Object var4_5 = null;
                    FirmwareUpdater.this.system.clear();
                    FirmwareUpdater.this.system.authenticate(null, FirmwareUpdater.this.system.getMonitoringUserId(), FirmwareUpdater.this.system.getMonitoringPassword(), false);
                    FirmwareUpdater.this.system.setPollingEnabled(true);
                    return;
                }
                Object var4_6 = null;
                FirmwareUpdater.this.system.clear();
                FirmwareUpdater.this.system.authenticate(null, FirmwareUpdater.this.system.getMonitoringUserId(), FirmwareUpdater.this.system.getMonitoringPassword(), false);
                FirmwareUpdater.this.system.setPollingEnabled(true);
                return;
            }
            Object var4_7 = null;
            FirmwareUpdater.this.system.clear();
            FirmwareUpdater.this.system.authenticate(null, FirmwareUpdater.this.system.getMonitoringUserId(), FirmwareUpdater.this.system.getMonitoringPassword(), false);
            FirmwareUpdater.this.system.setPollingEnabled(true);
        }

        UpdateThread() {
        }
    }
}

