/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.validation;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.impl.validation.EntityState;
import org.apache.xerces.impl.validation.ValidationContext;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;

public class ValidationState
implements ValidationContext {
    private boolean fExtraChecking = true;
    private boolean fFacetChecking = true;
    private boolean fNormalize = true;
    private EntityState fEntityState = null;
    private NamespaceSupport fNamespaceSupport = null;
    private SymbolTable fSymbolTable = null;
    private final Hashtable fIdTable = new Hashtable();
    private final Hashtable fIdRefTable = new Hashtable();
    private static final Object fNullValue = new Object();

    public void setExtraChecking(boolean newValue) {
        this.fExtraChecking = newValue;
    }

    public void setFacetChecking(boolean newValue) {
        this.fFacetChecking = newValue;
    }

    public void setNormalizationRequired(boolean newValue) {
        this.fNormalize = newValue;
    }

    public void setEntityState(EntityState state) {
        this.fEntityState = state;
    }

    public void setNamespaceSupport(NamespaceSupport namespace) {
        this.fNamespaceSupport = namespace;
    }

    public void setSymbolTable(SymbolTable sTable) {
        this.fSymbolTable = sTable;
    }

    public boolean checkIDRefID() {
        Enumeration en = this.fIdRefTable.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (this.fIdTable.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.fExtraChecking = true;
        this.fFacetChecking = true;
        this.fIdTable.clear();
        this.fIdRefTable.clear();
        this.fEntityState = null;
        this.fNamespaceSupport = null;
        this.fSymbolTable = null;
    }

    public void resetIDTables() {
        this.fIdTable.clear();
        this.fIdRefTable.clear();
    }

    public boolean needExtraChecking() {
        return this.fExtraChecking;
    }

    public boolean needFacetChecking() {
        return this.fFacetChecking;
    }

    public boolean needToNormalize() {
        return this.fNormalize;
    }

    public boolean isEntityDeclared(String name) {
        if (this.fEntityState != null) {
            return this.fEntityState.isEntityDeclared(name);
        }
        return false;
    }

    public boolean isEntityUnparsed(String name) {
        if (this.fEntityState != null) {
            return this.fEntityState.isEntityUnparsed(name);
        }
        return false;
    }

    public boolean isIdDeclared(String name) {
        return this.fIdTable.containsKey(name);
    }

    public void addId(String name) {
        this.fIdTable.put(name, fNullValue);
    }

    public void addIdRef(String name) {
        this.fIdRefTable.put(name, fNullValue);
    }

    public String getSymbol(String symbol) {
        if (this.fSymbolTable != null) {
            return this.fSymbolTable.addSymbol(symbol);
        }
        return symbol.intern();
    }

    public String getURI(String prefix) {
        if (this.fNamespaceSupport != null) {
            return this.fNamespaceSupport.getURI(prefix);
        }
        return null;
    }
}

