DMF     TXT   BASIC   TXT p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  














                                 DMF-80/ST 1.0
                          [Device Management Facility]
                          [For 8080 family processors]
                          [Single Task - Version 1.0]




















                                      1980
                                 Dave Dunfield



                                      DMF-80/ST

                                  TABLE OF CONTENTS


                                                                            Page

        1. DOS COMMANDS                                                        1


        2. COMMAND MODE                                                        5


        3. DISK DIRECTORY                                                      5


        4. RETURN CODES                                                        5


        5. BOOTSTRAP (IPL)                                                     6


        6. DISK SUBSYSTEM                                                      6


        7. SUPERVISOR CALLS                                                    7


        8. INTERFACING TO USER PROGRAMS                                       10

           8.1 Parameter Passing                                              10
           8.2 Program Termination                                            10

        9. UTILITIES                                                          11

           9.1 DISKUTIL - Functions for diskette maintenance                  11
           9.2 TYPE - Display file on console                                 11
           9.3 RENAME - Rename a file                                         11
           9.4 @ - Command File Interpreter                                   12
           9.5 NSTAR - North Star DOS emulator                                15
           9.6 BGND - Start/Stop background processing                        16

        10. DMF MEMORY LAYOUT                                                 17

           10.1 Disk layout                                                   17
           10.2 Memory layout                                                 17
           10.3 Entry points                                                  17
           10.4 Customizing console I/O functions                             18
    DMF-80/ST                                                        Page: 1


    1. DOS COMMANDS

       Operands to commands are as follows:

            <filename>    - A name of a file including the extension
                            optionally followed by a comma and a disk
                            drive number. Drive 1 is assumed if the
                            drive number is not given.
                                eg: TESTFILE.DAT
                                    TESTRUN,2

            <objname>     - The name of an executable object file.
                            eg: BASIC
                                TESTRUN,2

            <drive>       - A disk drive number from 1 to 3

            <diskadr>     - A disk sector address (0-349) in decimal.

            <filsize>     - A file size (0-255) in decimal.

            <ramadr>      - A memory address (0-FFFF) in hex.

       Operands shown in [] are optional.

       CReate <filename> <filesize> [diskadr]              - For NON .OBJ
       CReate <filename> <filesize> <ramadr> [diskadr]     - For .OBJ files

          Creates the file <filename>,  making it <filsize> blocks in size.  If
          <dskadr>  is given,  locates it at that sector address on  the  disk,
          otherwise it is located at the next  available  block  following  the
          last file on the disk.

          If filetype is .OBJ,  then  <ramadr>  is expected,  and  defines  the
          memory address where the content of  the  file  will  be  loaded  and
          executed in response to a RUN command.


       DELete <filename> [Y]

          Deletes the  file  <filename>.  If  <filename>  contains  '*'s,  then
          prompts for each file to be deleted.  If you reply "Y" to the prompt,
          then the file will be deleted.  If you reply "N",  then the file will
          NOT be deleted.  If you reply "Q", then the file will not be deleted,
          and no more files will be prompted for.  If you type CONTROL-C,  then
          NONE of the files will be deleted  (even  if  you  replied  "Y"  when
          prompted for them).  If the optional "Y"  parameter is supplied,  the
          all matching files will be deleted without prompts.
       DMF-80/ST                                                        Page: 2


       DIRect <filename> or <drive>

          Lists the disk directory.  If  <filename>  is given,  then lists only
          matching files.  <filename> may include the character "*" which means
          "anything".

           eg: DIR *.*         - All files on drive 1
               DIR *.obj,2     - .OBJ files only on drive 2
               DIR A*.*        - Files starting with "A" on drive 1

          If a drive number is given,  list entire directory on that drive.  If
          no operands are given, lists entire directory on drive 1.

           eg: DIR             - All files on drive 1
               DIR 2           - All files on drive 2

          Listing produced is in the following format:

           <name>  <type>  <address>   <size>  [ramadr]

           where:
               <name>      is the file name
               <type>      is the file extension
               <address>   is the starting disk sector address
               <size>      is the size in disk blocks
               [ramadr]    Is the run address (.OBJ files only)

           eg: DOS     .SYS   04   10
               BASIC   .OBJ   14   12  0100
               EDIT    .OBJ   26   12  0100
               EDIT    .ASM   38  100


       JUmp <ramadr> [user operands]

          Jumps to the address <ramadr>  starting execution.  F-E register pair
          will point to the rest of the command line (terminated by CR  (0Dh)),
          allowing the program to receive operands.

           eg: JMP 0100
               JMP 0100 1000


       LOad <filename> <ramadr>

          Loads the file <filename> into memory at <ramadr>.

           eg: LOAD EDIT.OBJ 5F00

       SAve <filename> <ramadr>

          Writes the file <filename> from memory at <ramadr>.

           eg: SAVE EDIT.OBJ 5F00
       DMF-80/ST                                                        Page: 3


       RUn <objname> [user operands]

          Loads the file  <objname>.OBJ into memory at  it's  run  address  amd
          jumps to it. D-E register pair points to the rest of the command line
          (terminated by CR (0Dh)), allowing programs to receive operands.

           eg: RUN BASIC,2
               RUN EDIT TEST.ASM

       <objname> [user opernads]

          Implied  "RUN"  command.  Executes file  <objname>.OBJ as if by  RUN.
          NOTE: Unlike "RUN",  the implied run will NOT read the disk directory
          if it already has it in memory  (this avoids  starting  the  disk  on
          typing mistakes), therefore when a disk is changed, an implied run of
          a file on that disk may not work until some  directory  activity  has
          occured.

           eg: BASIC,2
               EDIT TEST.ASM


       REad <drive> <diskadr> <blks> <ramadr>

          Reads from drive <drive>,  starting at sector <diskadr>,  for  <blks>
          sectors, placing rata in memory at <ramadr>.

           eg: READ 1 4 10 8F00


       WRite <drive> <diskadr> <blks> <ramadr>

          Writes to drive  <drive>  starting at sector  <diskadr>,  for  <blks>
          blocks from memory at <ramadr>

           eg: WRITE 2 4 10 8F00


       SEt DRive <drive>

          Sets the default drive number  (1-3)  which the dos will use when  no
          drive letter is supplied.


          SEt OUtput <device>

          Sets the console output device to <device> (0-255).  255 is a special
          case and means inhibit console output.  Note:  "."  prompt and  input
          character echo will still occur ont he real console (0).


       REt

          Returns from DOS to calling program. If not nested, then no action is
          taken.
       DMF-80/ST                                                        Page: 4


       DISplay <ramadr1> pramadr2]

          Displays memory at <ramadr1>.  If <ramadr2>  is given,  displays from
          <ramadr1> to <ramadr2>.


       STore <ramadr> <byte1> [byte2 byte3 ...]

             Stores  the  operand  <bytes>  into  sequential  memory  locations
          starting at <ramadr>.
       DMF-80/ST                                                        Page: 5


       2. COMMAND MODE

          Dos commands can be entered whenever the dos is in command  mode  and
          prompts with  '.'.  Any lower-case characters input will be converted
          to upper case.  Characters may be deleted from the  input  line  with
          either a BACKSPACE  (08h)  or DELETE  (7Fh)  character.  If DELETE is
          used, a space will be printed over the characters being deleted.  The
          entire input line can be cancled with a  CONTROL-C  (03h)  character.
          The input line can be a maximum of 128 characters in length.

          Output from dos commands  can  be  stopped  with  a  CONTROL-S  (13h)
          character from the console,  and restarted  with  a  CONTROL-Q  (11h)
          character.  At anytime,  output from dos commands can be  stopped  by
          sending a CONTROL-C character from the console. If this is done, then
          a return code of (5) will be returned by that command.


       3. DISK DIRECTORY

          The first four blocks  (1k)  of the disk is  reserved  for  the  disk
          directory.  This directory consists of 64 file entries, each of which
          is 16 bytes in size, and have the following format:

                                |FILENAME|TYP|DS|S|UD|

           Where:
               FILENAME    - is the name of the file           (8 bytes)
               TYP         - is the type/extension             (3 bytes)
               DA          - is the starting disk address      (2 bytes)
               S           - is the size in blocks             (1 byte )
               UD          - is two bytes of user data.        (2 bytes)
                   For .OBJ files, UD contains the run address.

       4. RETURN CODES

          When  a  command  or  .OBJ  file  terminates,  the  contents  of  the
          accumulator is assumed to be the RETURN CODE.  The dos  will  display
          this return code in the form of "R(rc);"  where rc is the contents of
          the accumulator.  If the return code was ZERO (0),  this means normal
          completion, and the message "R;" is output instead.

           The return codes produced by the dos commands are:

               0       - Normal completion (success)
               1       - Operand missing or invalid
               2       - File does not exist
               3       - File already exists
               4       - Disk capacity overflow
               5       - Directory full
               6       - Unrecoverable disk error
               7       - Stopped by CONTROL-C from console.
               255     - Unknown command.

          When a dos command RETURN CODE is zero, the Z flag is set,  otherwise
          it is cleared.
       DMF-80/ST                                                        Page: 6


       5. BOOTSTRAP (IPL)

          When the system is IPL'd,  the bootstrap loaded loads one block  (256
          bytes)  at address zero  (0000).  This is the user program interface,
          handling all requests from outside software. The remainder of the dos
          is loaded into high memory  (usually F000h),  and  is  accessed  only
          through the UPI.  User programs normally start at 0100,  which  gives
          them the maximum available RAM.

          When the system is first booted up,  the dos looks for a file  called
          "IPLSTART.OBJ".  If it exists,  then it is automatically  loaded  and
          run, otherwise the dos enters command mode.


       6. DISK SUBSYSTEM

          The disk subsystem performs all I/O to the disk drives.  It has three
          main  operating  modes:  Reading  the  disk,  Writing  the  disk  and
          Verifying the disk.  If any errors occur during these operations, the
          disk system will retry the operation up to ten times.  If it is still
          unsuccessful,  a message of the  form  "HDE(nn)  Dxx  Syyy"  will  be
          displayed,  where nn is the error code  (see below),  xx is the  disk
          drive number, and yyy is the sector where the error occured. A return
          code of (4)  will be returned to the operating system indicating that
          a HARD DISK ERROR has  occured.  During  WRITE  operations,  data  is
          verified after each track is written.

               DISK SYSTEM ERROR CODES:

                   0       - Success, will not be displayed
                   1       - Sync. byte not found (Start of block)
                   2       - Read data CRC error
                   3       - Verify data error
                   4       - Write protect violation
                   255     - Parameters to disk system were invalid.
       DMF-80/ST                                                        Page: 7


       7. SUPERVISOR CALLS

          All communication with the dos is done through a  pseudo  instruction
          called an SVC.  This instruction  has  the  form  <RST2(D7h)><operand
          byte>.  The  <operand byte>  is examined by the dos to determine  the
          request.

          Here are the currently implemented SVC's.  ("*"  indicates  that  dos
          return code conventions  are  observed,  return-code  and  flags  are
          undefined for all others. Attempt to execute an undefined SVC results
          in a return code of 255):

           0  -Reboot system. Used to return to DOS when DOS memory has been
               overwritten.

           1  -Tests the console to determine if any characters have been
               entered, returns with character in A and 'C' flag set if so.
               Sets 'Z' flag if character was CONTROL-C (03h). If no characters,
               returns FF in A, and Z+C clear.

           2  -Gets a character from the console and returns in A. Waits
               until a character has been entered.

           3  -Outputs character in A to console.

           4  -Gets a character from input device passed in A, returns
               character in A.

           5  -Outputs character in B to device in A.

           6  -Outputs Line-Feed/Carriage-Return to console. Returns with Z
               flag set if CONTROL-C (03h) has been entered. Also tests for
               CONTROL-S (13h) entered, and if so, waits until CONTROL-Q (11h)
               is entered.

           7  -Prints a space on the console, no registers affected.

           8  -Writes the string pointed to by HL to the console. String
               terminates with CR (0Dh) or NUL (00) - if CR is found, a CR/LF
               pair (newline) will be output.

           9  -Outputs value in A to console (2 HEX digits.)

           10 -Outputs value in HL to console (4 HEX digits).

           11 -Outputs value in HL to console (1-5 DECIMAL digits).

           12 -Gets and buffers a line from the console. Prompts with ".",
               points DE to the buffer.

           13 -Same as (12) but with no "." prompt.

           14 -Advances DE to the first non-blank character. Sets Z flag if
               it is CR (end of line).

       *   15 -Gets value in HL from HEX operand in line pointed to by DE.
       DMF-80/ST                                                        Page: 8


       *   16 -Gets value in HL from DECIMAL operand in line pointed to by
               DE.

       *   17 -Gets and stores within the DOS a filename from the line
               pointed to by DE (may contain "*"). Points HL to saved name.
               Saved name is in same form as directory entry (8 bytes for
               name, 3 bytes for type, no "." between. Names/Types shorter
               than 8/3 characters are padded to the right with blanks).
               C = disk# indicated.

       *   18 -Tests name gotten by (17) for validity as a single file
               (no "*"s etc.). Points HL to saved name.

       *   19 -Gets and stores a filename pointed by DE and insures that
               it is valid as a single file. Points HL at saved name, C=
               disk unit indicated.

           20 -Compares name pointed to by HL to name from (17) or (19).
               Works same as operand to "DIRect". IE: Matches "*"s to
               "anything". Z flag set on exit if names match.

       *   21 -Reads directory into ram buffer at FC00. Uses disk drive
               from (17), (18) or (29). Points HL at the start of the 1k
               buffer.

       *   22 -Writes directory from ram buffer at FC00. Uses disk drive
               from (17), (18) or (29).

       *   23 -Locates name from (17) or (19) in directory read in by (21).
               Points HL at first byte of entry. On exit, Z flag set if
               the file was found.

       *   24 -Locates name from (17) or (19) in directory. Reads directory
               into buffer first. Points HL at directory entry. On exit Z
               flag is set if the file was found.

       *   25 -Calculates operands for disk command from directory entry
               pointed to by HL, ram address passed in BC. To complete Load
               or Save, Just indicate operation in B then call (27) or (28).
               If success, then Z flag is set and A contains number of
               blocks to load. Otherwise, Z is cleared and A contains return
               code.

       *   26 -Calculates operands for disk command from buffered filename,
               ram address passed in HL. To complete Load or Save, Just indicate
               operation in B then call (27) or (28). If success, then Z flag
               is set and A contains number of blocks to load. Otherwise, Z is
               cleared and A contains return code.

       *   27 -Reads/Writes/Verifies disk. A=#blocks, C=command(0=Write,
               1=Read,2=Verify), C=drive#, DE=ram address HL=disk address.

       *   28 -Same as (27) but ignores C, disk drive used is that from (17)
               or (19).
       DMF-80/ST                                                        Page: 9


       *   29 -Sets disk drive for disk operations using dos supplied drive#
               (ie: (21) and (22)) to value passed in A.

       *   30 -Reenter DOS with no return. Return code is passed in A.
               (see also SVC 39).

       *   31 -Enter DOS, returns when dos "RET" command is issued.

       *   32- Execute DOS command pointed to by DE.

       *   33 -List directory from "DIRect" operand pointed to by DE.

           34 -Sets address to call when RST1 instruction is executed to
               value passed in HL. If RST1 is executed before this SVC,
               result is non-returnable dos reentry.

           35 -Set console output device to value passed in A. Device 255
               means "no output".

           36 -Looks up word pointed to by DE in table pointed to by HL.
               Format of table is: Words separated by single spaces
               ending with two spaces (eg: "READ WRITE TEST  "). Returns
               position of word in table in both A and B, starting with
               zero (0) for the first word. If the word is not found,
               returns one greater than the number of words in the table.
               Skips any leading blanks and leaves DE pointing to the
               first non-blank character following the word. NOTE: Only
               tests the number of characters as the word in the table
               (ie: If DE points to "COMMAND" and the entry "COM" appears
               in the table, then a match will occur, and DE will be left
               pointing to the second "M" in "COMMAND".

           37 -Finds the next free disk address following the last file
               in the currently loaded disk directory and returns it in HL.
               DOES NOT READ IN THE DIRECTORY FIRST!

       *   38 -Finds the first unused 16 byte directory entry (contains no
               file information) in the currently loaded disk directory,
               and returns it's address in HL.
               DOES NOT READ IN THE DIRECTORY FIRST!

           39 -Sets the address to be jumped to when an SVC 30 instruction
               is encountered to the value passed in HL. If H contains zero,
               then address is reset to reenter dos.

       *   40 -Sets the default drive used by DOS to the ASCII value passed
               in A (ie: '1' = drive1, '2'=Drive 2)

       *   41- Obtains a filename only (no extension) from the line pointed to
               by DE. Filename must indicate a a single file (no '*'s). Adds
               the type ".OBJ". On exit, HL points to the buffered file type,
               allowing it to be changed. Saved name is in same form as
               directory entry (8 bytes for name, 3 bytes for type, no "."
               between. Names shorter than 8 characters are padded to the right
               with blanks).
       DMF-80/ST                                                        Page: 10


       8. INTERFACING TO USER PROGRAMS

          8.1 Parameter Passing

             When a user program is executed  (via  "RUN",  "JUMP"  or  implied
             RUN),  the dos will point  the  DE  register  pair  at  the  first
             non-blank character following the the  name  of  the  program  (or
             address in the case of  "JUMP")  in the command line  buffer,  and
             will place that character in A.  The Z flag will  be  set  if  the
             character is CR,  which indicates that there are no  command  line
             operands.  If parameters exist, the user program may now use SVC's
             to extract them. SVC's exist to obtain filenames, lookup keywords,
             and to obtain decimal and hex numbers.

          8.2 Program Termination

             A user program can terminate in one of two ways.  First,  the  the
             stack has not been moved,  it can just issue  a  RET  instruction.
             Second, it can issue the "SVC 30" instruction. In either case, the
             content of the accumulator is used as the return code.  Return via
             "RET" will allow dos to return to any routine calling it  (via SVC
             31).  Use of  "SVC 30"  will reinitialize the dos,  DESTROYING any
             nested DOS calls.  Programs  running  at  address  0100h  normally
             destroy any calling program (also loaded at 0100h)  when executed,
             therefore they should exit with "SVC 30"  to insure that no return
             to a previously active program will be attempted.
       DMF-80/ST                                                        Page: 11


       9. UTILITIES

          The following  utility  programs  are  supplied  with  the  DMF  disk
          operating system:

          9.1 DISKUTIL - Functions for diskette maintenance

                                 DISKUTIL <function>

               INIT    - Initializes the disk to blanks (deleteing all files).
                         Prompts with drive number, allowing you to change
                         disks first.

               SORT    - Sorts the directory on the disk by disk-address.
                         Prompts for drive number.

               COMP    - Compresses the disk, reclaiming any extra space in
                         between files. Prompts for drive number.

               COPY    - Copes a disk from one drive to another. Prompts for
                         the "FROM" and "TO" drives.

          9.2 TYPE - Display file on console

                        TYPE <filename> [start-line# [#lines]]

             Displays the contents of the text file <filename>  on the console.
             An optional starting line number and number of  lines  to  display
             may be specified.

          9.3 RENAME - Rename a file

                             RENAME <filename> <newname>

             Changes the name of the specifed file to the new name given.
       DMF-80/ST                                                        Page: 12


          9.4 @ - Command File Interpreter

                               @ <filename> <operands>

             Command files are a method of executing multiple DOS commands  and
             programs with only one command from the console.  The command file
             interpreter has its own set of  control  statements,  as  well  as
             variables which may be used to provide and access operands to  the
             dos commands.  All control statements and variables begin with "&"
             to distinguish them from dos commands.

             The variables are "&@"  and "&A-&Z".  Each variable may contain up
             to 8 characters of information.  When a command file is first run,
             all variables are cleared to blanks,  except for  "&@"  which will
             contain a number indicating how many operands were  supplied,  and
             "&N" which contains the name of the command file.  Any operands to
             the command file will be  assigned  to  variables  beginning  with
             "&A".  Ie:  &A contains the first operand,  &B contains the second
             and so on.  Before a line from the command file is  executed,  any
             variables  in  that  line  are  replaced  with  the  values   they
             represent.

             After a dos command is executed,  the return code is  assigned  to
             the special variable "&R".

             Any line beginning with  "*"  is assumed to be a  comment  and  is
             ignored by the interpreter.

             Labels may be placed at the beginning of any line,  and must start
             with "-".  A label may be on a line by itself, or may have another
             statement following on the same line.
               eg: -LABEL
                   -LABEL DIR  *.OBJ

             9.4.1 Command Control Statements

                Operands to control statements are as follows:

               <a> - Any variable or constant which evaluates to a numeric
                     value. Eg: 100
               <x> - Any variable or constant. EG: &A or TEST
               <v> - Any variable.
               <l> - Any label. Eg: -LOOP
               ..  - More than one operand may be given.
       DMF-80/ST                                                        Page: 13


       STATEMENT        -------------------- FUNCTION -----------------------

       &TYPE  <x> ..       Displays all operands on the console.
                           eg: &TYPE FIRSTS OPERAND IS &A

       &TYPEN <x> ..       Same as &TYPE but no CR/LF is output at the end.

       &READ  <v> ..       Operands must be variables. Gets values for the
                           operand variables from the console. Prompts with
                           ".". Any extra words from the input line are
                           ignored. If there are more operand variables then
                           there are words in the input line, then the remainder
                           are set to blanks.  eg: READ &P &G &R

       &READN <v> ..       Same as &READ, but no "." prompt.

       &NUM   <x> ..       Sets the return code variable "&R" to zero (0) if
                           the arguments are all numeric, otherwise "&R" is set
                           to one (1). EG: &NUM &A &B &C
                   NOTE:   The &NUM function will return a one (1) if all of
                           it's arguments are null (blanks), however if more than
                           one argument is given, and one of them is null, &NUM
                           does not "know" that that argument was ever there, and
                           will return a zero (0) if the remaining arguments are
                           numeric.

       &SKIP <n>           Skips ahead <n> lines in the command file and
                           continues from there.

       &GOTO <l>           Jumps to label <l> and continues from there.

       &EXIT <n>           Terminates command file execution and returns to dos
                           with return code <n>.

       &IF <x> = <x> <any statement>       Executes of <any statement> only if
       &IF <n> < <n> <any statement>       the specified condition is TRUE.
       &IF <n> > <n> <any statement>       (">" and "<" apply to numbers only).

       <v> = <x>                           Assignment to variable.
       <v> = <n> + <n>                     "+" and "-" can only be used with
       <v> = <n> - <n>                     numbers.

                In most cases,  all control statements,  operands and operators
                (+, -, =, >, <) must be separated by at least one space.

             9.4.2 Errors

                If a syntax error occurs in a command file  (like trying to add
                non-numeric values), execution will be stipped with the message
                "ERROR,LINE=nn"  where nn is the line where the error  occured.
                If the error was an attempt to &SKIP  beyond  the  end  of  the
                file,,, the message "SKIP ERROR,LINE=nn" will be displayed.  If
                the error was a jump to an undefined label, the message will be
                "LABEL ERROR,LINE=nn".  If the  end  of  the  command  file  is
                encountered, the message "<EOF>" will be printed.
       DMF-80/ST                                                        Page: 14


             9.4.3 Sample Command File

           * THIS COMMAND FILE SIMPLY COUNTS FROM THE FIRST OEPRAND
           * VALUE TO THE SECOND. IT HAS NO REAL PURPOSE OTHER THAN
           * TO DEMONSTRATE COMMAND CONTROL STATEMENTS AND VARIABLES.
           * THE THIRD OPERAND IS THE NAME OF A .OBJ FILE WHICH WILL
           * BE RUN WHEN THE COUNT IS FINISHED
           *
           * VERIFY THERE ARE 3 OPREANDS
           &IF &@ = 3 &SKIP 2
           &TYPE "&N" REQUIRES THREE OPERANDS
           &EXIT 1
           * CHECK THAT OPERANDS 1 AND 2 ARE NUMBERS
           &NUM &A &B
           &IF &r = 0 &SKIP 2
           &TYPE ARGUMENTS TO "&N" MUST BE NUMBERS
           &EXIT 2
           * PERFORM THE COUNT & DISPLAY
           &B = &B + 1
           -COUNT &TYPE &A
           &A = &A + 1
           &IF &A < &B GOTO -COUNT
           * NOW RUN THE .OBJ FILE
           * JUST FOR FUN, USE THE "DIR" COMMAND TO SEE IF IT EXISTS
           DEV 255
           DIR &C.OBJ
           IF &r = 0 &SKIP 3
           DEV 0
           &TYPE THE FILE "&C.OBJ" DOES NOT EXIST
           &EXIT 3
           DEV 0
           RUN &C
           &TYPE done... RETCODE=&R
           &EXIT &R
       DMF-80/ST                                                        Page: 15


             9.4.4 Saving Command Variables

                Command file variables are stored  in  one  256  byte  page  of
                memory  located  1k  (400h)  beyond  the   beginning   of   the
                interpreter.  This page can be saved and loaded using  the  dos
                "SAVE" and "LOAD"  commands.  This has the effect of saving and
                restoring all of the variables.

               eg: If you have the standard "@.OBJ" file origined to run
                   at E000h, then you can use the commands:

                           CR VARS.SAV 1
                           SAVE VARS.SAV E400

                   to save the variables in the file "VARS.SAV". The command:

                           LOAD VARS.SAV E400

                   can be used to restore the variables to their contents
                   prior to SAVEing them.

             NOTE: The special variable "&R" will be overwritten with the
                   return code from the LOAD command and therefore will not
                   be restored.

          9.5 NSTAR - North Star DOS emulator

                              NSTAR <program> [operands]

             The NSTAR command implements a simulation of the NorthStar DOS 5.1
             operating system by translating NorthStar DOS  entry  points  into
             DMF SVC calls,  and  also  translating  the  DMF  directory  entry
             structure  into  NorthStar  DOS  directory  entry  format.   Since
             NorthStar DOS does not have three character file types, only files
             with an extension of  "#nn"  are visible to the NorthStar program,
             where nn is the NorthStar file type.  eg:  "BASIC.#01" shows up to
             the  NorthStar  program  as  "BASIC"  with  a  file  type  of  "1"
             (executable program).

             <program> must be the name of an executable NorthStar DOS program.
             For  example,  if  you  save  an  image  of  the  NorthStar  BASIC
             interpreter into a DMF file called BASIC.#01, then you can run the
             NorthStar BASIC under DMF with the command: NSTAR BASIC

             Once loaded,  the "CAT"  command will show you only DMF files with
             the extension "#nn". BASIC program can be loaded and saved in .#02
             files,  and BASIC DATA can be stored in files having the extension
             .#03.

             NOTE:  An easy way to move files back and forth  between  DMF  and
             NorStar DOS is to use the DMF READ and NorthStar  RD  commands  to
             bypass the file structure and read files directly  from  the  disk
             sectors.  You will first have to determine the file  position  and
             size by viewing the disk directory under the appropriate operating
             system. Once loaded, you can use the DMF CREATE/SAVE and NorthStar
             CR/SF commands to save the content  of  the  file  in  the  booted
             operating system format.
       DMF-80/ST                                                        Page: 16


          9.6 BGND - Start/Stop background processing

                            BGND <.BGT program> [oprands]

             The BGND command loads a background process  which  runs  whenever
             the system is waiting for console I/O.

             On the standard system,  BGND.OBJ loads  at  E700,  and  runs  the
             background process at E000 - this provides 1.75k of memory to  the
             background process.

             The background process must be structured as follows:

               ORG     $E000       ; Code goes here
               JMP     INIT        ; Init function - called at starup
               JMP     XGETC       ; Called while waiting for console input
               JMP     XPUTC       ; Called while performing console output
               JMP     XTESTC      ; Called while testing for console input
               ...

             Each of the  'X'  function above will be called during console I/O
             requests - These functions must complete and return to the  OS  as
             quickly as possible to avoid system performance degradation.
       DMF-80/ST                                                        Page: 17


       10. DMF MEMORY LAYOUT

          10.1 Disk layout

             The DMS DOS image occupies 12 blocks of disk space,  which  always
             reside at disk sector address 4 to 15.  When DMF boots,  the first
             block  (4)  is  loaded  into  memory  at  address  0000-00FF,  the
             remaining 11 blocks  (5-15)  are loaded  into  memory  at  address
             F000-FAFF.

          10.2 Memory layout

             The total memory "footprint" of a DMF system is as follows:

               0000-00FF   = User Program Interface
               0100-E7FF   = Available to application code
               E800-EBFF   = NorthStar MDS disk controller hardware
               EC00-EFFF   = Unallocated
               F000-FAxx   = DMF system code
               FAxx-FAFF   = Console I/O functions
               FB00-FC00   = DMF internal memory and stack
               FC00-FFFF   = DMF disk directory buffer

          10.3 Entry points

             The following entry points and reserved  locations  are  available
             within the DMF User Program Interface:

               0000    1       Last drive accessed
               0001    1       Current track position on drive 1
               0002    1       Current track position on drive 2
               0003    1       Current track position on drive 3
               0004    3       JMP to DMF loader (boot second stage)
               0007    1       Drive directory last loaded from
               0008    3       JMP for RST-1 vector (used by debugger)
               0010    3       JMP for RST-2 vector (SVC handler)
               0018    3       JMP for RST-3 vector (I/O INIT function)
               0020    3       JMP for RST-4 vector (I/O IN   function)
               0028    3       JMP for RST-5 vector (I/O OUT  function)
               0030    3       JMP for RST-6 vector (I/O TEST function)
               0036    1       00=Disk Read-After-Write check enabled
               0038    3       JMP for RST-7 vector (Reboot system)
               003B    --      SVC handler table (word address for each SVC)
               00F2    8       DOS buffered filename NAME
               00FA    3       DOS buffered filename EXTENSION/TYPE
               00FD    1       DOS buffered filename DRIVE
               00FE    2       DOS buffered filename USER DATA
       DMF-80/ST                                                        Page: 18


          10.4 Customizing console I/O functions

             The console I/O function reside  in  the  unused  portion  of  the
             memory block at FA00-FAFF at the very end of the DMF code image.

             To  determine  the  first  available  address,  examine  the   JMP
             instructions at all four I/O vectors (0018, 0020 , 0028 and 0030).
             Which ever address is LOWEST represents the beginning of available
             space.

             You can replace the console I/O function be placing  new  code  in
             the memory block (FAxx-FAFF) and patching the JMP vectors to point
             to the correct routines:

               0018    JMP INIT
                   Initialize user I/O devices.
                   All registers may be modified.

               0020    JMP IN
                   Get character from input device passed in A (0-254)
                   Returns character in A, no other registers may be
                   modified.

               0028    JMP OUT
                   Write character in B to device passed in A.
                   No registers may be modified.

               0030    JMP TEST
                   Test for character entered on the console. If a character
                   is found, the character is returned in A, and the C flag
                   is set. The Z flag is also set if the character was CTRL-C.
                   In no character was found, return A=FF and Z+C clear.
                   No other registers may be modified.

             It is best to do this to a inactive copy of the OS that  you  have
             placed in memory via the LOAD command. Keep in mind that the first
             256 bytes of the image represent code loaded at  0000,  while  the
             remaining 11 blocks represent F000-FAFF.
       DMF-80/ST                                                        Page: 19


             It is possible to manually patch the loaded OS if you have a means
             of doing so such as front panel switches.  Once DMF boots, it will
             go into a loop trying to read  (or write)  the  console.  (In  the
             non-specific DMF distribution,  all of the I/O vectors point to  a
             single  "JMP *"  loop which will cause the system to hang once  it
             has booted).  Once this happens,  stop the system,  then  manually
             enter the I/O code,  and patch the 0018,  0020,  0028 and 0030 JMP
             vectors to activate the new functions.  Then start  the  processor
             executing at F000  -  if  everything  worked  correctly,  the  DMF
             startup prompt should appear on your console.

             You can save the newly patched DMF I/O functions directly  to  the
             disk from F000 with the SAVE command, however the vectors in block
             zero cannot be written this way. You will have re-read block0 from
             the disk into unused memory and manually patch the  vectors.  Here
             are example commands which will save a newly  patch  OS,  assuming
             the I/O function addresses are: INIT=FA09,  IN=FA21,  OUT=FA2B and
             TEST=FA4B :

               .WRITE 1 15 1 FA00          <= Save I/O code
               .READ 1 4 1 100             <= Read UPI (block 0)
               .DISP 110 13F               <= Visually confirm JMP's
               .STORE 119 09 FA            <= Patch INIT vector
               .STORE 121 21 FA            <= Patch IN   vector
               .STORE 129 2B FA            <= Patch OUT  vector
               .STORE 131 4B FA            <= Patch TEST vector
               .DISP 110 13F               <= Visually confirm changes
               .WRITE 1 4 1 100            <= Rewrite UPI (block 0)

                                                                                                                                                                                                                                            














                                  Micro Basic

                                     A Tiny
                               Basic Interpreter

                                  Users Guide

























    I originally wrote Micro Basic in 1980 for a University  Computer  Club,
    in which the members were building  their  own  8080  based  systems.  I
    subsequently ported the interpreter to my DMF operating environment.





                                 Dave Dunfield



                            Micro Basic Users Guide

                               TABLE OF CONTENTS


                                                                         Page

     1. INTRODUCTION                                                        1

        1.1 Launching Basic                                                 1

     2. COMMANDS                                                            2

        2.1 General commands                                                2
        2.2 Program only commands                                           5

     3. EXPRESSIONS                                                         6

        3.1 Numeric operators                                               6
        3.2 Character operators                                             7
        3.3 Numeric conversion                                              7
        3.4 Variables                                                       8
        3.5 Special variables                                               8

     4. PROGRAM ENTRY AND EDITING                                           9


     5. CONTROL-C                                                          10


     6. ERROR MESSAGES                                                     10


     7. SOURCE FORMAT                                                      11


     8. EXAMPLE PROGRAMS                                                   12

    Micro Basic Users Guide                                          Page: 1


    1. INTRODUCTION

       Micro Basic was implemented  with  the  intention  of  providing  the
       maximum amount of features and flexibility,  in the minimum amount of
       memory space. It is intended for use on 8080/8085/Z80 based computers
       which are too small to afford the use of larger programming  systems.
       Currently, the Basic interpreter is 3K bytes in size. A minimum of 3K
       of ram is required if any useful programs are to be implemented.  The
       interpreter only makes use of memory as it needs it,  and memory  can
       be expanded at any time,  to allow for larger programs or more  array
       space.  Micro  Basic  is  quite  different  from  most  other   BASIC
       interpreters,  in  particular  the  right  to   left   execution   of
       expressions,  with no operator precedence,  and the use  of  separate
       operators for EQUALS and ASSIGNMENT.  These implementation decisions,
       were in part,  based on  the  language  APL,  which  was  a  favorite
       language of the author at the time.

       On the following pages,  is a  brief  description  of  Micro  Basic's
       commands and features.

       1.1 Launching Basic

          BASIC is launched by typing it's name at the DMF  command  prompt.
          If you specify a filename on the BASIC command, ie: BASIC MYFILE
          the .BAS file with that name will be automatically loaded and  run
          after BASIC starts.

          If you know that BASIC is already  loaded  into  memory,  you  can
          execute it simply by jumping to address 0100, eg: JUMP 100

          If you want to return to a BASIC  which  is  already  loaded  into
          memory,  and also preserve a program already loaded into RAM under
          BASIC, then jump to address 0105, eg: JUMP 105
    Micro Basic Users Guide                                          Page: 2


    2. COMMANDS

          Operands to commands are as followes:

          <e> - Any expression.
          <v> - Any variable.
          <a> - Any array variable.
          <n> - Any numeric expression.
          <l> - A line number.
          [ ] - Optional operands.
          ... - Multiple extra operands allowed.

       2.1 General commands

          The following commands, may be entered directly from the keyboard,
          or executed with a BASIC program.

          CLEAR

             Clears  all  numeric  and  character  variables,  Delete's  all
             arrays, and resets the control stack and data pointer.

          DIM a1(<n1>)[,a2(n2)]...

             Dimensions integer arrays a1,  a2,...  makeing them n1,  n2,...
             elements  each.  Arrays  may  be  REDIMENSIONED  with  the  DIM
             statement,  however this allocates new memory  for  the  array,
             causing the old memory  used  by  the  old  array  to  be  made
             unusable  (until 'NEW',  CLEAR' or a 'RUN'  command is issued).
             Whenever an array is dimensioned or redimensioned via  DIM,  it
             is cleared to zeros.

             NOTE:  Array space is allocated in memory,  starting at the end
             of the program source.  As a result, if a line is inserted into
             the program,  or any line  is  replaced  in  the  program,  any
             existing arrays will be deleted.

          END

             Stops the program. no messages are issued.

          EXIT

                Exits to the operating system.

          GOTO <line#>

             Transfers program execution to the statement at  the  beginning
             of line <line#>.

          GOTO(<n>),<l1>[,<l2>]...

             Transfers program execution to the statement at  the  beginning
             of line <l1> if <n>=0,  to the beginning of line <l2> if <n>=1,
             etc.  results in SYNTAX ERROR if <n>  is greater than number of
             line numbers given.
    Micro Basic Users Guide                                          Page: 3


          INPUT <v>

             Requests a value for  <v>  from the terminal.  Prompts  with  a
             question mark "?".  If  <v>  is a character variable,  then any
             text can be input.  If <v> is numeric, then value supplied must
             be a number or expression.

          INPUT "<text>",<v>

             Same as above,  but prompts with <text> instead of "?".  <text>
             can be a null string ( INPUT "",<v> would give no prompt ).

             NOTE:  The value of a character variable can  be  used  in  the
             prompt,  but must be concatinated  with  <text>.  EG:  '  INPUT
             ""+A$,V '.

          LET <v>=<e> (default)

             Assigns the value of <e> to the variable <v>.  If any lines are
             found by the interpreter which do not contain a  command,  then
             they are assumed to be LET.

          LIST [<l1>][,<l2>]

             Lists the program,if no operands  are  given,  then  lists  the
             entire program. If <l1> is given then only that line is listed.
             If <l2> is also given, then lists from <l1> to <l2> inclusive.

          LOAD filename

             Loads a program from disk using the file name: filename.BAS

          NEW

             Clears the program, variables, and arrays.

          ORDER <line#>

             Positions the read pointer to the start of  the  line  <line#>.
             This line must begin with a DATA statement,  or  a  DATA  ERROR
             will occur.

          PRINT <e>[,<e>][,<e>]...[,]

             Prints the expressions on the terminal.  Numeric values will be
             printed with a preceding space.  If  a  numeric  expression  is
             preceded by a single  '(',  then the  preceding  space  is  not
             printed.  ( EG:  PRINT 12,(12 would display ' 1212'  ).  If the
             list of  expressions  ends  with  a  trailing  comma,  then  no
             line-feed carriage return will be  printed,  causing  the  next
             PRINT statement to continue at the end of the same line.
    Micro Basic Users Guide                                          Page: 4


          READ <v>[,<v>]...

             Reads the values for variables from data statements.  An  ORDER
             statement must be done before the first read in a program,  and
             anytime that you have read all the data in a data block. A data
             block,  is a collection of data statements  which  are  located
             separately,  with no other statements between them.  If a  read
             statement does not read  all  of  the  data  in  a  given  data
             statement,  then the next read will pick up where the last  one
             left off.  If a read statement reads beyond the end of  a  data
             statement,  the it will  advance  to  the  next  statement  and
             attempt to read from there.

          REM <text>

             Comment, the rest of the statement is ignored.

          RUN [filename]

             Clears variables and arrays, then starts the program running. A
             running program can be stopped by pressing CONTROL-C.

             If a  [filename]  is specified,  that .BAS file will be  loaded
             from the disk and run.

          SAVE filename

             Saves a program to disk under the name: filename.BAS NOTE:  The
             file must already exist - use the DOS command to create a  file
             if necessary.

          SIZE

             Prints the size of the program in bytes.

          STOP

             Stops the program,  issues message indicating line number where
             it was executing.

          DOS "string"

             Passes "string" to the OS command interpreter to be executed as
             an operating system command.

          USR <n1>[,<n2>][,<v>]

             Calls a user supplied machine code routine at address <n1>.  If
             <n2>  is given,  its value will be passed in the  H-L  register
             pair.  If <v> is given, it must be a numeric variable, and will
             be assigned the value of H-L after the machine language routine
             returns.
    Micro Basic Users Guide                                          Page: 5


       2.2 Program only commands

          The following commands, can only be executed within a program.

       DATA <e>[,<e>]...

          Defines program DATA,  to be read  by  the  READ  statement,  into
          program  variables.  DATA  statements  are  not  executed  by  the
          interpreter.

          NOTE: Variables can be used in the DATA statements,  but the value
          will be evaluated as the value of that variable at the  time  that
          the DATA statement is read.

       FOR <v>=<n1> TO <n2>

          Starts a program loop.  The variable <v>  will be set to  <n1>.and
          will be incremented by one every time around the  loop.  until  it
          value is equal to <n2>. <v> must be a simple numeric variable. See
          also 'NEXT' statement.

       GOSUB <line#>

          Calls a BASIC subroutine at given line number.  (Same as  goto,but
          stacks return address.) See also 'RETURN' statement.

       GOSUB(<n>),<l1>,<l2>...

             Same  as  above,  but  uses  computed  line  number.  See  also
          'GOTO(<n>)'.

       IF <e> THEN <stmt>

          Evaluates <e>,  If it is true (non-zero)  then <stmt> is executed.
          If <stmt> is a number, then assumes GOTO <stmt>.

       LIF <e> THEN <stmts>

          Long IF, same as IF,  except that the entire remainder of the line
          is executed only if the expression <e> is true.

       NEXT <v>

          Closes a program loop.  <v>  must match the  <v>  in the  matching
          'FOR' statement.

       RETURN

          Returns to statement  following  GOSUB  statement.  (Terminates  a
          BASIC subroutine)
    Micro Basic Users Guide                                          Page: 6


    3. EXPRESSIONS

       Expressions can be either numeric or character.  all expressions, are
       evaluated from right to left,  with NO operator precedence (as in the
       language APL).  For example,  1+5*5 evaluates to 26,  but 5*5+1  will
       give the answer 30.  Precedence can be forced in numeric  expressions
       with the use of brackets "()". Brackets can be nested to any depth.

       3.1 Numeric operators

                              FORMAT: X<operator>Y

        +   Addition.

        -   Subtraction.

        *   Multiplication.

        %   Division. (Remainder assigned to special variable "R").

        &   Bitwise logical AND of X and Y.

        |   Bitwise logical OR of X and Y.

        \   Floor. (returns lesser of X and Y).

        /   Ceiling. (returns greater of X and Y).

        =   Assignment. (X takes value of Y).

        ==  Equality. (returns 1 if X equals Y, 0 otherwise).

        >   Greater than. (returns 1 if X greater than Y, 0 otherwise).

        <   Less than. (returns 1 if X less than Y, 0 otherwise).

        >=  Greater equals. (Returns 1 if X GE Y, 0 otherwise).

        <=  Less equals. (Returns 1 if X LE Y, 0 otherwise).

        -=  Not equals. (Returns 1 if X not equal to Y, 0 otherwise).

        ;   Null operator, returns value of X. (but executes Y).
            Especially useful for doing modular arithmetic.
            The expression "A=R;B%123" will divide B by 123 (without
            changing B), and then assign the remainder to A. (Right
            to left execution).
    Micro Basic Users Guide                                          Page: 7


       3.2 Character operators

                             FORMAT: X$<operator>Y$

        +   Concatonation. (Y$ appended to X$).

        =   Assignment. (X$ takes value of Y$).

        ==  Equality. (only valid in "IF" and Numeric conversion).

        -=  Not equals. (only valid in "IF" and numeric converson)

          The following are other operators which perform useful functions:

        ( ) Brackets, Force operator precedence.

        [ ] Braces, Used to index numeric arrays, E.G. "A[10]"
            Also can be used to extract a single character
            from a character variable. E.G. "A[0]$" returns
            the first character in variable "A$".
            (Index starts at zero (0) ).

        #   Hexidecimal constants. EG. "A=FF#+1" calculates "FF#"
            as 255, adds 1 then assigns result (256) to "A".

        :   Statement separator, can be used to place multiple
            statements on a single program line: E.G: "A=10:PRINT A"

        ,   Operand separator, separates operands to some commands.

       3.3 Numeric conversion

          A character expression can be included in  a  numeric  expression,
          but must be contained in brackets  "()".  If the leftmost operator
          in the character expression is one of "==" or "-=",  then a 1 or 0
          is returned to the numeric (outside)  expression.  If the leftmost
          operator  of  the  character  expression  is  "=",then  the  value
          returned is the ASCII value of the  first  character  of  the  OLD
          value of the character variable.  Otherwise the ASCII value of the
          first character in the  result  of  the  character  expression  is
          returned.

          The ASCII value of a character,  is  the  decimal  value  of  it's
          binary representation. (E.G. " " (blank) is 32).  If a null string
          ("")  is the result  of  the  expression,then  the  value  255  is
          returned  (ASCII values for characters can only range  from  0  to
          127).  The expression within the brackets does not have to contain
          operators,  I.E.  " PRINT  ("A")  " will print a 65.  (The decimal
          value of an ASCII "A").
    Micro Basic Users Guide                                          Page: 8


       3.4 Variables

          There are 26  simple  integer  variables  (A-Z).  These  variables
          always exist and are cleared to zero when BASIC is entered, when a
          NEW command is executed,  and when a program is RUN.  Integers are
          positive, with a range of 0 to 65535 (16 bits of data).

          There are also up to 26 integer arrays,  (A[n]  - Z[n]).  An array
          must be created (via the 'DIM' command)  before it exists.  Arrays
          are cleared to zero's when they are created.

          Arrays when dimensioned, (DIM A(n)) have n+1 elements,  subscripts
          ranging  form  0  to  n.  Subscripts  are  not  checked   by   the
          interpreter,  therefore,  if you type 'DIM A(10),B(10)' then A[11]
          is the same as B[0].

          There are 26 character variables, (A$-Z$).  These variables always
          exist and are cleared to null strings ("")  when BASIC is entered,
          when a NEW is executed,and when a program is RUN.  Each  character
          variable can hold up to 35 characters.  The individual  characters
          can be read using braces between the character variable name,  and
          the dollar sign.  (ie.  A[0]$ to A[34]$).  If an index is  greater
          than 34,  a DIMENSION ERROR will result.  If an index  is  greater
          than the number of characters currently in the variable,  but less
          than 35,  then a null string  ("")  will  be  returned.  Character
          variables cannot be assigned values in this manner.

          The variable names are all separate, you can have A,  A[n] and A$,
          all in the same program, without interaction between them.

       3.5 Special variables

          The simple integer variable  'R'  is a special variable because it
          will be assigned the remainder  whenever  a  divide  operation  is
          executed,  and  the  return  value  whenever  a  DOS  command   is
          performed.

          The following are special variables,  unlike  'R',  they cannot be
          used as 'normal' variables:

          3.5.1 @[n]

             This variable can only be referenced as an array. When read, it
             returns the BYTE value  (0-255)  of the memory location at  its
             index (n).  When assigned a value,  that value will be assigned
             to the memory location at its index (n). (if the value assigned
             is > 255 Then it is divided by 256, and the remainder is used).
             This is the Same function as 'PEEK'  and  'POKE'  in some other
             BASIC's.

          3.5.2 @[n]$

             This character variable,  can only be referenced with an index.
             Its index can range from 0 to 255. It will return the character
             which has the binary value of its index.  (if 255 is  used,  it
             will return a null string.  This is the same function as 'CHR$'
             in some other basics.
    Micro Basic Users Guide                                          Page: 9


          3.5.3 ?

             This variable can  only  be  referenced  as  a  simple  integer
             variable When read, it returns a random number from 0 to 65535.
             When given a value,  it sets the random  seed  to  that  value.
             Random numbers can be generated within limits  by  the  use  of
             modular arithmetic. (EG.  to generate a random number between 0
             and 99,  and assign it to the variable  'A',  use  the  command
             'A=R;?%100').This is similar to  the  'RND'  function  of  some
             other basics.

    4. PROGRAM ENTRY AND EDITING

       To enter or replace a line, simply enter it's line number starting in
       column one, followed by the text for the new line.  To delete a line,
       just enter it's line number, with no following text.

       When a line is entered, (and return is pressed),  it is copied into a
       buffer.  Parts or all of this old line can be included in a new line,
       as it is typed in.  When the new line is entered,it then becomes  the
       old line.  A pointer is kept,  indicating the current position in the
       old line.  The following functions  are  available  to  perform  this
       'editing'.

       CTRL-A

          Advance:  Copy one character from the old line into the new  line,
          and advance the pointer to the next character in the old line.

       CTRL-C

          Cancel:  Cancels the  (partially)  complete new line,  and restart
          from the beginning. (resets old line pointer).

       CTRL-D

          Delete: Advances the old line pointer by one character,  deleteing
          that character from the old line. the new line is not affected.  A
          '*' character is printed to indicate this has been done.

       CTRL-F

          Find:  This command requires one extra character  to  be  entered.
          When it is,  the old line is  copied  (from  the  current  pointer
          position)  into the new line,  up to but NOT including  the  first
          occurance of that character.  The pointer is advanced to point  to
          the character found.  If the character is not found,  no action is
          taken.If the second character is a carriage  return,the  remainder
          of the old line will be copied into the new line.

       CTRL-H

          Backup:  This backs up one character,deleteing the last  character
          entered,  and backs up the old line pointer in the old line.  This
          effectively cancels the effect of the last character entered. (The
          DELETE key also invokes this function).
    Micro Basic Users Guide                                          Page: 10


       CTRL-M

          Carriage Return:  enters the new line,  causing it to  become  the
          (new) old line, and passes it to the interpreter, as input.

       CTRL-I

          Insert: Toggles insert mode. a "<" is printed when entering insert
          mode a ">" is printed when leaving insert mode. Normally, when you
          enter text into the new line, the old line pointer is advanced, so
          that  the  characters  you  are  typing,  effectivly  replace  the
          characters in the old line.  In insert mode, this does not happen,
          therefore the characters you are typing,  can be inserted into the
          old line. (If it is later copied into the new line).

       The line editor can be used  to  EDIT  program  lines,  When  a  list
       command is executed,  the last line listed will be made the old line.
       To modify line 50, you would just have to type 'LIST 50'.  This would
       display line 50,  and would also store it in  the  old  line  buffer.
       Whenever a  program  stops  due  to  an  error,  CTRL-C,  or  a  STOP
       statement, the line it stopped on will also be stored in the old line
       buffer, ready for editing.

    5. CONTROL-C

       Will abort any program,  terminated with the message  "STOP  IN  LINE
       XXXX"  where XXXX is the number of the line containing the  statement
       which would have been executed next.  Will  also  abort  program,  if
       entered when responding to an INPUT statement, but will not print the
       "STOP" message. Will also abort output from the LIST command.

    6. ERROR MESSAGES

       Below is a list of error messages produced by the interpreter. Errors
       occuring in a program, will be followed by " IN LINE XXXX" where XXXX
       is the line on which the error  was  discovered.  All  errors  except
       '?BAD DATA - RETRY' are fatal, and will stop an executing program.

       ?SYNTAX ERROR

          Results from a statement that is not decodeable.  (Does not follow
          syntax)  Also results if you attempt to use a command in the wrong
          context.  Ie.  You use a command from the keyboard which  is  only
          allowed from within a program.

       ?NO PROGRAM ERROR

          Results from an attempt to RUN or to SAVE an zero line program.

       ?DIMENSION ERROR

       Results from an attempt to index a non-array variable,  from indexing
          a character variable with a value greater than 34,  or attempt  to
          save a program which is too large for the named file.
    Micro Basic Users Guide                                          Page: 11


       ?DIVIDE BY ZERO ERROR

          Results from attempt to divide any value by zero.

       ?LINE NUMBER ERROR

          Results from reference to a program  line  number  that  does  not
          exist.

       ?DATA ERROR

          Results from attempt to ORDER to a line which does not start  with
          a DATA statement,  attempt to READ before  you  have  executed  an
          ORDER, reading beyond the end of a DATA BLOCK, or from reading the
          wrong data type (character or numeric) for the operand variable.

       ?NESTING ERROR

          Results from improper nesting of GOSUB/RETURN or FOR/NEXT loops.

       ?BAD DATA - RETRY

          Results from any error  in  a  numeric  expression  typed  as  the
          response to an INPUT to a numeric variable.  Does  not  stop,  but
          prompts again.

    7. SOURCE FORMAT

       Micro Basic  programs  are  stored  in  memory,  as  variable  length
       records, separated by carriage return character (0D hex).  The end of
       the program is marked by a  line  starting  with  a  hexidecimal  FF.
       Program lines are in the following format:

      -------------------------------------------------
      |2 bytes|1 byte| variable length section |1 byte|
      -------------------------------------------------
        \___/   \__/   \_____________________/  \____/
          ^       ^              ^                 ^_ Carriage Return.
          ^       ^              ^
          ^       ^              ^___________________ Program text.
          ^       ^
          ^       ^__________________________________ Length of remainder
          ^                                           of line. (+11 hex)
          ^
          ^__________________________________________ Packed decimal line
                                                      number (0000-9999).
                                                      (FFxx=end of prog.)
    Micro Basic Users Guide                                          Page: 12


    8. EXAMPLE PROGRAMS

       The following are some simple Micro Basic programs, which demonstrate
       many of the features of  the  language.  A  good  excercise  to  gain
       experience with the interpreter,  is  to  enter  and  run  them,  and
       observe the results.

        0010 REM THIS PROGRAM PLAYS THE HIGH/LOW GAME.
        0020 PRINT "I WILL PICK A NUMBER BETWEEN 1 AND 100"
        0030 PRINT "THEN I WANT YOU TO TRY AND GUESS IT."
        0040 PRINT "I WILL TELL YOU IF YOU ARE TOO HIGH, OR TOO LOW"
        0050 C=0
        0060 N=1+R;?%100
        0070 INPUT "WHAT IS YOUR GUESS?",G
        0080 C=C+1
        0090 LIF G==N THEN PRINT "YOU GUESSED IT IN ",C," GUESSES!":END
        0100 IF G>N THEN PRINT "YOU ARE TOO HIGH."
        0110 IF G<N THEN PRINT "YOU ARE TOO LOW."
        0120 GOTO 70

        0010 REM THIS PROGRAM WILL COUNT FROM 1 TO 10, AND DISPLAY
        0020 REM THE COUNT, BOTH AS A NUMBER, AND AS A WORD.
        0030 ORDER 60 : FOR I=1 TO 10
        0040 READ I$ : PRINT I," ",I$
        0050 NEXT I
        0060 DATA "ONE","TWO","THREE","FOUR","FIVE"
        0070 DATA "SIX","SEVEN","EIGHT","NINE","TEN"

        0010 REM THIS PROGRAM WILL INPUT N NUMBERS, AND PRINT THEM
        0020 REM OUT IN REVERSE ORDER.
        0030 INPUT"HOW MANY NUMBERS?",N:DIM A(N):FORI=1TON
        0040 PRINT"NUMBER ",I,:INPUT X:A[I]=X:NEXT I
        0050 PRINT"NOW HERE THEY ARE BACKWARDS."
        0060 FOR I=0 TO N-1:PRINT" ",A[N-I],:NEXTI:PRINT""

        0010 REM THIS PROGRAM WILL DISPLAY THE ASCII CHARACTER SET.
        0020 FOR I=0 TO 127:PRINT @[I]$:NEXTI:PRINT""

        0010 REM THIS PROGRAM WILL DISPLAY THE CONTENTS OF MEMORY
        0020 REM FROM 0000 TO 07FF IN DECIMAL.
        0030 FOR I=0 TO 7FF# : PRINT @[I],:NEXT I : PRINT ""

        0010 REM THIS PROGRAM WILL DISPLAY THE CONTENTS OF MEMORY
        0020 REM FROM 0000 TO 07FF IN ASCII.
        0030 FOR I=0 TO 7FF# : PRINT @[@[I]]$," ", : NEXT I : PRINT ""

        0010 REM THIS PROGRAM WILL INPUT A NUMBER, AND PRINT IT IN HEX.
        0020 REM NOTE THE USE OF MOD. ARITHMETIC, AND CHAR. VARIABLE INDEX.
        0030 R$="":H$="0123456789ABCDEF":INPUTN
        0040 R$=H[R;N=N%16]$+R$:IFN>0THEN40
        0050 PRINT R$
 0010 REM                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 