/*                                                               3/23/98   */
/*  2/16/95  GA version                                                    */
/* 11/04/97  Call optional user exit AWSUSER.CMD with END parameter        */
/*           Tolerate HLLAPI error if END_VSE is called w/o CM/2           */
/*  3/08/98  Ver 2.5: Stop trace spooling.                                 */
/*  3/23/98           Make default = /Kill and add /VSE parm               */

/*  AWSEND [/ASK | /NOASK]  [/Kill]
                            [/VSE ]

    /ASK   - Prompt for confirmation before terminating P/390 and/or VSE.
    /NOASK - don't prompt for confirmation.
    /Kill  - Don't try to shutdown the S/390 operating system
             Kill the P/390 Channel process right away (after optional prompt).
    /VSE   - Call END_VSE.CMD CM/2 HLLAPI commands to shutdown VSE console
*/
trace o;
'@ECHO OFF';

/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/*  Determine if this is a P/370 or a P/390        */
Parse upper source . . sspec
spath = Strip(Filespec('Path',sspec),'B','\')
If spath = 'P390' then card = 'P/390'
                  else card = 'P/370'

/*-------------------------------------------------------------------*/
/* Parse the options                                                 */
/*-------------------------------------------------------------------*/
Parse upper arg parms
ask =1;  /* default - prompt for shutdown                                 */
kill=1;  /* default - kill w/o trying to shutdown VSE operating system  */

do i=1 to words(parms);
   select;
       when word(parms,i)='/ASK'    then ask=1;
       when word(parms,i)='/NOASK'  then ask=0;
       when word(parms,i)='/KILL'   then kill=1;
       when word(parms,i)='/K'      then kill=1;
       when word(parms,i)='/VSE'    then kill=0;
       otherwise say 'Unknown option' word(parms,i) 'Ignored.';
   end;
end;

/* No VSE shutdown requested and no prompting - just terminate and exit */
if kill & ask=0 then Signal Terminate

/*-------------------------------------------------------------------*/
/* First make sure it is really running                              */
/*-------------------------------------------------------------------*/
'AWSSTAT /Q';
If rc=4  | rc=8 then do;
   Say card 'not running'  /* If P/390 isn't running, then do nothing */
   Exit 0;
   End;

/*-------------------------------------------------------------------*/
/* Look for the VSE Console -- end_vse does its own prompting,       */
/* if, in fact, VSE is up                                            */
/*-------------------------------------------------------------------*/

If kill=0 then do           /* Perform VSE Shutdown */
  If ask
     then "CALL END_VSE.CMD /ASK";
     else "CALL END_VSE.CMD /NOASK";
  vseRC=rc;
  End;
  else vseRC=1;             /* /k = quick. No VSE shutdown */

/* end_vse return codes:   0 - VSE now shutdown.                     */
/*                         1 - Something is running, but not VSE     */
/*                         2 - VSE running, user doesn't want to end */
/*                         4 - VSE was already down.                 */
/*                        <0 - CM/2 not installed or HLLAPI error    */

if vseRC=2 then exit;      /* user doesn't want to stop */

If vseRC<0 then Say 'END_VSE.CMD failed. If you are NOT running VSE, put the /k parameter on AWSEND.'

/*------------------------------------------------------------------------*/
/* If prompting, then ask user if he really wants to end P/390.           */
/* Put up a POP-UP question box                                           */
/*------------------------------------------------------------------------*/
if ask & (vseRC = 1 | vseRC < 0) then do;
   /* 16385 = 'OK+CANCEL'   */
   If spath='P370' then
      awspopup 16385 '"OK to terminate the P/370?"' '"END P/370"'
   If spath= 'P390' then
      awspopup 16385 '"OK to terminate the P/390?"' '"END P/390"'
   if rc=2 then exit;   /* user doesn't want to stop */
   rc=0;
   end;

/*----------------------------------------------------------------------*/
/* OK to kill P/390 now. Then call user P/390-ending exit, if it exists.*/
/*----------------------------------------------------------------------*/
Terminate:
say 'Terminating' card;
'AWSSTAT /K';
'AWSTRCSP /STOP';
user_file = SysSearchPath('PATH','AWSUSER.CMD') /* find in OS/2 PATH */
If user_file <> '' then do
   Say "------------- Calling END" card "user exit" user_file "------------"
   parse arg stuff             /* Pass arguments given to AWSEND.CMD */
   "CALL" user_file 'END' stuff
   Say "------------- User exit complete (RC = "rc") ---------------------------------"
   End;
Exit rc;
