/* P/370 & P/390 Installation program                      4/23/98 JAH  */
/*                                                                      */
/* 1. Check if this is a P/370 or P/390                                 */
/* 2. Get the input parameters                                          */
/* 3. Check to see any P/370 programs are running.  If so, then exit.   */
/* 4. Determine version of CM installed. If ES1.0 or CM/2 1.0 then exit.*/
/*    (now optional if TCP/IP telnet sessions ae used for local 3270s)  */
/*    Also determine which release of OS/2: Warp adds objects backwards */
/*                                                                      */
/*  - P/390 PS/2:                                                       */
/*     5. If already installed, backup previous version (saving AWSUSER)*/
/*     6. Copy all P/390 programs from first three diskettes            */
/*     7. Unzip P390MSG & LSAMON from diskette 4                        */
/*     8. Unzip PARCA code and ARTIC960 RIC from diskette 6             */
/*     9. If CM/2 is installed, call AWSCMLT to set LTs                 */
/*    10. Call last diskette for microcode install                      */
/*    11. Update CONFIG.AWS sample file with drive letter               */
/*    12. Optionally update CONFIG.SYS                                  */
/*    13. Build the P/390 folder & icons on the DeskTop                 */
/*                                                                      */
/*  - Client PS/2:                                                      */
/*     5. Copy P/390 programs from first diskette                       */
/*     6. Update CONFIG.SYS path strings                                */
/*     7. Add AWSCMLT icon to desktop                                   */
/*                                                                      */
/*  4/21/95 JAH  2.0 original P/390 (based on 6/21/89 7437 INSTALL.BAT) */
/*  2/26/96 JAH  2.1                                                    */
/*  8/12/96 JAH  2.2                                                    */
/* 11/12/96 JAH  2.3.2                                                  */
/*  6/23/97 JAH  2.3.3                                                  */
/* 11/11/97 JAH  2.4                                                    */
/*  4/23/98 JAH  2.5 Save AWSUSER.CMD and create CUSTOMER.DAT           */
/*                   Prompt for either P/390 or P/390E LIC diskette     */
/*                   Don't unzip AWSPBS.ZIP, but leave on hard drive    */
/*                                                                      */
"@ECHO OFF"
trace o
num_disks = 6   /* Set to number of Program diskettes */
New_level = '250' /* The level being installed */
back_dir = ''
Parse upper arg xx .

/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/*                                                */
/*  Determine if this is a P/370 or P/390         */
/*                                                */
xxx = 370
/* Find out where INSTALL.CMD is located */
Parse upper source . . sspec
sdrive = Filespec('Drive',sspec)
spath = Strip(Filespec('Path',sspec),'B','\')
If sdrive = 'A:' then Do
   info = SysDriveInfo('A:')
   Parse var info . . . label
   If Left(Strip(label),4)='P390' then xxx = 390
   End
Else If spath = 'P390' then xxx = 390

If xxx = 390 then Do
   card='P/390'; pname='P390'; ptitle='P/390'; ptitlee='P/390E'; end;
   Else Do
   card='P/370'; pname='P370'; ptitle='P/370'; ptitlee='';end;

Call SysCls
Say ''; Say ptitle 'Program Installation';
say ''; Say 'To continue with installation press Y';
Say '(any other key to EXIT).';
parse upper value SysGetKey('NOECHO') with key
If key<>'Y' Then Exit 1

/* check for a drive letter passed as parameter to INSTALL */
If (xx = 'FOLDER')|(xx = 'CLIENT')|(xx = 'CONFIG') then
   parse upper arg xx letter ':' dpath .
Else
   parse upper arg letter ':' dpath  .

letter = Strip(letter);
If letter='' then do
   Say '';
   If (xx='FOLDER')|(xx='CONFIG') then
     Say 'Type in the letter of the drive where the 'card' programs are installed:';
   Else
     Say 'Type in the letter of the drive where you want the 'card' programs installed:';
   Say '(Default = C )';
   parse upper value SysGetKey('NOECHO') with key
   If key='0D'x Then Do
                    path='C:\'pname;
                    letter='C';
                    end;
                Else Do
                    path=key':\'pname;
                    letter=key;
                    end;
   end
Else path=letter':\'pname;

/* Make sure the drive letter is a single, uppercase alphabetic */
If (length(letter)<>1 | Datatype(letter,'U')<>1) then Do
   Say ''
   Say "Invalid parameter: '"letter"'. It must be a valid OS/2 drive letter or 'FOLDER'."
   Say '*** Nothing installed ***'
   Exit 1;
   End;

info = SysDriveInfo(letter':')
If info = '' then do
   Say ''
   Say 'Destination disk' letter': does not exist.  Check parameters and rerun INSTALL.'
   Exit 3
   End

Call ChkOS2  /* Set variable os2rel = 2 or 3 */

If xx= 'CLIENT' then Signal Client /* Install LAN 3270 code on client PS/2 */

z=Stream(path'\AWSERRS.EXE','C','QUERY EXISTS') /* Does it exist? */
Say '';

If xx = 'FOLDER' then do
   If z='' then do
      Say 'The' ptitle 'programs can not be found in' path;
      Say 'Check the drive letter and rerun "INSTALL FOLDER".'
      exit 2
      end
   Signal Folder; /* Skip copy and just create Folder */
   end

If xx = 'CONFIG' then do
   If z='' then do
      Say 'The' ptitle 'programs can not be found in' path;
      Say 'Check the drive letter and rerun "INSTALL CONFIG".'
      exit 2
      end
   Signal Config; /* Skip copy and just update CONFIG.SYS */
   end

Call PGMcheck   /* Check to see if it is safe to copy P/370 programs */
Call CMcheck    /* Check for version of CM */

If z <> '' then do
   Call ChkP390  /* Attempt to find out the driver level */
   Say '********************** WARNING *****************************'
   Say ptitle P390_lvl 'program files are installed on drive' path;
   Say 'Do you want to back-up the existing files and install these'
   Say 'new diskettes? (press Y to continue, or N to exit).'
   Say ''
   Do until key = 'Y' | key = 'N'
      parse upper value SysGetKey('NOECHO') with key
      End
   If key = 'N' Then do
      Say '*** Nothing installed ***'
      Exit 1
      end
   Else Call Backup
   End; /* P/390 files already exist */

   Else do
   Say 'Installing' ptitle 'Program on drive' path;
   Say '========================================='
   Say ''
   End;

cdat = path'\CUSTOMER.DAT'
cust_dat = stream(cdat,'C','QUERY EXISTS')
If cust_dat = '' then do  /* Prompt user for Customer Data */
   Say ''
   Say 'In order to provide you with the best service on this product,'
   Say 'please enter the following customer identification data'
   Say 'so we can attach it to traces that you send to IBM.'
   Say ''
   Say 'Type the information requested, followed by the ENTER key.'
   Say '----------------------------------------------------------'

   prompt.1 = 'Company Name'; tag.1 = 'COMPANY'
   prompt.2 = 'Contact Name'; tag.2 = 'CONTACT'
   prompt.3 = 'E-Mail Address'; tag.3 = 'EMAIL'
   prompt.4 = 'Telephone Number'; tag.4 = 'TELEPHONE'
   prompt.5 = 'Location (City, State, Country)'; tag.5 = 'LOCATION'
   z=SysMkDir(path);
   Do n=1 to 5
      Do until line <> ''
         Say prompt.n
         Parse Pull line
         If n=1 & line = 's' then Signal Skip_DAT
         If line <> '' then cust.n = tag.n':'line
         End
      Call lineout cdat, cust.n
      End; /* Get all the lines */
   z=Stream(cdat,'C','CLOSE')  /* Close the file */
   Say 'Your data has been saved in' cdat
   Say 'To update it in the future, use any text editor.'
   Say '(Press ENTER to continue)'
   Pull stuff
   End;
Skip_DAT:

/*                                                              */
/* Prompt for disks 1 to 6 and copy all files                   */
/*                                                              */
Do n = 1 to num_disks
   disk_msg = 0; skip_disk = ''
   Do until label = pname'PROG'n
      If skip_disk = n then leave
      info = SysDriveInfo('A:')
      Parse var info . . . label
      label = Strip(label)
      If label <> pname'PROG'n then do
         If disk_msg=0 then do
           Say 'Insert the "'ptitle 'Program diskette' n'" in drive A:';
           Say 'and press ENTER to copy programs.';
           end
         Else do
            Call Beep 600,250
            Say ''
            Say 'Incorrect diskette inserted.'
            Say 'Please verify that the "'ptitle 'Program diskette' n'" is inserted in drive A.'
            Say 'Then press ENTER.';
            end
         Parse upper value SysGetKey('NOECHO') with key
         If n>3 & key='S' Then Do
            Skip_disk = n  /* Allow skip of disks 4 and 5 */
            Say '** Installation of diskette' n 'skipped.'
            Say ''
            End; /*  Skip diskette n */
         disk_msg=1
         End; /* wrong disk inserted */
      End; /* Do until label is correct */

   If skip_disk = n then iterate

   If n <= 5 then do
      Say 'COPYING' ptitle 'Programs from diskette' n 'to' path '...';
      '@ECHO ON'      /* Want to see all OS/2 commands executed */
      "XCOPY A:\*.* " path"\";
      '@ECHO OFF'
      Say ''
   End; /* Diskettes 1 thru 5 */

   If n = 4 then do  /* P390MSG diskette */
      /*                                                                  */
      /* Unzip P390MSG and LSAMON                                         */
      /*                                                                  */
 /*   Say 'Unzipping' path'\AWSPBS.ZIP to' path '...';         */
 /*   path"\PKUNZIP2 -o -d "path"\AWSPBS.ZIP" path"\ > nul:"   */
 /*   If rc <> 0 then Say '** ERROR unzipping AWSPBS.ZIP.'     */
 /*   Else z=SysFileDelete(path'\AWSPBS.ZIP')                  */

      Say 'Unzipping' path'\P390MSG.ZIP to' path '...';
      path"\PKUNZIP2 -o -d "path"\P390MSG.ZIP" path"\ > nul:"
      If rc <> 0 then Say '** ERROR unzipping P390MSG.ZIP.'
      Else z=SysFileDelete(path'\P390MSG.ZIP')

      Say 'Unzipping' path'\LSAMON.ZIP to' path '...';
      path"\PKUNZIP2 -o -d "path"\LSAMON.ZIP" path"\ > nul:"
      If rc <> 0 then Say '** ERROR unzipping LSAMON.ZIP.'
      Else z=SysFileDelete(path'\LSAMON.ZIP')

      Say ''
      End; /* P390MSG & LSAMON */

   If n = 6 then do  /* Artic/Parca diskette */
      /*                                                                  */
      /* Unzip PARCA and Artic960 support                                 */
      /*                                                                  */
/**   Say 'Do you want to install Artic960 code for PARCA channel support?' */
/**   Say 'Press Y key to install, or N key to skip this step.';            */
/**   Say ''                                                                */
/**   parse upper value SysGetKey('NOECHO') with key                        */
/**   If key='Y' Then Do                                                    */
         "CALL A:\INSTICE.CMD" letter
/**      End;                                                               */
/**   Else Say 'To install Artic960 device driver code in the future, run' path'\INST960.CMD' */
      End; /* Artic/Parca */

   End; /* Install all disks */


If cmlevel <> 'NONE' then do
   /* Code to insure there are LOCAL 3270 LTs  */
   path"\AWSCMLT /SET"   /* Set LTs to HOST LOCAL LOCAL LOCAL LOCAL */
   End;                  /* if not already set to something (no INI entry) */

Say ''
Say 'Installation of' card 'L.I.C. files.'
Say '==================================='
Say ''

Say 'Insert the "'ptitle 'Advanced Diagnostics and Option diskette"';
If ptitlee <> '' then
  Say '    or the "'ptitlee 'Advanced Diagnostics and LIC diskette"';

Say 'in drive A: and then press ENTER.';
Say ''
parse upper value SysGetKey('NOECHO') with key
If key='S' Then do
   Say '*** Installation of L.I.C. files skipped. ***'
   Signal Skip_M
   end

Disk_M:
info = SysDriveInfo('A:')
Parse var info . . . label
If Strip(label) <> pname' DIAG' then do
   Call Beep 600,250
   Say 'Incorrect diskette inserted.'
   Say 'Please verify that the "'ptitle 'Advanced Diagnostics and Option diskette"';
   If ptitlee <> '' then
   Say '                or the "'ptitlee 'Advanced Diagnostics and LIC diskette"';
   Say 'is inserted in drive A: and then press ENTER.';
   Say '(any other key to skip this install step)';
   Say ''
   parse upper value SysGetKey('NOECHO') with key
   If key='S' Then Do
      Say '*** Installation of L.I.C. files skipped. ***'
      Signal Skip_M
      end
   Signal Disk_M
   end

"CALL A:\INSTALL" letter
If rc<>0 then Say '*** Installation of L.I.C. files skipped. ***'

Skip_M:
Say ''
/*
Say 'Remove the diskette from drive A:'
Say 'and then press ENTER or any key to continue.'
      parse upper value SysGetKey('NOECHO') with key
Say ''
*/
/*------------------------------------------------------------------*/
/* Change drive letters in CONFIG.AWS to match actual install drive */
/* ================================================================ */
Call ChngSamp;

/*------------------------------------------------------------------*/
/* Optionally update user's CONFIG.SYS                              */
/* ================================================================ */
Say ''
Say 'Do you want the' card 'statements added to CONFIG.SYS  (Y | N)?'
parse upper value SysGetKey('NOECHO') with key
If key='N' Then Do
   Say ''
   Say '*------------------------------------------------------------------*'
   Say '* You MUST manually edit CONFIG.SYS and add the' card 'statements   *'
   Say '* that are shown in the sample' path'\CONFIG.AWS file. Be sure    *'
   Say '* to read section "A4. Updating CONFIG.SYS" in' path'\README.AWS. *'
   Say '*------------------------------------------------------------------*'
   Say ''
   End;
Else Do
   Call UpConfig;
   Say '*---------------------------------------------------------------------*'
   Say '* Your CONFIG.SYS may still need updating to make other P/390-related *'
   Say '* device drivers active.  Be sure to read section "A4. Updating       *'
   Say '* CONFIG.SYS" in' path'\README.AWS.                                  *'
   Say '*---------------------------------------------------------------------*'
   End;
Say ''
Say 'Press ENTER or any key to continue.'
      parse upper value SysGetKey('NOECHO') with key
Say ''

/*------------------------------------------------------------------*/
/* Create P/370 or P/390 Program folder and icons                   */
/* ================================================================ */
Folder:

'@ECHO ON'      /* Want to see all OS/2 commands executed */
/* Re-Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs
f=0

Say ''
Say 'Making a' ptitle 'Program folder.';
Say '====================================='
Say ''
/*--------------------------------*/
/* Create a P/370 or P/390 folder */
/*--------------------------------*/
classname='WPFolder'
title=ptitle
location='<WP_DESKTOP>'
oid='OBJECTID=<'pname'1_FOLDER>;'
win='MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;'
icon='ICONVIEW=FLOWED;ICONFILE='path'\'pname'.ICO;'
/* P/390 version 2.1 had open and closed folder icons
   If os2rel='3' then
   icon='ICONVIEW=FLOWED;ICONFILE='path'\'pname'FOLD.ICO;ICONNFILE=1,'path'\'pname'OPEN.ICO;'
Else
   icon='ICONVIEW=FLOWED;ICONFILE='path'\'pname'.ICO;'
*/
setup=oid||win||icon
Call BldObj

If f=0 then do
   /* Place the program objects in the folder in order */
   /* IPL  370       */
   /* END 370        */
   /* CONFIGURATOR   */
   /* MANOPS         */
   /* AWSTRACE       */
   /* AWSSDUMP       */
/* Icons are named xxxx.ico for P/370 or xxxx9.ico for P/390 */
If card = 'P/390' then iii = '9'; else iii = '';
If os2rel>='3' then do
   Call adddmp
   Call addtrc
   Call addman
   Call addcfg
   Call addend
   Call addipl
   End; /* OS/2 3.x add objects */
Else Do
   Call addipl
   Call addend
   Call addcfg
   Call addman
   Call addtrc
   Call adddmp
   End; /* OS/2 2.x add objects */

End; /* filling the folder */
Say ''

If f > 0 then do
  Say pname 'Program installation completed, but errors'
  Say 'were encountered during the creation of the' card 'Folder.'
  Say ''
  Say 'If a 'pname'1_FOLDER already exists:'
  Say ' - Delete the' ptitle 'folder and its contents'
  Say ' - Insert the "'ptitle 'Program diskette 1" in drive A:';
  Say ' - Type     A:INSTALL FOLDER   '
  Say ''
  end

Else Say pname 'Program installation complete.'
If back_dir <> '' then do
    Say 'A previous version was backed up to' back_dir
    Say 'To go back to this level use' path'\REGRESS'
    End

Say ''
Say '*------------------------------------------------------------------*'
Say '* Note: Be sure to print and read the README.AWS file which        *'
Say '*       contains important additional installation information.    *'
Say '*------------------------------------------------------------------*'
Say ''
Say 'Remember to remove the diskette from drive A:'

Exit 0

/*===========================================================================*/
/*    S U B R O U T I N E S                                                  */
/*===========================================================================*/

/*---------------------------------------------------------------------------*/
/* Client code Install */
/*---------------------------------------------------------------------------*/
Client:

Call PGMcheck   /* Check to see if it is safe to copy P/370 pgms */
Call CMcheck    /* Check for version of CM */

Say 'Installing' pname '3270 Client Program on drive' path;
Say '============================================================';
Say ''
info = SysDriveInfo('A:')
Parse var info . . . label
If Strip(label) <> pname'PROG1' then do
   Say 'Insert the "'ptitle 'Program diskette 1" in drive A:';
   Say 'and press ENTER to copy programs (any other key to EXIT).';
   parse upper value SysGetKey('NOECHO') with key
   If key<>'0D'x Then Do
      Say ''
      Say '*** Nothing installed ***'
      Exit 1
      end
   End

Disk_1c:
info = SysDriveInfo('A:')
Parse var info . . . label
If Strip(label) <> pname'PROG1' then do
   Call Beep 600,250
   Say ''
   Say 'Incorrect diskette inserted.'
   Say 'Please verify that the "'ptitle 'Program diskette 1" is inserted in drive A.'
   Say 'Then press ENTER (any other key to EXIT).';

   parse upper value SysGetKey('NOECHO') with key
   If key<>'0D'x Then do
      Say ''
      Say '*** Nothing installed ***'
      Exit 1
      end
   Signal Disk_1c
   end

Say ''
Say 'COPYING' ptitle '3270 Client Programs from A: to' path '...';
    "XCOPY A:\awscmlt.*" path"\";
    "COPY A:\ltrename.exe" path"\";
 /* "COPY A:\awsdftn.dll" path"\"; */
 /* "COPY A:\awsdfts.dll" path"\"; */
    "COPY A:\awsntca.dll" path"\";
    "COPY A:\awsstca.dll" path"\";
 /* "COPY A:\awststcm.exe" path"\"; get from diskette 4 */
Say ''
/*----------------------------------------------------*/
/*  Place the AWSCMLT program object onto the desktop */
/*----------------------------------------------------*/
f=0
classname='WPProgram'
title='Update 3270 LT Sessions'
location='<WP_DESKTOP>'

oid='OBJECTID=<AWSCMLT>;';
pgmname='EXENAME='path'\AWSCMLT.EXE;';
ptype='PROGTYPE=PM;';
win='MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;              ';
icon='ICONFILE='path'\AWSCMLT.ICO;'
dir='STARTUPDIR='path';';
close='NOAUTOCLOSE=;';
/* parms='PARAMETERS=';*/

setup=ptype||pgmname||oid||win||icon||close||dir
Call BldObj     /* Add the icon */
Say ''
Call UpConfig;  /* Update config.sys pathnames */
Say ''
Say ptitle '3270 Client Program installation complete.'

Exit 0


/*--------------------------------------------------------------------*/
/*   S U B R O U T I N E S                                            */
/*--------------------------------------------------------------------*/
Addipl:
   /*----------------------------------------------*/
   /*  Place the IPL program object into the folder */
   /*----------------------------------------------*/
   classname='WPProgram'
   title='IPL' card
   location='<'pname'1_FOLDER>'

   oid='OBJECTID=<'pname'1_IPL>;';
   pgmname='EXENAME='path'\IPL.CMD;';
   ptype='PROGTYPE=WINDOWABLEVIO;';
If iii = '9' then
   win='MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;';
Else
   win='MINIMIZED=YES;MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;';
   icon='ICONFILE='path'\IPL'iii'.ICO;'
   dir='STARTUPDIR='path';';
   close='NOAUTOCLOSE=;';
   /* parms='PARAMETERS='; */

   setup=ptype||pgmname||oid||win||icon||close||dir
   Call BldObj
Return;

Addend:
   /*------------------------------------------------*/
   /*  Place the END program object into the folder  */
   /*------------------------------------------------*/
   classname='WPProgram'
   title='End' card
   location='<'pname'1_FOLDER>'

   oid='OBJECTID=<'pname'1_END>;';
   pgmname='EXENAME='path'\AWSEND.CMD;';
   ptype='PROGTYPE=WINDOWABLEVIO;';
   win='MINIMIZED=YES;MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;';
   icon='ICONFILE='path'\AWSEND'iii'.ICO;'
   dir='STARTUPDIR='path';';
   close='NOAUTOCLOSE=;';
   If cmlevel = 'NONE' then parms='PARAMETERS= /k';

   setup=ptype||pgmname||oid||win||icon||close||dir||parms
   Call BldObj
Return;

Addcfg:
   /*--------------------------------------------------*/
   /*  Place the CONFIG program object into the folder */
   /*--------------------------------------------------*/
   classname='WPProgram'
   title=card 'Configuration'
   location='<'pname'1_FOLDER>'

   oid='OBJECTID=<'pname'1_CONFIG>;';
   pgmname='EXENAME='path'\AWSCFG.CMD;';
   ptype='PROGTYPE=WINDOWABLEVIO;';
   win='MAXIMIZED=YES;MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;';
   icon='ICONFILE='path'\AWSCFG'iii'.ICO;'
   dir='STARTUPDIR='path';';
   close='NOAUTOCLOSE=;';
   parms='PARAMETERS= S=1';

   setup=ptype||pgmname||oid||win||icon||close||dir||parms
   Call BldObj
Return;

Addman:
   /*--------------------------------------------------*/
   /*  Place the MANOPS program object into the folder */
   /*--------------------------------------------------*/
   classname='WPProgram'
   title=card 'Manual Operations'
   location='<'pname'1_FOLDER>'

   oid='OBJECTID=<'pname'1_MANOPS>;';
   pgmname='EXENAME='path'\MANOPS.EXE;';
   ptype='PROGTYPE=PM;';
   win='MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;';
   icon='ICONFILE='path'\MANOPS'iii'.ICO;'
   dir='STARTUPDIR='path';';
   close='NOAUTOCLOSE=;';
   /* parms='PARAMETERS=';*/

   setup=ptype||pgmname||oid||win||icon||close||dir
   Call BldObj
Return;

Addtrc:
   /*--------------------------------------------------*/
   /*  Place the TRACE program object into the folder */
   /*--------------------------------------------------*/
   classname='WPProgram'
   title=card 'I/O Trace'
   location='<'pname'1_FOLDER>'

   oid='OBJECTID=<'pname'1_TRACE>;';
   pgmname='EXENAME='path'\AWSTRACE.EXE;';
   ptype='PROGTYPE=PM;';
   win='MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;';
   icon='ICONFILE='path'\AWSTRCE'iii'.ICO;'
   dir='STARTUPDIR='path';';
   close='NOAUTOCLOSE=;';
   /* parms='PARAMETERS='; */

   setup=ptype||pgmname||oid||win||icon||close||dir
   Call BldObj
Return;

Adddmp:
   /*------------------------------------------------*/
   /*  Place the DUMP program object into the folder */
   /*------------------------------------------------*/
   classname='WPProgram'
   title=card' Snap Shot Dump'
   location='<'pname'1_FOLDER>'

   oid='OBJECTID=<'pname'1_DUMP>;';
   pgmname='EXENAME='path'\AWSSDUMP.EXE;';
   ptype='PROGTYPE=WINDOWABLEVIO;';
   win='MINIMIZED=YES;MINWIN=DESKTOP;VIEWBUTTON=MINIMIZE;CONCURRENTVIEW=NO;';
   icon='ICONFILE='path'\AWSDUMP'iii'.ICO;'
   dir='STARTUPDIR='path';';
   close='NOAUTOCLOSE=;';
   /* parms='PARAMETERS='; */

   setup=ptype||pgmname||oid||win||icon||close||dir
   Call BldObj
Return;


/*---------------------------------------------------------------------------*/
/* Build Object */
/*---------------------------------------------------------------------------*/
BldObj:
call charout ,'Adding: 'title

result = SysCreateObject(classname, title, location, setup)

If result=1 Then call charout ,'... Object created.'
Else do
     call charout ,'... ERROR: Object not created.'
     f=f+1; /* count failures */
     end

Say '';
Return

/*---------------------------------------------------------------------------*/
/* Check to see what level of OS/2 is installed                       */
/*---------------------------------------------------------------------------*/
ChkOS2:
/* Find the boot drive  */
Bdrive=filespec('DRIVE',value('COMSPEC',,'OS2ENVIRONMENT'))
syslvl=Bdrive'\OS2\INSTALL\SYSLEVEL.OS2'
file=charin(syslvl,1,200)           /* Check version of OS/2  */
type =  Substr(file,87,2)
level =  Left(c2x(Substr(file,41,2)),2) /* Check only first 2 digits */
os2rel = left(level,1); os2ver = Substr(level,2,2)
return;

/*---------------------------------------------------------------------------*/
/* Check to see if either P/370 code or our CM DLLs are running */
/*---------------------------------------------------------------------------*/
PGMcheck:
/* Check the P/370 CM interface DLLs  */
If Running(path'\awsntca.dll'),
 | Running(path'\awsstca.dll')
/* Running(path'\awsdftn.dll') */
/* Running(path'\awssfts.dll') */
   Then do
   Say '********************** ERROR *******************************'
   Say 'The Communications Manager 3270 DFT sessions must be STOPPED'
   Say 'before you can INSTALL the' ptitle 'Program.'
   Say '*** Nothing installed ***'
   Exit 13
   end

/* Check the P/370 I/O subsystem */
If Running(path'\awsutil.dll') then do
   Say '********************** ERROR *****************************'
   Say 'The' ptitle 'programs on drive' path 'may be running.';
   Say 'You must select END' card 'icon and then rerun INSTALL.'
   Say ''
   Say 'If INSTALL still fails, then re-boot OS/2 and try again.'
   Say '*** Nothing installed ***'
   Exit 13
   end

/* Check for other P/370 programs */
n.1='MANOPS.EXE'; n.2='AWSCNF.EXE'; n.3='AWSTRACE.EXE';
Do i=1 to 3
   If Running(path'\'n.i) then do
      Say '********************** ERROR *****************************'
      Say 'The' n.i 'program on drive' path 'is running.';
      Say 'You must stop this program and then rerun INSTALL.'
      Say '*** Nothing installed ***'
      Exit 13
      end
   End;  /* check other pgms */
Return;

Running: procedure
Arg fn
If Stream(fn,'C','QUERY EXISTS')<>''then do  /* Does it exist? */
   y=Stream(fn,'C','OPEN')   /* Open for read & write */
   z=Stream(fn,'C','CLOSE')  /* Close the file */
   End
   If y='NOTREADY:32' then run=1
   else run=0
Return run;


/*---------------------------------------------------------------------------*/
/* Check to see which version of CM is installed (if any)             */
/*---------------------------------------------------------------------------*/
CMCheck:
/* Find the boot drive  */
Bdrive=filespec('DRIVE',value('COMSPEC',,'OS2ENVIRONMENT'))
config=Bdrive'\CONFIG.SYS'
Call Stream config,'C','CLOSE'
/* Search config.sys file for LIBPATH statement */
Do i=1 by 1 While Lines(config)
   line.i = Linein(config)
   Parse upper var line.i rem . 'LIBPATH=' lpath
   If lpath <> '' then leave
   End
Call Stream config,'C','CLOSE'

Parse var lpath before '\CMLIB\DLL' .   /* CM's drive letter */
cmdrive = Right(before,2)
syslvl=cmdrive'\CMLIB\SYSLEVEL.ACS'
file=charin(syslvl,1,200)           /* Check version of CM  */
type =  Substr(file,87,2)
level =  Left(c2x(Substr(file,41,2)),2) /* Check only first 2 digits */
rel = left(level,1); ver = Substr(level,2,2)
Select;
   When type = 'at' then do  /* cmlevel = 'ES'; */
      Say '**************************************************************************'
      Say 'OS/2 Extended Services Version 1.0 is not supported with the' card'!!     '
      Say '**************************************************************************'
      Say 'You must upgrade to CM/2 Version 1.11 and then rerun the' card 'INSTALL command.'
      Exit 2
      end
   When (type = '/2')&(level=11) then cmlevel= 'CM2';
   When (type = '/2')&(level=10) then do
      Say '********************************************************************************'
      Say 'OS/2 Communications Manager/2 Version 1.00 is incompatable with the' card'!!     '
      Say '********************************************************************************'
      Say 'You must upgrade to CM/2 Version 1.1 and then rerun the' card 'INSTALL command.'
      Exit 2
      end
   Otherwise do
 /*   Say '*********************************************'
      Say 'OS/2 Communications Manager is not installed.'
      Say '*********************************************'
      Say 'Are you going to use TCP/IP telnet sessions for the local 3270 consoles? (Y|N)'
      Say '(e.g. the System Operator console).'
         say ''
      parse upper value SysGetKey('NOECHO') with key
      If key<>'Y' Then Do
         Say card 'installation cannot complete. You must first install Communications'
         Say 'Manager 1.11 for WARP and then rerun the' card 'INSTALL command.'
         Exit 3
         end  */
      cmlevel= 'NONE'
      End;
   End;

Return; /* variable cmlevel = ES or CM2 */

/*--------------------------------------------------------------------*/
/* Change the drive letters in CONFIG.AWS sample file                 */
/*--------------------------------------------------------------------*/
ChngSamp:
'@ECHO OFF'     /* Execute OS/2 commands quietly */
iaws=letter':\'pname'\CONFIG.AWS' /* sample config location */
z=Stream(iaws,'C','QUERY EXISTS') /* Does it exist? */
If z = '' then Do  /* This should never happen */
   Say iaws 'not found. Check for correct installation.'
   Signal Folder  /* Go to next step of install */
   End;
oaws=SysTempFileName(letter':\'pname'\TEMP.???') /* temporary work file */
/*                                       */
/*  Read in CONFIG.AWS file              */
/*                                       */
config_aws=charin(iaws,1,99999);
If path = 'C:\P370' then return   /* No changes necessary, but need file */
                             /* in variable for UpConfig subroutine later */
lenc = length(config_aws)
Parse upper var config_aws zz
n=1

/*                                                                    */
/*  Search for C:\P370 and replace with drive letter and path         */
/*                                                                    */
Do until n>=lenc
   x=Pos('C:\P370',zz,n)  /* Search for C:\P370 **Do not alter this** */
   If x<> 0 then do
      config_aws=overlay(path,config_aws,x,7) /* replace with d:\P3n0   */
      n=x+7               /* skip past found string */
      end
   Else leave
   end
/*                                    */
/*  Write out the modified file       */
/*                                    */
x=charout(oaws,config_aws);
call lineout oaws           /* Close output file */
call lineout iaws           /* Close input file */
"COPY" oaws iaws  /* Copy new file over the old file */
"ERASE" oaws
Return;

/*--------------------------------------------------------------------*/
/* For Client PC and P370:                                            */
/* - Add d:\P370; to the three paths in CONFIG.SYS                    */
/*   variable "path" contains drive and subdir to be added            */
/*                                                                    */
/* For P370 only:                                                     */
/* - Add AWS device driver statements                                 */
/* - Add d:\P370;C:\RIC\BIN; to beginning of all three PATHs          */
/*--------------------------------------------------------------------*/
UpConfig:

/* Find the boot drive  */
Bdrive=filespec('DRIVE',value('COMSPEC',,'OS2ENVIRONMENT'))
config=Bdrive'\CONFIG.SYS'
ricbpath='C:\RIC\BIN'  /* For Artic/960 PARCA channel support */

/* Read in entire config.sys file */
Do i=1 by 1 While Lines(config)
   line.i = Linein(config)
   End
Call Stream config,'C','CLOSE'
lines = (i-1)    /* number of lines read */
If lines = 0 then do
   Say 'NOTE:' config 'was not found so it cannot be updated.'
   Signal Updone
   End

/*                                         */
/*  Update all 3 PATH lines in CONFIG.SYS  */
/*                                         */
parm.1 = 'LIBPATH='; parm.2 = 'SET PATH='; parm.3 = 'SET DPATH='; pup=0;
Do j=1 to 3
   Do i=1 by 1 Until ppath <> ''
      Parse upper var line.i . VALUE(parm.j) ppath
      If i > lines then do
         Say parm.j 'not found!  CONFIG.SYS cannot be updated.'
         Signal Updone
         end
      End

   /*  See if d:\P370; is already at beginning of path    */
   sec=0
   semi=Pos(';',ppath)  /* What is the first subdir in path? */
   first=Strip(Substr(ppath,1,semi))
   If first ='.;' then  /* Is it the "dot" ? */
      do       /* Yes, skip to next subdir */
      sec=Pos(';',ppath,semi+1)  /* What is second subdir? */
      first=Strip(Substr(ppath,semi+1,sec-semi))
      End

   /* If P370 path is already first, then don't add or delete anything */
   If first <> path';'ricbpath';' then do /* d:\P370;C:\RIC\BIN; not there */
   /*  Delete all occurences of x:\P370; from anywhere in path      */
      Do until pp370 = 0
         pp370 = Pos(':\'pname';',ppath)
         If pp370 = 0 then leave
         ppath = Substr(ppath,1,pp370-2)||Substr(ppath,pp370+7)
         end
   /*  Delete all occurences of C:\RIC\BIN; from anywhere in path      */
      If xx <> 'CLIENT' then Do until ppric = 0
         ppric = Pos(ricbpath,ppath)
         If ppric = 0 then leave
         ppath = Substr(ppath,1,ppric-1)||Substr(ppath,ppric+11)
         end
   /* OK, now actually put d:\P370;C:\RIC\BIN; at front of path  */
      addpath = path';'ricbpath';'
      If xx = 'CLIENT' then addpath = path';'
      If sec <> 0 then do   /* "dot" was first */
         line.i = parm.j'.;'addpath||Substr(ppath,semi+1)  /* Insert after "dot" */
         end
      Else do
         line.i = parm.j||addpath||ppath  /* Insert as first path */
         end
      pup=j
      End;
   End; /* Update all three path lines */

/*                                                       */
/* See if a valid P/370 Device Driver is in CONFIG.SYS   */
/*                                                       */
If xx <> 'CLIENT' then do /* Installing the P/370 card */
   add=1  /* Set to 0 if a valid device driver statement is found */
   Do i=1 by 1 to lines
      ndd = Pos(path'\AWS370DD.SYS',Translate(line.i))   /* install disk letter */
      odd = Pos(':\'pname'\AWS370DD.SYS',Translate(line.i)) /* non-install disk letter */
      pdd = Pos(':\P370\AWS370DD.SYS',Translate(line.i)) /* installing P/390 over P/370 */
      If ndd > 0 then do
         pre = Substr(line.i,1,ndd-1)
         Parse Upper Var pre rem device equal .
         If rem = 'REM' then nop  /* Ignore Remarked out statement */
           Else,           /* Is this a valid device statement ? */
           If (rem = 'DEVICE' & device = '='),
             |(rem = 'DEVICE='),
             |(device = 'DEVICE' & equal = '='),
             |(device = 'DEVICE='),
             then add=0    /* valid device driver found */
         end;
         /* Remark out any "old" P/370 device driver statement  */
         /* if it specifies another drive letter. Even if already REM'd out! */
         Else If (odd > 0)|(pdd > 0) then line.i = 'REM '||line.i

       End;  /* i=1 to lines */
   End; /* not client */

/*                                             */
/* Write out a new CONFIG.SYS, if necessary    */
/*                                             */
If (pup>0)|(add=1) then do  /* Skip if no changes necessary */
   /* Save the old CONFIG.SYS and replace it with the new one */
   "@ECHO OFF"
   sav_config = SysTempFileName(Bdrive'\CONFIG.?0?')
   "COPY" config sav_config
   temp = SysTempFileName(Bdrive'\TEMP.???')
   Do i=1 to lines
      Call Lineout temp,line.i
      End
   If add=1 then do  /* Add the P/370 statements at bottom of file */
   /* Remember we read CONFIG.AWS into variable config_aws earlier */
      Parse var config_aws . 'REM+ ' . '0D0A'x rest
      Call Lineout temp,rest
      End;
   Call Lineout temp  /* Close output file */
   "COPY" temp config /* Copy new file over old file */
   "ERASE" temp

   Say '*------------------------------------------------------------------------*'
   Say '*' config 'has been updated. Your old file is saved as' sav_config
   Say '* You must reboot your PC for the updates to take effect.'
   Say '*------------------------------------------------------------------------*'
   End;
Else Say 'CONFIG.SYS was not changed.'
Updone:
return;


/*---------------------------------------------------------------------------*/
/* Check to see what level of P/390 is installed                      */
/*---------------------------------------------------------------------------*/
ChkP390:
syslvl=path'\SYSLEVEL.AWS'
dd = Stream(syslvl,'C','QUERY EXISTS') /* Is there a SYSLEVEL ? */
If dd = '' then do
   P390_lvl = '' /* Not found */
   Return
   End;

file=charin(syslvl,1,200)           /* Check version of P/390 X.YY.Z */
Call Stream syslvl,'C','CLOSE'
num1  = c2x(Substr(file,41,2))
num2  = c2x(Substr(file,150,1))
P390rel = Substr(num1,1,1)                     /* X.  .   */
P390lvl = Substr(num1,2,1)||Substr(num1,4,1)   /*  .YY.   */
If Substr(num1,2,1) = '0' then P390lvl = Substr(num1,4,1) /* Strip leading zero */

If num2 = 'B1' then     /* A beta fix level is installed */
   P390mod = x2c(e1)
   /* Note: To create a "Beta" SYSLEVEL.AWS, replace the X'01' byte at offset X'96' with X'B1'  */
   /*       This is ASCII for a grey block (), but SYSLEVEL.EXE displays it as a beta ()  */
Else P390mod = Substr(num2,2,1)                /*  .  .Z  */

P390_lvl = P390rel'.'P390lvl'.'P390mod
Return;


/*---------------------------------------------------------------------------*/
/* Backup existing P/390 Program code                                        */
/*---------------------------------------------------------------------------*/
Backup:
Old_xx = Left(New_level,2) - 1         /* 210 -> 21 - 1 = 20 */
back_dir = letter':\'pname'R'old_xx    /* e.g. D:\P390R20 */
/* Move these lines to top ..... */
  r_name = 'REGRESS.CMD' /* If CMD file has this name, we are Regressing */
  Parse upper Source . . srcname .  /* Info on the program as called */
  sletter = Filespec('Drive',srcname) /* e.g. C:            */
  ssubd = Filespec('Path',srcname)    /* e.g. \P390\        */
  sname = Filespec('Name',srcname)    /* e.g. INSTALL.CMD or REGRESS.CMD */
  spath = sletter||ssubd              /* e.g. C:\P390\      */
  Parse var srcname cmdname '.' .     /* e.g. C:\P390\INSTALL  */

/*                                               */
/* Does the backup subdirectory already exist?   */
/*                                               */
rc=SysRmDir(back_dir)
/* Test the subdirectory by removing the name */
Select;
   When rc = 0 then nop;   /* OK - it was empty */
   When rc = 3 then nop;   /* OK - no such subdirectory */
   When rc = 5 then do     /* BAD - there are files in backup subdir */
      Say 'Files already exist in subdirectory' back_dir
      Say 'Can not back up the' ptitle 'Program files.'
      Say '*** Nothing installed ***'
      Exit rc
      End;
   When rc = 16 then do    /* BAD - it exists and is the current directory in some window */
      Say back_dir 'already exists AND is the current directory in some window.'
      Say 'Remove this directory and run INSTALL again.'
      Say '*** Nothing installed ***'
      Exit rc
      End;
   Otherwise do            /* BAD - no idea what is wrong  */
      Say 'Can not back up the' ptitle 'Program files (RMDIR RC = 'rc').'
      Say 'Remove the' back_dir 'directory and run INSTALL again.'
      Say '*** Nothing installed ***'
      Exit rc
      End;
   End; /* Select */

/*                                               */
/* Backup the user's current P/390 subdirectory  */
/*                                               */
Say 'Backing up your current' ptitle 'files from' path 'to' back_dir'...'
"XCOPY" path back_dir"\ /S >nul:"
If rc = 0 then Say 'Your current' ptitle 'directory' path 'has been backed up to' back_dir
   Else do
   Say 'Cannot backup your current' path 'subdirectory (RC='rc').'
   Say 'You must'
   Say '         1. Manually backup the' ptitle 'Program software'
   Say '         2. Erase all the files in' path '(or rename the subdirectory)'
   Say '         3. Run this INSTALL again.'
   Say '*** Nothing installed ***'
   Exit rc
   End;
Say ''

/*                                                     */
/* Erase all the files in the current P/390 directory  */
/*   and erase and delete any subdirectories under it. */
/*                                                     */
"ATTRIB" path"\*.* -r -h -s 1>nul 2>&1"  /* Take off all attributes */
"ERASE" path "/N"                        /* Erase the files */
oldcount=queued()                             /* anything in the rex queue? */
"DIR" path"\* /a:d /b 2>nul 1| rxqueue /lifo" /* List subdirectories, if any */
Do queued()-oldcount  /* Erase and delete subdirectories, one by one */
   pull subdir
   if subdir<>'' then do
      subdir = path"\"subdir
      "ATTRIB" subdir"\*.* -r -h -s 1>nul 2>&1" /* Take off all attributes */
      "ERASE" subdir "/N"                       /* Erase the files */
      "RD" subdir                               /* Remove the subdirectory */
      End;
   End; /* All subdirectories under /P390  */

/* Copy back any existing AWSUSER.CMD file */
auser = back_dir'\AWSUSER.CMD'
If stream(auser,'C','QUERY EXISTS') <> '' then do
   "COPY" auser path "> nul"
   Say 'NOTE: User exit AWSUSER.CMD was found in 'path' and kept.'
   end;
/* Copy back any existing CUSTOMER.DAT file */
cdat = back_dir'\CUSTOMER.DAT'
cust_dat = stream(cdat,'C','QUERY EXISTS')
If cust_dat <> '' then "COPY" cdat path "> nul"

return;

/*---------------------------------------------------------------------------*/
/* For Marty                                                                 */
/*---------------------------------------------------------------------------*/
Config:
Call ChngSamp
Call UpConfig
Exit
