/* P/370 & P/390 OS/2 IPL Startup commands (ver 2.5.0)            4/24/98 */
/*                                                                        */
/*  Format:                                                               */
/*   IPL ipladdr ipltype auto /C cache /ID cpuid /MAP devmap /NOASK       */
/*                                     /PARM loadparm /MODE 370 | ESA     */
/*                                     /NOCLKCLR /NOCLKGET /NOCLKSET      */
/*               CLEAR   CKPT                                             */
/*               NOCLEAR WARM                                             */
/*               NOIPL   NOAUTO                                           */
/*                                                                        */
/* There are three exit calls to optional, customer-provided AWSUSER.CMD  */
/* that is found via the OS/2 PATH. (do not put it in /P390 subdirectory) */
/*  1. Before IPL (to start a device manager)                             */
/*     - Parameters are the word "BEFORE" followed by the arguments that  */
/*       IPL.CMD was passed.                                              */
/*                                                                        */
/*  2. After IPL (to start other programs)                                */
/*     - Parameters are the word "AFTER" followed by the arguments that   */
/*       IPL.CMD was passed.                                              */
/*                                                                        */
/*  3. After END P/390 (clean up). This actually happens in AWSEND.CMD    */
/*     - Parameters are the word "END" followed by the arguments that     */
/*       AWSEND.CMD was passed.                                           */
/*                                                                        */
/*------------------------------------------------------------------------*/
/* Changes:                                                               */
/* 4/25/95 2.0   GA version                                               */
/* 2/26/96 2.1   Add telnet port on aws3274, but disabled; add new device */
/*               mgrs: awspbs, lsap*, aws34x0.                            */
/* 8/12/96 2.2   Make telnet port default = 7490; switch to P390          */
/*               subdirectory during IPL; comment out 9346, 5080 & fep.   */
/* 10/4/96 2.3   Parca support; device mgr parms extracted from DEVMAP;   */
/*               Print out chan.trc contents.                             */
/* 11/07/96 2.3  Determine Parca card numbers from device entries         */
/*  3/12/97 2.3+ Fix parsing of Parca parameters when no card # given     */
/*  4/07/97 2.3+ Fix awspbs dmparms line & add call to TNSTART.CMD        */
/* 7/09/97 2.3.3 Pop-up message if nonzero RC from AWSIPL.                    */
/*               Make Parca card default to 0 if first character is not 0-7   */
/*               Support /NOCLKCLR, /NOCLKGET, /NOCLKSET                      */
/* 10/3/97 2.3.3 Fix lcs3172 dmparms line; Add dmstart for ISITAPE manager.   */
/*               Add /SIO and /FLOAT to AWSSAD. OS/2 environment variable can */
/*               be set to override these defaults. e.g. SET AWSSAD=/SIO 100  */
/* 11/3/97 2.3.3 Add user exits. See comments above.                          */
/* 11/12/97 2.4  Fix default for awsica parms in getdmparms                   */
/* 1/29/98 2.4.1 Accept /NOCLKPUT same as /NOCLKSET                           */
/* 4/24/98 2.5   Start AWSTRCSP if trace on, allow options in CHAN.TRC        */
/*               Create AWSABEND.LST file                                     */
/*               Replace "ERASE" with SysFileDelete & use Stream Close        */
/*                                                                            */
/*                                                                            */
trace o;
'@ECHO OFF';

/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/*  Determine if this is a P/370 or P/390         */
Parse upper source . . sspec
spath = Strip(Filespec('Path',sspec),'B','\')
sdrive = Filespec('Drive',sspec)
Select;
   When spath = 'P390' then do
      card='P/390'; pname='P390'; ptitle='P/390';end;
   When spath = 'P370' then do
      card='P/370'; pname='P370'; ptitle='P/370';end;
   Otherwise do
      msg = 'IPL.CMD must be run from either the \P390 or \P370 subdirectory.'
      Signal xitmsg;
      End
   End; /* Select */
x=Setlocal()          /* Save current environment */
saved = Directory()   /* Save current drive and subdirectory */
If saved = sdrive'\'spath then nop  /* Already there */
Else do
   sdrive       /* Change to IPL.CMD's drive */
   "CD \"spath  /* Change to its sundirectory */
   End

/*------------------------------------------------------------------*/
/*   Parse the options                                              */
/*------------------------------------------------------------------*/
Parse upper arg main
ipladdr=''; auto='CKPT'; ipltype=''; devmap=''; mode=''; cache='';
id=''; parm=''; stop=''; ask='ASK'; clk='';                           /* CLK */
do i=1 to words(main);
   k=word(main,i);
   select;
     when datatype(k,'x') & length(k)=3 then ipladdr=k;
     when k           ='WARM'        then auto='WARM';
     when k           ='CKPT'        then auto='CKPT';
     when k           ='CLEAR'       then ipltype='CLEAR';
     when k           ='NOCLEAR'     then ipltype='NOCLEAR';
     when k           ='NOIPL'       then ipladdr='NOIPL';
     when k           ='NOAUTO';     then auto   ='';
     when k           ='XAMODE'      then mode='XAMODE';
     when k           ='ESAMODE'     then mode='ESAMODE';
     when k           ='STOP'        then stop='STOP';
     when k           ='/NOASK'      then ask='NOASK';
     when k           ='NOASK'       then ask='NOASK'; /* accept either form */
     when k           ='/ASK'        then ask='ASK';   /* To match AWSEND */
     when k           ='ASK'         then ask='ASK';   /* accept either form */
     when k           ='/NOCLKCLR'   then clk=clk k;                  /* CLK */
     when k           ='/NOCLKSET'   then clk=clk k;                  /* CLK */
     when k           ='/NOCLKPUT'   then clk=clk '/NOCLKSET';        /* CLK */
     when k           ='/NOCLKGET'   then clk=clk k;                  /* CLK */
/* Process "/" options that have arguments         */
     when k           ='/MODE'       then do;
       i=i+1;
       mode =  word(main,i);
       If Wordpos(mode,'370 XA ESA')>0
          then mode = mode'MODE';
          else do
             xrc=3
             msg= 'Invalid IML mode "'mode'" specified.'
             Signal xitmsg;
             end;
       end;
     when k           ='/PARM'       then do;
       i=i+1;
       parm = 'PARM' word(main,i);
       end;
     when k           ='/MAP'        then do;
       i=i+1;
       devmap = word(main,i);
       end;
     when k           ='/C'          then do;
       i=i+1;
       cache = word(main,i);
       If cache >= 0 & cache<16 & datatype(cache,'w')
           then cache = 'CACHE' cache;
           else do
           say 'Invalid cache size' cache 'ignored.'
             cache=''
             end;
       end;
     when k           ='/ID'         then do;
       i=i+1;
       id = word(main,i);
        if datatype(id,'x') & length(id)<=6
           then id    = 'ID' right('00000000'||id,6);
           else do
             say 'Invalid CPUID' id 'ignored.';
             id=''
             end;
       end;

     Otherwise say 'Invalid option' k 'ignored.';
   end;
end;

/*------------------------------------------------------------------*/
/*   Check out the DEVMAP file                                      */
/*------------------------------------------------------------------*/
If devmap <> '' then do   /* User specified DEVMAP with /MAP option */
/* Try to read the file */
   dcfg=charin(devmap,9,12);
   If dcfg <> 'CONFIGURATOR'
      then do;  /* User specified an invalid file for DEVMAP     */
      xrc=3
      msg= 'The specified DEVMAP configuration file "'devmap'" is missing or invalid.'
      Signal xitmsg;
      end
/* Now try to set it as the current DEVMAP */
   "AWSPROF" devmap
   If rc <> 0 then do
      xrc=rc
      msg= 'The specified DEVMAP configuration file "'devmap'" is missing or invalid.',
           'See error message printed in the IPL.CMD OS/2 window details.'
      Signal xitmsg;
      end
   End; /* user specified DEVMAP */

Else do  /* Use the default DEVMAP */
   "awsprof /q > awsjunk.tmp";
   devmap=linein("awsjunk.tmp")
   Call Stream 'awsjunk.tmp','C','CLOSE'
   z=SysFileDelete('AWSJUNK.TMP')
/* Look at results of AWSPROF command   */
   If devmap=''
     then do;  /* The AWSPROF didn't work.  */
       xrc=3
       msg=  'The default DEVMAP name cannot be determined. There may not',
             'be enough disk space on drive ' sdrive;
       Signal xitmsg;
       end
   If devmap='(Not Found)'
     then do;  /* A default DEVMAP location was never specified */
       xrc=3
       msg=  'A default location for the DEVMAP configuration file has',
             'not been established.  Run the' card 'Configuration program (AWSCFG.CMD).';
       Signal xitmsg;
       end
   cfg=charin(devmap,9,12);
   If cfg <> 'CONFIGURATOR'
     then do;  /* DEVMAP file does not exist                    */
        xrc=3
        Parse upper var devmap devmap
        msg= 'The default DEVMAP configuration file "'devmap'" is missing or invalid.',
              'Find or restore the correct file and then run AWSPROF to set the location.';
        Signal xitmsg;
        end
   End; /* System default DEVMAP */

/*  Search DEVMAP for the presence of the PARCA manager */
ddevmap = charin(devmap,1,99999) /* read in entire DEVMAP file */
If Pos('AWSICE  ',ddevmap) > 0 then Call FindICE  /* Find parca card numbers */
/* Get the 3215 font from devmap */
   kfont=strip(Substr(ddevmap,5*64+39,24));
   /* if it looks like an old DOS font spec, ignore it. */
   if substr(kfont,2,1)= ' '|substr(kfont,2,1)=':'
      then font='';
      else font=kfont;
/* end 3215 font */
Call getdmparms;     /* Get device manager parms from DEVMAP */
Call Stream devmap,'C','CLOSE' /* close the devmap file */

/*------------------------------------------------------------------*/
/*   Determine the status of the P/370 I/O subsystem                */
/*------------------------------------------------------------------*/
'AWSSTAT /q'
select;
  when rc=0 then do;  /* Channel is already running */
     If ipladdr='NOIPL'
        then do; say card 'already running'; x=Endlocal; exit 100; end;
     If ask = 'ASK' then do; /* Present a pop-up question */
                             /* Note: 16385 = 'OK+CANCEL' */
        If pname='P370' then
           awspopup 16385 '"The P/370 may be running. Do you really want to re-IPL?"' '"IPL P/370"  '
        If pname= 'P390' then
           awspopup 16385 '"The P/390 may be running. Do you really want to re-IPL?"' '"IPL P/390"  '
        End; /* ASK */
     If rc=2 then do; x=Endlocal(); Exit; End; /* user doesn't want to stop */
      say card 'already running, re-ipling now'
      "CLRIO * >nul"          /* Reset C/370 devices */
      'AWSIPL.EXE' ipladdr auto ipltype stop clk parm;
      If rc <> 0 then do
          xrc=rc
          msg='IPL failed (RC='xrc')',
          'Click on "END' ptitle'", then try IPL again.'
          signal xitmsg;
          end;
      Exit rc
  end;
  when rc=1 then do;
     xrc=rc
     msg= ptitle 'Adaptor Card not present',
          'or wrong device driver installed.',
          'Use DD3702 for 7437, AWS370DD for P/370 or P/390.';
      signal xitmsg;
  end;
  when rc=2 then do;
     xrc=rc
     msg= 'Power on 7437 and then retry IPL.';
      signal xitmsg;
  end;
  when rc=3 then do;
     xrc=rc
     msg= '7437 or' ptitle 'device driver not in CONFIG.SYS. '    ,
          'Use DD3702.SYS for 7437, AWS370DD.SYS for P/370 or P/390.';
      signal xitmsg;
  end;
  /* RC = 4 means software is not up yet, RC= 8 is some
     other error, which we treat the same as RC=4.. i.e.
     try to bring the software up.
  */
  otherwise nop;
  end; /* select */


/* coordinate defaults here */
if ipladdr='NOIPL' & ipltype='' then ipltype='NOCLEAR';
   else If ipltype = '' then ipltype ='CLEAR'

/* If PARCA manager is present, attempt to initialize the Artic card(s) */
If parca = 'Y' then do
   If cards <> '' then Do
      z=Stream('ICEINIT.CMD','C','QUERY EXISTS')  /* Does it exist? */
      If z <> '' then "CALL ICEINIT -Q" cards
      Else Say 'Program ICEINIT.CMD cannot be found. PARCA channel cards cannot be initialized.'
      End;
   Else do
      Say 'AWSICE devices present, but card number was not specified in DEVMAP.'
      Say 'Devices will NOT be initialized.'
      End;
   Say ''
   End;  /* Parca */

/*------------------------------------------------------------------*/
/* Start the OS/2 P/370/390 Kernal                                  */
/*------------------------------------------------------------------*/
If pname = 'P390' then do;"TYPE LEGAL.DOC";Say '';end;
call qtrace /* Display I/O trace options from CHAN.TRC */

'start "'card' Info" /min /n awsmain.exe' ipltype cache id mode
if rc=1 then  /* this is for os2 1.3 which doesnt support "/min"    */
'start "'card' Info" /n awsmain.exe' ipltype cache id mode
"awsulim.exe"

/*-------------------------------------------------------------------*/
/* Start the OS/2 P/370 VCUs which have to be ready before we IPL.   */
/*-------------------------------------------------------------------*/
Trace o;
   call dmstart "aws2821.exe  n" dmparms.aws2821;
   call dmstart "awsFBA.exe   n" dmparms.awsfba;
   call dmstart "aws3274.exe  n" dmparms.aws3274 dmparms.lan3274;
   call dmstart 'aws3215.exe  p  "'||font||'"' dmparms.aws3215;
   call dmstart "awsTFA.exe   n" dmparms.awstfa;
   sadparms = Value('AWSSAD',,'OS2ENVIRONMENT')
   If sadparms = '' then sadparms = '/SIO 300 /FLOAT'
   call dmstart "awsSAD.exe   p" sadparms dmparms.awssad;
   If rc > 0 then
      call dmstart "awsOIA.exe   p"   /* For IBM 7437 only */
   call dmstart "awsTAPE.exe  n" dmparms.awstape;
   call dmstart "awsICA.exe   n" dmparms.awsica;
   call dmstart "awsPBS.exe   n" dmparms.awspbs;
/* call dmstart "awsARX.exe   n" dmparms.awsarx;   */
/* call dmstart "aws9346.exe  n" dmparms.aws9346;  */
   call dmstart "aws3088.exe  n" dmparms.lan3088;
   If parca = 'Y' then
      call dmstart "awsICE.exe n" dmparms.awsice;  /* Parca */
   call dmstart "awsC370.exe  n" dmparms.chan370;  /* Huron */
   call dmstart "awsCKD.exe   n" dmparms.awsckd ;
   call dmstart "aws2703.exe  n" dmparms.aws2703;
/* call dmstart "aws5080.exe  n" dmparms.aws5080; */
   call dmstart "LCS3172.exe  n" dmparms.lcs3172;
   call dmstart "LSApLAN.EXE  n" dmparms.lan3172 dmparms.aws3172;
   If rc > 0 then
      call dmstart "aws3172.exe  n" dmparms.aws3172  /* replaced by LSApLAN - LAN3172 */
   call dmstart "LSApBMGR.EXE n" dmparms.mgr3172;   /* MGR3172 */
   call dmstart "LSApSDLC.EXE n" dmparms.wan3172;   /* WAN3172 */
   call dmstart "aws2540.exe  n" dmparms.aws2540;
   call dmstart "awsOMA.exe   n" dmparms.awsoma;
/* call dmstart "awsFEP.exe   n" dmparms.awsfep; */
   call dmstart "awsDEV.exe   n /cu=SCSI3480 /dd=SCSI3480" dmparms.scsi3480
   call dmstart "awsDEV.exe   n /cu=SCSI3420 /dd=SCSI3420" dmparms.scsi3420
   call dmstart "awsDEV.exe   n /cu=AWS3480  /dd=AWS3480"  dmparms.aws3480
   call dmstart "awsDEV.exe   n /cu=AWS3420  /dd=AWS3420"  dmparms.aws3420
   call dmstart "awsDEV.exe   n /cu=ISITAPE  /dd=ISITAPE"  dmparms.isitape

/*-------------------------------------------------------------------*/
/* Call the optional "pre-IPL" User Exit (only if it exists)         */
/*-------------------------------------------------------------------*/
user_file = SysSearchPath('PATH','AWSUSER.CMD') /* find in OS/2 PATH */
If user_file <> '' then do
   Say "------------- Calling before IPL user exit" user_file "-----------"
   parse arg stuff             /* Pass arguments given to IPL.CMD */
   "CALL" user_file 'BEFORE' stuff
   Say "------------- User exit complete (RC = "rc") ---------------------------------"
   End;

/*-------------------------------------------------------------------*/
/* IPL the 370 Processor                                             */
/*-------------------------------------------------------------------*/
trace o;
"awsstat /w /t10"
 If rc=4 then do;
   Say 'Some' ptitle 'components did not start:'
   'awsstat /d';
   End;
 If rc>0 then do
   x=Endlocal()  /* restore drive and subdirectory */
   Exit rc;      /* if awsmain has ended, then quit now */
   End;

/*                                                                     */
/* Call the optional TCP/IP console start program (created by AWS3274) */
/*                                                                     */
t=Stream('TNSTART.CMD','C','QUERY EXISTS')  /* Does it exist? */
If t <> '' then "CALL TNSTART"

If ipladdr = 'NOIPL' then say 'NOIPL was specified.';
Else do
  trace e;
  "AWSIPL.EXE" ipladdr auto stop clk parm;
  trace o;
  If rc <> 0 then do
      xrc=rc
      msg='IPL failed (RC='xrc')',
      'Click on "END' ptitle'", then try IPL again.'
      signal xitmsg;
      end;
  End;

/*-------------------------------------------------------------------*/
/* Start the rest of the P/370 VCUs                                   */
/*-------------------------------------------------------------------*/
call dmstart "awsPCSRV.exe n" dmparms.awspcsrv;

/*-------------------------------------------------------------------*/
/* Call the optional USER EXIT                                        */
/*-------------------------------------------------------------------*/
user_file = SysSearchPath('PATH','AWSUSER.CMD') /* find in OS/2 PATH */
If user_file <> '' then do
   Say "------------- Calling after IPL user exit" user_file "------------"
   parse arg stuff             /* Pass arguments given to IPL.CMD */
   "CALL" user_file 'AFTER' stuff
   Say "------------- User exit complete (RC = "rc") ---------------------------------"
   End;

x=Endlocal()  /* restore drive and subdirectory */
Exit 0;



/*-------------------------------------------------------------------*/
/*  S U B R O U T I N E S                                            */
/*-------------------------------------------------------------------*/

dmstart:
/*----------------------------------------*/
/* Issue an AWSSTART for a device manager */
/*----------------------------------------*/
  parse arg z;
  awsstart z;
  if rc>=12          /* 12 or more means AWSMAIN isn't running */
     then do
     x=Endlocal()  /* restore drive and subdirectory */
     Exit rc;   /* so nothing else will run either...    */
     End;
  return;

getdmparms:
/*-----------------------------------------------------*/
/* Extract device manager start parameters from DEVMAP */
/*-----------------------------------------------------*/
  dmparms.='';
  /* Set up old defaults in case devmap parms are not present */
  dmparms.mgr3172='/ID=07400000 /SN=7490';
  dmparms.chan370='/D3';
  dmparms.lan3274='/PORT=7490'
  dmparms.awsica ='/CPU=9221'
  i=pos('ENVIRONMENT3',ddevmap); /* ddevmap contains entire DEVMAP */
  if i=0 then return;
  i=i+64
  /*-----------------------------------------------------------------*/
  /* Next should be 'device parm' the first two bytes are the number */
  /* of device manager entries with parms.                           */
  /*-----------------------------------------------------------------*/
  if substr(ddevmap,i+2,11) <> 'DEVICE PARM' then return;
  dmparms.=''           /* devmap parms present, ignore old defaults */
  nctl =c2d(reverse( substr(ddevmap,i,2)))
  i=i+64
  do kp = 1 to nctl;
     pn   =strip(substr(ddevmap,i,8)   ,'T','00'x);  /* mgr name */
           /* Two flag bytes currently unused */
     parms=strip(substr(ddevmap,i+10,54),'B','00'x); /* mgr parms */
     if translate(parms)='NONE' then parms='';
     dmparms.pn=parms;
     i=i+64;
  end;
return;

xitmsg:
/*-------------------------------------------*/
/* Display Pop-Up error message box and exit */
/*-------------------------------------------*/
  "START /PM CMD /C AWSMSG.CMD" msg
  x=Endlocal()  /* restore drive and subdirectory */
Exit xrc;

qtrace:
/*---------------------------------------------------------------*/
/* - Create initial AWSABEND.LST with Customer Data in it.       */
/* - Look into CHAN.TRC and print a message if tracing is active.*/
/*---------------------------------------------------------------*/
 z=SysFileDelete('AWSABEND.LST')
 call lineout 'AWSABEND.LST','CUSTOMER.DAT';
 Call Stream 'AWSABEND.LST','C','CLOSE'

z=Stream('CHAN.TRC','C','QUERY EXISTS')  /* Does it exist? */
If z <> '' then do
   p390trace=Translate(Linein('CHAN.TRC'))
   Traceop = linein('CHAN.TRC');           /* get trace options */
   Call Stream 'CHAN.TRC','C','CLOSE'
   x=Wordpos('XXX',p390trace) /* XXX means trace all devices */
   k=Wordpos('KRN',p390trace) /* KRN means I/O kernel trace */
   e=Wordpos('END',p390trace) /* END as first word means no tracing active */
   If e=1 then return  /* No tracing is in effect */

   /* Start trace spooling, with CHAN.TRC or default options */

   TraceOp = '/S=256 /B=4';

   If e<words(p390trace)
      then TraceOp = translate( TraceOp delword(p390trace,1,e) );
   If pos('/NOSPOOL',traceop) = 0
      then do;
              'START "'ptitle' Trace Spooling" /MIN /C AWSTRCSP.EXE' TraceOp;
               Say 'Trace Spooling started. Options:' traceop
           end;
   If Words(p390trace)>=e & e>0 then p390trace=subword(p390trace,1,e-1); /* Delete the word END */
   If Words(p390trace)>=k & k>0 then p390trace=Delword(p390trace,k,1); /* Delete the word KRN */
   If (k>0 & k<e)|(k>0 & e=0) then Say '* * *  I/O KERNEL tracing is active * * *'
   If (x>0 & x<e)|(x>0 & e=0) then Say '* * *  I/O tracing for ALL devices is active * * *'
      Else If p390trace <> '' then Say 'I/O tracing active for:' p390trace
   End;
Return;

FindICE:
/*-----------------------------------------------------------------------*/
/* Look at AWSICE device entries for PARCA card numbers.                 */
/* Set variable "cards" = string of digits representing the card numbers */
/*-----------------------------------------------------------------------*/
parca = 'Y' /* Yes, there is at least one parca device */
pdevmap = ddevmap /* New variable will be parsed to zero length */
devmap_recs = Length(pdevmap)/64  /* Number of records in devmap */
icedev = 'N'; card. = ''; cards = '';
Do i = 1 to devmap_recs
   Parse var pdevmap record.i 65 pdevmap
   Select;   /* keep these in order !! */
      When record.i = ' ' then icedev = 'N'  /* End of Mgr range */
      When Substr(record.i,2,8) = 'AWSICE  ' then icedev = 'Y'  /* Beginning of Mgr range */
      When icedev = 'Y' then Do   /* Processing a parca device record */
         icedev = 'Y'  /* Start of Mgr range */
         Parse var record.i 14 parms '00'x
         devaddr = Strip(c2x(Left(record.i,2)),'L','0')
         parms = Translate(Strip(parms)) /* uppercase and strip both blanks */
         parm1st = Left(parms,1)  /* card number is the first digit */
         If Datatype(parm1st,'NUM') = 1 & parm1st >= 0 & parm1st <= 7
            Then card.parm1st = parm1st  /* use card number specified */
            Else card.0 = '0'            /* default = card 0 */
         End; /* ice devices */
      Otherwise;
      End; /* select: test each record */
   End; /* devmap_recs */
Do i = 0 to 7
   cards = cards || card.i   /* Build list of cards found, 0 thru 7 */
   End;
Return;
