/* P/390 Driver Regress program                              2/23/96 JAH        */
/*                                                                              */
/*                                                                              */
/*                                                                              */
/*                                                                              */
trace o
"@ECHO OFF"
card = 'P/390';subd = 'P390';  /* Assume this is for P/390 */
Parse upper arg x .            /* Unless user passes P370 parameter */
If x = 'P/370' | x = 'P370' then do
   card = 'P/370';subd = 'P370'; End;
title = card 'Program level regression'

Parse upper arg x .
If x = '?' then do
Say 'Correct Form is:'
Say '                REGRESS [d:]'
Say '                        P370'
Say ''
Say 'Use this command to regress by one level for the' card 'program.'
Say '  "d:" is the destination drive letter of the' subd 'subdirectory.'
Say '       (you will be prompted for it if not specified).'
Say 'The current version must be in d:\'subd
Say 'The previous version must be in d:\P390Rxx, where xx = the last major level'
Say '(e.g. if current version is 2.1, previous version was backed up in P390R20.'
Say ''
Say 'Personal/370 users must pass the parameter "P370" to use this utility.'
   Exit
   End

/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

Parse upper Source . . srcname .  /* Info on the program as called */
sletter = Filespec('Drive',srcname) /* e.g. C:              */
ssubd = Filespec('Path',srcname)    /* e.g. \P390\          */
spath = sletter||ssubd              /* e.g. C:\P390\        */
sname = Filespec('Name',srcname)    /* e.g. REGRESS.CMD     */
Parse var srcname cmdname '.' .     /* e.g. C:\P390\REGRESS */

complete=0  /* non-zero if OK */
Error=0     /* non-zero if any errors */

/*------**********************----------------------------------------*/
/*      REGRESS the driver                                            */
/*------**********************----------------------------------------*/
Regress:

/*--------------------------------------------------------------------*/
/* Check for a drive letter(s) passed as parameter to INSTALL         */
/*--------------------------------------------------------------------*/
   parse upper arg tletter .   /* P390 drive */
   parse var tletter tletter ':' .  /* strip off : if provided */

If x = 'P/370' | x = 'P370' then tletter = '';

If ssubd = '\P370\' then do  /* d:\P370\REGRESS was the command */
   card = 'P/370';subd = 'P370'; End;

Call GetP390  /* Find the P390 drive letter in CONFIG.SYS. Sets "dletter" */

If tletter='' then do
   Say '';
   Say 'What is the drive letter of the \'subd' subdirectory?'
   Say '(To accept default = 'dletter', press ENTER).';
   parse upper value SysGetKey('NOECHO') with key
   If key='0D'x Then Do
                    tpath=dletter':\'subd
                    tletter=dletter;
                    end;
                Else Do
                    tpath=key':\'subd
                    tletter=key;
                    end;
   Say ''
   end
   Else tpath=tletter':\'subd

If (length(tletter)<>1 | Datatype(tletter,'U')<>1) Then do
   Say "Invalid parameter: '"tletter"'. It must be a valid OS/2 drive letter."
   Say '*** Nothing done. ***'
   Exit 1;
   End;

/*--------------------------------------------------------------------*/
/* Check the level of P/390 programs that are installed               */
/*--------------------------------------------------------------------*/
syslvl=tpath'\SYSLEVEL.AWS'
dd = Stream(syslvl,'C','QUERY EXISTS') /* Make sure d:\P390 subdirectory exists */
If dd = '' then do
   Say "Subdirectory '"tpath"' does not exist"
   Say '(or' tpath'\SYSLEVEL.AWS not found).'
   Say '*** Nothing done. ***'
   Exit 1
   End;

If tletter <> dletter then
   Say 'Warning: 'tpath' may not be first in the "SET PATH=" statement of CONFIG.SYS.'

Call ChkP390  /* check what level of P/390 program is current   */


back_dir = tletter':'back_dir  /* e.g. d:\P390R20 */
syslvl=back_dir'\SYSLEVEL.AWS'
dd = Stream(syslvl,'C','QUERY EXISTS') /* Make sure backup subdirectory exists */
If dd = '' then do
   Say "Backup subdirectory '"back_dir"' does not exist (or" syslvl "not found)."
   Say '*** Nothing done. ***'
   Exit 1
   End;

Call ChkP390 'BACK' /* check the level of the back up directory      */


If Back_Level >= P390_Level then do
   Say 'Current' card 'program level is' P390_lvl
   Say 'Back up level in' back_dir 'is'  Back_lvl
   Say 'You can not regress between these levels!'
   Say '*** Nothing done. ***'
   Exit 2

   End;
/*--------------------------------------------------------------------*/
/* Make sure nothing is running                                       */
/*--------------------------------------------------------------------*/
Call ChkPgm  /* check to see is any P/390 programs or CM/2 are running */

Say 'To regress from' card 'Program level' P390_lvl 'to older level' back_lvl', type Y'
Say '(any other key to EXIT).';
parse upper value SysGetKey('NOECHO') with key
If key<>'Y' Then do
   Say '*** Nothing done. ***'
   Exit
   End;

Log = tletter':\'subd'BACK.LOG'  /* Log for Service Installation errors */
list = tletter':\AWSTEMP.LST'  /* List of files to be copied */
cmsg  = tletter':\AWSTEMP.MSG' /* Output file for messages from XCOPY & PKUNZIP2 */

/* Start the message log entry */
msg='0D0A'x||'===== P390 Program regress started' Date() Time() '========================'
x=Lineout(Log,msg); x=Lineout(Log);


msg='Regressing' P390_lvl '...'
Say msg; x=Lineout(Log,msg); x=Lineout(Log);

Call DelP390 tpath   /*  Erase current /P390 subdir and below */

/*--------------------------------------------------------------------*/
/*  Copy backup files back into /P390 subdirectory                    */
/*--------------------------------------------------------------------*/
"XCOPY"  back_dir"\*.*" tpath"\ /S >" cmsg  /* regress old files */
xrc=rc

"COPY" Log"+"cmsg Log">NUL:"  /* append messages to Log */
rc=SysFileDelete(cmsg)
If xrc = 0 then
Call DelP390 back_dir  /*  Erase backup /P390 subdir and below */

Else Do
   msg='** ERROR regressing' back_dir
   Say msg; x=Lineout(Log,msg); x=Lineout(Log);
   error = error+1
   End; /* error */

complete = complete+1
Say ''

Say 'Your system has been regressed to' Back_lvl

/*--------------------------------------------------------------------*/
/*  E X I T  code                                                     */
/*--------------------------------------------------------------------*/
Exit:
If complete > 0 then do  /* Only say if we have actually done something */
   Say ''
   If error<>0 then Do
      msg=title 'is finished, but errors occurred.'
      Say msg; x=Lineout(Log,msg); x=Lineout(Log);
      Say '-----------------------------------------------------------'
      Say 'Check log' log'.'
      End
   Else Do
      Say title 'is complete.'
      Say '-------------------------------------------'
      msg=title 'completed on' date() time() 'from' P390_lvl 'to' Back_lvl
      x=Lineout(Log,msg); x=Lineout(Log); /* Flag completion in log */
    Say ''
    Say 'Shutdown and reboot OS/2 for the changes to take effect.'
    End; /* No errors */
End;

Exit 0


/*------***************************-----------------------------------*/
/*----- S U B R O U T I N E S       ----------------------------------*/
/*------***************************-----------------------------------*/
GetP390:
/*---------------------------------------*/
/* Find what drive P/390 programs are on */
/*---------------------------------------*/
/* Find the boot drive  */
Bdrive=filespec('DRIVE',value('COMSPEC',,'OS2ENVIRONMENT'))
config=Bdrive'\CONFIG.SYS'

/* Read in CONFIG.SYS file one line at a time */
Do i=1 by 1 While Lines(config)
   cline = Linein(config)
   Parse upper var cline rem .
   If Strip(rem) = 'REM' then iterate
   Parse upper var cline . 'SET PATH=' ppath
   If ppath <> '' then leave /* Found the line we want */
   End;
Call Stream config,'C','CLOSE'
If ppath = '' then do  /* If we can't locate CONFIG.SYS, take default */
   dletter='D'
   Return
   End;

/*                                                             */
/*  Extract drive letter from first d:\P390; statement on line */
/*                                                             */
pp390 = Pos(':\'subd';',ppath)
If pp390 = 0 then do  /* Can't find one */

   If subd <> 'P370' then do  /* They didn't tell us they were P/370 */
      pp390 = Pos(':\P370;',ppath) /* So we'll check ourselves */
      If pp390 > 0 then do  /* P390 not found but P370 was */
         Say 'The P390 subdirectory was not found in CONFIG.SYS "SET PATH" statement.'
         Say 'If you are a Personal/370 user, please invoke this program again:'
         Say '     'cmdname' P370'
         Exit 5
         End
      End

   dletter='D' /* Can't find either P390 or P370 - assume default */
   Return
   End;

dletter = Substr(ppath,pp390-1,1)  /* Grab P390 drive letter */
If (length(dletter)<>1 | Datatype(dletter,'U')<>1) Then dletter = 'D';

Return;

/*--------------------------------------------------------------------*/

ChkP390:
/*---------------------------------------------------------------------------*/
/* Check to see what level of P/390 is installed                      */
/*---------------------------------------------------------------------------*/
Parse upper arg bb .   /* 'BACK' means check the backup subdirectory */

file=charin(syslvl,1,200)           /* Check version of P/390 X.YY.Z */
Call Stream syslvl,'C','CLOSE'
num1  = c2x(Substr(file,41,2))
num2  = c2x(Substr(file,150,1))
P390rel = Substr(num1,1,1)                     /* X.  .   */
P390lvl = Substr(num1,2,1)||Substr(num1,4,1)   /*  .YY.   */
If Substr(num1,2,1) = '0' then P390lvl = Substr(num1,4,1) /* Strip leading zero */

If num2 = 'B1' then     /* A beta fix level is installed */
   P390mod = x2c(e1)
   /* Note: To create a "Beta" SYSLEVEL.AWS, replace the X'01' byte at offset X'96' with X'B1'  */
   /*       This is ASCII for a grey block (), but SYSLEVEL.EXE displays it as a beta ()  */
Else P390mod = Substr(num2,2,1)                /*  .  .Z  */

If bb <> 'BACK' then do
   P390_level = P390rel||P390lvl||P390mod
   P390_lvl = P390rel'.'P390lvl'.'P390mod
   Back_dir  = '\'subd'R'||P390rel||P390lvl-1  /* e.g. P390R20 */
   End;  /* Current P/390 level */

Else do
   Back_level = P390rel||P390lvl||P390mod
   Back_lvl = P390rel'.'P390lvl'.'P390mod
   End;  /* Backup P/390 level */

Return;


/*---------------------------------------------------------------------------*/
/* Check to see if either P/370 code or our CM DLLs are running */
/*---------------------------------------------------------------------------*/
ChkPgm:
/* Check the P/370 CM interface DLLs  */
If Running(tpath'\awsdftn.dll'),
 | Running(tpath'\awssfts.dll'),
 | Running(tpath'\awsntca.dll'),
 | Running(tpath'\awsstca.dll')
   Then do
   Say '********************** ERROR *******************************'
   Say 'The Communications Manager 3270 DFT sessions must be STOPPED'
   Say 'before you can run the' cmdname 'program.'
   Say '*** Nothing done ***'
   Exit 13
   end

/* Check the P/370 I/O subsystem */
If Running(tpath'\awsutil.dll') then do
   Say '********************** ERROR *****************************'
   Say 'The' ptitle 'programs on drive' tpath 'may be running.';
   Say 'You must select END' card 'icon and then rerun' cmdname
   Say ''
   Say 'If it still fails, then re-boot OS/2 and try again.'
   Say '*** Nothing done ***'
   Exit 13
   end

/* Check for other P/370 programs */
n.1='MANOPS.EXE'; n.2='AWSCNF.EXE'; n.3='AWSTRACE.EXE';
Do i=1 to 3
   If Running(tpath'\'n.i) then do
      Say '********************** ERROR *****************************'
      Say 'The' n.i 'program on drive' tpath 'is running.';
      Say 'You must stop this program and then rerun' cmdname
      Say '*** Nothing done ***'
      Exit 13
      end
   End;  /* check other pgms */
Return;

Running: procedure
Arg fn
If Stream(fn,'C','QUERY EXISTS')<>''then do  /* Does it exist? */
   y=Stream(fn,'C','OPEN')   /* Open for read & write */
   z=Stream(fn,'C','CLOSE')  /* Close the file */
   End
   If y='NOTREADY:32' then run=1
   else run=0
Return run;

/*--------------------------------------------------------------------*/
/*  Delete all files from current /P390 subdirectory                  */
/*--------------------------------------------------------------------*/
DelP390:
/*                                                     */
/* Erase all the files in the current P/390 directory  */
/*   and erase and delete any subdirectories under it. */
/*                                                     */
Parse upper arg pp .
"ATTRIB" pp"\*.* -r -h -s 1>nul 2>&1"     /* Take off all attributes */
"ERASE" pp "/N"                           /* Erase the files */
oldcount=queued()                             /* anything in the rex queue? */
"DIR" pp"\* /a:d /b 2>nul 1| rxqueue /lifo" /* List subdirectories, if any */
Do queued()-oldcount  /* Erase and delete subdirectories, one by one */
   pull esubdir
   if esubdir<>'' then do
      esubdir = pp"\"esubdir
      "ATTRIB" esubdir"\*.* -r -h -s 1>nul 2>&1" /* Take off all attributes */
      "ERASE" esubdir "/N"                      /* Erase the files */
      "RD" esubdir                              /* Remove the subdirectory */
      End;
   End; /* All subdirectories under /P390  */
"RD" pp                                    /* Remove top-level subdirectory */
Return;

/*------***************************-----------------------------------*/
/*----- E R R O R   R O U T I N E S ----------------------------------*/
/*------***************************-----------------------------------*/

NodiskT:
Say ''
Say 'Destination disk' tletter': does not exist.  Check parameters and rerun.'
Exit 3

NoSpace:
ndigits=Length(total);
tdigits=Length(tfree);
tfree=Right(tfree,Max(ndigits,tdigits));
Say ''
msg='** ERROR: Not enough space on drive 'tletter' to install' title 'files.'
Say msg; x=Lineout(Log,msg);
msg=total  'bytes ('Trunc(total/1048576,1) 'MB) are needed on drive 'tletter'. There are only'
Say msg; x=Lineout(Log,msg);
msg=tfree' bytes ('Trunc(tfree/1048576,1) 'MB) available.'
Say msg; x=Lineout(Log,msg);
Say ''
Say 'Free up enough space on drive 'tletter 'and then rerun' cmdname'.'
Say ''
Exit 6
