/*    P/370 & P/390 Configuration Program         ver 2.3.3  10/14/97 */
/*                                                                    */
/*  9/30/97 JAH   Add ESO option for expanded storage on F4 menu      */
/*                Pause after displaying error messages               */
/*                Fix /NEW to delete zero length test devmap          */
/*                Move AWSPROF to after AWSCNF call                   */
/* 10/14/97 JAH   Don't create 0 length file by mistake (use Stream)  */

'@ECHO OFF';
trace o
mode='';y='';opt='';
parse upper arg devmap opt
If devmap = '?' /* Help */
   then do;
Say 'Correct Form is:                                                       '
Say '              AWSCFG [devmap] [S=0|1|2|3] [L=nn] [XC=nn]               '
Say '                     [devmap /NEW]                                     '
Say '                                                                       '
Say 'This command file invokes the P/370 & P/390 Configurator program.   '
Say '                                                                       '
Say 'If the devmap location is not specified, the current devmap (as kept by'
Say 'AWSPROF) is used.  If a devmap is specified, it becomes the new current'
Say 'devmap and will be used the next time the P/370 or P/390 is IPLed.     '
Say '                                                                       '
Say 'S=1 or S=2 will cause the configurator to skip the first one or two    '
Say 'frames, and go directly to either the password or main menu screens.   '
Say 'S=3 will skip directly to the F2 menu.                                 '
Say '                                                                       '
Say 'L=nn specifies the number of lines in the OS/2 window for the          '
Say 'Configurator program. The default and minimum is 27 lines. Maximum is 95.'
Say 'For larger values of lines "scroll bars" will appear on the right of   '
Say 'the screen. To avoid this, and to see all the lines at once, set       '
Say 'a different font size for this OS/2 window. Currently, the only menu   '
Say 'that uses more than 25 lines is the F2 Update System Devices screen.   '
Say '                                                                       '
Say 'XC=nn changes the default color for the eXcluded devices on the F2     '
Say 'Update System Devices menu. The default is XC=9 which is dark blue.    '
Say 'Excluded devices are supposed to be "in the background", but if your   '
Say 'display monitor makes them impossible to read, try another color.      '
Say 'Valid numbers are 1 - 10, 12 - 15.                                     '
Say '                                                                       '
Say 'Normally, you will receive a starting devmap along with the operating  '
Say 'system, e.g. DEVMAP.1VM, DEVMAP.VSE, etc.  If you do not have one      '
Say 'and need to create a devmap from scratch, use the /NEW option. This    '
Say 'will make a devmap containing a single 3278 at address 200. You can    '
Say 'then use the Configurator to add more devices.                         '
Say '                                                                       '
     Exit
     end

/*------------------------------------------------------------------*/
/*   Parse the options                                              */
/*------------------------------------------------------------------*/
Parse upper arg parms
skip=''; devmap=''; mode=''; new=''; lines=27; xcolor=9;
do i=1 to words(parms);
   k=word(parms,i);
   select;
     when k           ='S=0'        then skip=k;
     when k           ='S=1'        then skip=k;
     when k           ='S=2'        then skip=k;
     when k           ='S=3'        then skip=k;
     when k           ='MODE'       then mode=k;
     when k           ='/NEW'       then new=k;
     when Left(k,2)   ='L='         then do
        lines = Strip(Substr(k,3))
        If Datatype(lines,'W')<> 1 then lines = 27
        If (lines < 27)|(lines > 95) then lines = 27
        end
     when Left(k,3)   ='XC='         then do
        xcolor = Strip(Substr(k,4))
        If Datatype(xcolor,'W')<> 1 then xcolor = 9
        If (xcolor = 11)|(xcolor > 112) then xcolor = 9
        end
     Otherwise If devmap = '' then devmap=k;
   end;
end;

/* Find out where this program is running from */
Parse upper source . . sspec
sdrive = Filespec('Drive',sspec)
spath = Strip(Filespec('Path',sspec),'B','\')
If (spath = 'P390') & (mode = '') then mode = 'P390 MODE';
If (spath = 'P390') & (mode <> '') then mode = 'P390' mode;
/* It MUST run from either \P370 or \P390 */
Select;
   When spath = 'P390' then do
      If mode = '' then mode = 'P390 MODE';
      Else mode = 'P390' mode;
      End;
   When spath = 'P370' then nop
   Otherwise do
      Say   'AWSCFG.CMD must be run from either the \P390 or \P370 subdirectory.'
      Say '(Press any key to exit...)';Pull .
      Exit 1
      End
   End; /* Select */
/* Change the current drive and directory there so AWSC* files can be found */
x=Setlocal()          /* Save current environment */
saved = Directory()   /* Save current drive and subdirectory */
If saved = sdrive'\'spath then nop  /* Already there */
Else do
   sdrive       /* Change to AWSCFG.CMD's drive */
   "CD \"spath  /* Change to its sundirectory */
   End

If (new='/NEW')&(devmap='') then do
   Say 'A DEVMAP filename must be specified with the /NEW option.'
   Exit 1
   End

If (new='/NEW')&(devmap<>'') then do
   z = Stream(devmap,'C','QUERY EXISTS') /* Does file exist ? */
   If z <> '' then do
      Say 'File' devmap 'already exists. Cannot specify /NEW option.'
      Exit 2
      end
   End

/*                                                                   */
/* We now have all the parameters assigned. Was DEVMAP one of them?  */
/*                                                                   */
If devmap='' then do;  /* devmap name blank */
   'awsprof /q >awsdev.loc'  /* Get current DEVMAP location */
   devmap=linein('awsdev.loc');
   call lineout 'awsdev.loc';
   'ERASE awsdev.loc'
   /* see if a default DEVMAP location was ever specified */
   If devmap='(Not Found)' then do;
      say 'A default location for the DEVMAP.1VM configuration'
      say 'file has not been established.  Enter the location'
      say '"drive:\path\filename.ext" (e.g. D:\VM\DEVMAP.1VM)'
      say 'now, or enter a null line to exit'.
      pull devmap;
      if devmap='' then exit 10; /* no file, just exit */
      end;
   awsprof=1
   End;

/*                                                                   */
/* Check the devmap file.  If OK then call awsprof to set current */
/*                                                                   */
call chkfile;
If result <>0 then exit result;

/*                                                                   */
/* Invoke the configurator                                           */
/*                                                                   */
"MODE co80,"||lines
If new = '' then
  'AWSCNF M='devmap skip mode 'ESO XC='xcolor
Else
  'AWSCNF NEW='devmap mode 'ESO XC='xcolor
  arc = rc
call setfile;
x=Endlocal()  /* restore drive and subdirectory */
Exit arc;

/*-------------------------------------------------------------------*/
/* CHKFILE subroutine -                                              */
/*-------------------------------------------------------------------*/
chkfile:
If (Filespec('D',devmap)='')|(Filespec('P',devmap)='')|(Filespec('N',devmap)='')
then do
   Say 'File "'devmap'" is not a fully-qualified OS/2 filename. You must'
   Say 'specify the drive, path, and filename, e.g. d:\path\name.ext '
   Say '';Say '(Press any key to exit...)';Pull .
   Return 10;
   End;


If new = '' then do             /* Only check if /NEW was NOT specified */
   z = Stream(devmap,'C','QUERY EXISTS') /* Does file exist ?           */
   If z <> '' then do                    /* Yes, test if its valid      */
      z=charin(devmap,9,12);
      Call lineout devmap
      End;
   /* Note: if file does NOT exist, z='' from Stream(...) so next test fails! */
   If z <> 'CONFIGURATOR' then do;  /* User specified an invalid file for DEVMAP */
      Say 'DEVMAP file' devmap 'is missing or invalid.';
      If awsprof=1 then Do
         Say 'Filename was determined from AWSPROF ?'
         Say 'If you want to change the filename, specify:'
         Say'    AWSCFG d:\path\devmap.ext     '
         Say 'If you want to create a new, empty DEVMAP, specify:'
         Say'    AWSCFG d:\path\devmap.ext  /NEW'
         End
      Say '';Say '(Press any key to exit...)';Pull .
      Return 20;
      End;
   End;
Return 0
/*-------------------------------------------------------------------*/
/* SETFILE subroutine - calls AWSPROF to change devmap location.     */
/*-------------------------------------------------------------------*/
/* User wants to set a new devmap file.  Make sure its OK first. */
setfile:
z = Stream(devmap,'C','QUERY EXISTS') /* Does file exist ? */
If z <> '' then
   'AWSPROF' devmap; /* set the devmap location in the OS2.INI file. */
return rc;
