/*
DEV2NAME [devmap|*] [outfile]

DEV2NAME creates a names file from devmap, suitable for reading or for
processing by a REXX program.

If no devmap file or "*" is specified, the one set by AWSPROF is used.

If no output filename is specified, the output file will be named the same as
the input file, but with the extension '.NME'.

Chuck Berghorn  PKVMWFB1(BERGHORN) 914-435-8943 10/10/93 6/1/94 12/94 1/96 2/96
*/
/*
A DEVMAP file is organized as follows:
  1. header records
  2. environment records
  3. Data records
     a. control unit record
     b. device records
     c. seperator record

The data records are repeated in a set for each control unit.

The output of this program preserves the header and environment records,
but merges the control unit data into each device record so that they
all the data associated with an individual device address is in one
nickname record (which may cover 2 lines).

 6/ 1/94 3.1 CRB Updated for new DEVMAP DASD format flags.
 1/31/96 3.2 CRB New CFG Date, allow output fn, fix leading blanks on input fn
 2/15/96 3.3 CRB Parse out customer id field
11/08/96 3.4 CRB Parse out DEVICE PARM records
*/
arg fn ofn x
if fn = '?' | x\=''
   then do;
             do i=2 while(sourceline(i)<>'*/');
                say sourceline(i);
             end;
             exit 100;
        end;

if fn='' | fn = '*'
   then do;
            '@ECHO OFF';
            'AWSPROF /Q > DVMAP.LOC';
            fn=LINEIN('DVMAP.LOC');
            say 'Processing' fn;
            call lineout 'DVMAP.LOC'
            'ERASE DVMAP.LOC';
        end;
parse var fn stuff '.' ext
if ofn=''
   then ofn = stuff||'.NME';

/* erase the output file (without any error messages) if it exists */
if chars(ofn)>0
   then do;
           '@ECHO OFF';              /* no messages               */
           call charout ofn;         /* must close the file first */
           address cmd 'ERASE' ofn ; /* finally, we can erase it  */
        end;

EBC.='';
ASC.='';

/* read in the DEVMAP file and put it into ASC. and EBC. */

j=1;
do i=1 to chars(fn) by 64;
   asc.j=charin(fn,i,64);
   ebc.j=asc.j;
   j=j+1;
end;

type=1; /* 1=header, 2=cu record, 3=device record    */
env=0;  /* number of environment records encountered */
i=1;
/*  Now, search instorage file for the different record types */

do while(length(ebc.i)>0);
   a=ebc.i;
   e=asc.i;
   i=i+1;
   select;
     when(type=1) then do;
               if left(e,11)='ENVIRONMENT'
                  then do;
                           select;
                            when(env=0) then do; /*1st env record */
                                     host=right(c2x(substr(a,16,1)),1);
                                     lcl=left(c2x(substr(a,26,1)),1);
                                     ipl=c2x(reverse(substr(a,12,2)));
                                     z='Host='host,
                                       'Lcl='lcl,
                                       'IPL='ipl ,
                                       'IOCBS='c2d(substr(a,22,1))
                                       CPUID=substr(e,28,6)
                                       gmt=substr(e,34,5);
                                       cache=c2x(substr(e,24,1));
                                       Font=delstr(e,1,38)
                                     env=env+1;
                                     call write '';
                                     Call write ':nick.ENV1'   ,
                                                ':ipl.'ipl     ,
                                                ':gmt.'gmt     ,
                                                ':cpuid.'cpuid ,
                                                ':cache.'cache ,
                                                ':font.'font
                                   end;
                             when(env=1) then do; /* 2nd env record*/
                                     Netid=substr(e,13,8);
                                     path =strip(substr(e,21,22),'B','00'x);
                                     loadparm=strip(substr(e,43,8));
                                     sysmode=strip(substr(e,51,3));
                                     Xstore =c2d(substr(e,55,1));
                                     cpps2  =substr(e,56,4);
                                     cp370  =substr(e,60,4);
                                     Call write ':nick.ENV2'  ,
                                                ':node.'netid ,
                                                ':path.'path;
                                     Call write '          ',
                                                ':loadparm.'loadparm ,
                                                ':sysmode.'sysmode ,
                                                ':xstore.'xstore;
                                     env=env+1;
                                     call write '';
                                  end;
                             when(env=2) then do; /* 3rd env record*/
                                     cust=substr(e,13,40);
                                     cust =strip(cust,'B','00'x);
                                     Call write ':nick.ENV3'  ,
                                                ':cust.'cust;
                                     env=env+1;
                                     call write '';
                                  end;
                              otherwise do;
                                     env=env+1;
                                     data=substr(e,13,40);
                                     Call write ':nick.ENV'env,
                                                ':data.'data;
                                     call write '';
                              end;
                           end; /* env select */
                       end;
               if  env=0  /* Not env record, just write it out */
                   then do;
                           if i=2     /* special processing for 1st record*/
                              then do;
                                      e=substr(e,9,48)||c2x(left(e,8))
                                      cfglvl = right(a,4);
                                      if left(cfglvl,1)\='R'
                                         then cfglvl='R'||cfglvl
                                   end;
                           call write ':nick.REC'||(i-1)|| ' :file.'e;
                        end;
               if substr(e,3,12)='DEVICE PARM'
                  then do;
                           dp=1;
                           call write ':nick.DMPARMS'
                           iterate;
                       end;
               if  env >=2
                   then do;
                          if word(e,1)='Last'
                             then do;
                                     if dp>0 then call write ' '
                                     call write ':nick.DATE' ':data.'||e;
                                     call write ':nick.VERSION'    ,
                                                ':cfg.'cfglvl ,
                                                ':d2n.R4.1' ,
                                                ':date.' date() time();
                                     call write ' ';
                                     dp=0;
                                  end;
                          if e=' ' then type=2; /* looking for ctl unit rec */
                        end;
               if dp=1 & e\='' & type=1
                  then do;
                           n=left(strip(substr(e,1,8),'T','00'x),8);
                           f=c2x(substr(e,9,2));
                           if f='0001' | f='0000' then f='';
                                       else f=':flags.'f;
                           p=strip(delstr(e,1,10),'B','00'x);
                           p=strip(p);
                           call write '      :mgr.'||n ':parm.'p f;
                       end;
     end;

     /* ignore records that are all 0's */

     when(left(a,10)='00000000000000000000'x) then nop;


     when(type=2) then do;                 /* control unit record        */

         cutype=substr(e,13,4);            /* get the control unit type  */
         mgr=substr(e,2,8);                /* and get the manager name   */

         if mgr=translate(mgr)             /* if the manager name is     */
            then exclude='';               /* in upper case, ok          */
            else exclude=' :exclude.YES';  /* otherwise, its excluded    */
         type=3;
     end;
     /* A blank record tells us to start looking for a cu record next    */
     when(e=' ') then do;
          call write e;                    /* write the seperator record */
          type=2;                          /* look for ctl unit records  */
     end;

     /* ok, it must be a device record, process it that way              */
     otherwise do;
         flags=x2b(c2x(right(a,1)));   /* get the flags byte */
         ro     = substr(flags,7,1);   /* 02 */
         ckd    = substr(flags,6,1);   /* 04 */
         dasd   = substr(flags,5,1);   /* 08 */
         nondasd=substr(flags,4,1);    /* 10 */
         /* there are two types of records, DASD and non-DASD.  If both  */
         /* dasd and non-dasd flags are off, this is an 'old' devmap and */
         /* we can assume if the device type is 3880, its FBA DASD       */
         if dasd=0 & nondasd=0 & cutype='3880'
            then do;
                      dasd=1;
                      ckd=0;
                 end;
         if dasd=0
            then do;
                     /* parse a regular record */
                     parse var a raddr +2 devtype +4 xtra +7 parms 64 .
                     DASD='NO';
                     xtra='';
                 end;
            else do;
                     /* parse a DASD record    */
                      if ckd
                         then dasd='CKD';
                         else dasd='FBA';
                      parse var a raddr +2 devtype +6 xtra 19 parms 64 .
                      if ro                       /* read only flag? */
                         then ro=':ro.YES';
                         else ro='';
                      xtra=' :label.'substr(xtra,3,6) ro; /* DASD label */
                 end;

         if left(parms,1,4)='00000000'x then parms=''; /* blank if no parms */

         call write ':nick.'c2x(raddr) ,
                    ':dmgr.'mgr         ,
                    ':dtype.'devtype   ,
                    ':ctype.'cutype ,
                    ':dasd.'dasd || xtra || exclude


         parms=strip(parms,'T','00'x);                 /* no trailing blanks*/

         if length(parms)>0
            then call write '          ' ':parm.'parms;

     end;
   end;
end;
call lineout ofn      /* close the file before exit */
exit;                 /* we're all done!            */

/* subroutine to write out the lines */
write:
   parse arg q;
   lo=lineout(ofn,q);
   if lo=1
      then do
              say "Error writing" ofn "conversion aborted"
              exit 1;
           end;

return;
