/* Use the P370REXX.DLL interface to MANOPS to display the VM/ESA 2.2   */
/*  CP trace table                                         2/23/95 JAH  */

trace o
"@ECHO OFF"

Parse upper arg which count .
If which = '?'  then do
  Say 'Correct Form is:'
  Say '                 CPTRACE [LAST] number_of_entries '
  Say '                          FIRST                   '
  Say ''
  Say ' The entries will be displayed one per line: '
  Say '  - in reverse order (newest first) if LAST nn is specified.'
  Say '  - in forward order (oldest first) if FIRST nn is specified.'
  Exit
End;

"AWSSTAT /Q"
If rc <> 0 then do
   Say 'P/390 I/O subsystem is not running.'
   Exit 1
   End;

If which = 'FIRST' | which = 'LAST' then nop
  else do
   If datatype(which,NUM) then Do
      count = which
      which = 'LAST'
      end
   Else which = 'LAST'
  End

If count ='' then count = 1

CALL RxFuncAdd  'MemoryRead', 'P370REXX', 'P370MemoryRead'
CALL RxFuncAdd  'CombufRead', 'P370REXX', 'P370CombufRead'

Prefix  = Left(CombufRead(64,4),1)       /* get the prefix  */
Trace_start = MemoryRead(prefix'8D0',4)  /* PFXTTPNT = start of trace table */
Trace_next  = CombufRead(F0,4)           /* CR 12 contains next entry */
SYSCM = MemoryRead(prefix'698',4)  /* Location of system common area (HCPSYS) */
num_pages = MemoryRead(d2x(x2d(syscm) + x2d(2D8)),4) /* SYSTRAC */

If which = 'FIRST' then do
   Addr=Trace_start
Do c=1 to count
   Entry = MemoryRead(addr,20)
   Do i=1 to 8
      Parse var entry entry.i 9 entry
      end
   Say entry.1 entry.2 entry.3 entry.4 entry.5 entry.6 entry.7 entry.8
   Addr = d2x(x2d(addr) + 32)
   End
End; /* First nn entries */

Else do
   Addr=Trace_next
   Addr = d2x(x2d(addr) - 1) /* CR12 = hhhhhhh1 last bit means tracing is ON */
Do c=1 to count
   Addr = d2x(x2d(addr) - 32)
   Entry = MemoryRead(addr,20)
   Do i=1 to 8
      Parse var entry entry.i 9 entry
      end
   Say entry.1 entry.2 entry.3 entry.4 entry.5 entry.6 entry.7 entry.8
   End
End;  /* Last nn entries */
