/* $Id: config.h,v 1.5 2004/07/10 01:23:32 grog Exp $
 *
 * Copyright (c) 2004 by Greg Lehey
 * 
 *  This software is distributed under the so-called ``Berkeley 
 *  License'': 
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution. 
 * 
 * This software is provided ``as is'', and any express or implied 
 * warranties, including, but not limited to, the implied warranties of 
 * merchantability and fitness for a particular purpose are disclaimed. 
 * In no event shall Domenick Venezia be liable for any 
 * direct, indirect, incidental, special, exemplary, or consequential 
 * damages (including, but not limited to, procurement of substitute 
 * goods or services; loss of use, data, or profits; or business 
 * interruption) however caused and on any theory of liability, whether 
 * in contract, strict liability, or tort (including negligence or 
 * otherwise) arising in any way out of the use of this software, even if 
 * advised of the possibility of such damage.
 */

/* Configuration variables, defined in commands.c */

/*
 * The serial line from which to read temperature data.
 * For Linux, you might use something like /dev/ttyS0.
 */
extern char serialline [];

/*  The bit rate of the serial line (bps). */
extern int linespeed;

/* Temperature probe use.  Presently we measure only room temperature
 * (outside the fridge), ambient temperature (inside the fridge) and
 * fermenter temperature (typically intended to be the surface).  This
 * program is currently set up for four probes, which leaves one over.
 * It will be monitored, but at present there's no particular use for
 * it.  This may change.
 * The temperature probe with the room temperature.
 */
extern int roomtempprobe;

/*
 * The temperature probe with the ambient (in-fridge) temperature.
 * This doesn't have to exist; set to -1 if it isn't there.
 */
extern int ambientprobe;

/*
 * The temperature probe with the fermenter temperature.
 */
extern int fermenterprobe;

/*
 * The temperature probe with the second fermenter temperature.
 */
extern int fermenter2probe;

/*
 * Next we have a number of descriptive texts.  They're purely
 * cosmetic: a list saying "fermenter 1" is less informative than
 * "brew 37" or "pale ale".  For each fermenter there are three
 * labels: one for printing when there's enough space, and two others
 * for when there isn't, and it needs to be split over two lines.
 * This is the case with the status display.
 *
 * For silly reasons, the short versions for the first fermenter are
 * limited to 6 characters each, while the short versions for the
 * second fermenter are limited to 7 characters.  Expect this to
 * change.
 */

extern char fermenter1label [];
extern char fermenter1label1 [];
extern char fermenter1label2 [];

extern char fermenter2label [];
extern char fermenter2label1 [];
extern char fermenter2label2 [];

/*
 * Due to the nature of the cooling hardware, the same cooling applies
 * to all fermenters in the fridge, but the temperatures of each
 * fermenter can be different according to the rate of fermentation
 * and the air flow around the fermenter.  By default, the base
 * temperature (the one used to control the temperature) is the
 * temperature of the first fermenter.  probe2factor is a value
 * between 0 and 1 which specifies to what extent the temperature of
 * the second probe should be used to calculate the base temperature.
 *
 * The formula is:
 *
 * basetemp = probe2temp * factor + probe1temp * (factor - 1)
 *
 * A factor of 0 will use the temperature of probe 1 as the base
 * temperature; a factor of will use the temperature of probe 2 as the
 * base temperature.  A factor of 0.4 will set the base temperature at
 * .4 of the way from probe 1 temperature to probe 2 temperature.
 */
extern float probe2factor;

/*
 * The file in which to save temperature information.  By default, it
 * is relative to the current working directory, but it doesn't have to
 * be.
 */

extern char logfile [];

/*
 * The time interval with which to log, in seconds.  900 seconds is 15
 * minutes.
 */
extern int loginterval;

/*
 * The number of lines on a "page" of the log file.  After this
 * interval, a new heading appears.
 */

extern int logpagesize;

/*
 * The time to display idle status messages.  These are typically the
 * reason that the system is currently idle, and they soon become
 * boring.  On the other hand, if they're only displayed once, they're
 * liable to be missed.  This parameter is the number of seconds to
 * display the message.
 */

extern int idledisplaytime;

/*
 * The file to which to display current information.  This is intended
 * to be displayed on a screen, so it's written to every time.
 */
extern char displayfile [];

/*
 * The file in which to log information for graph plotting.
 * Default is not to log.
 */
extern char graphlogfile [];

/*
 * The time interval with which to log, in seconds.  600 seconds is 10
 * minutes.
 */
extern int graphloginterval;

/*
 * Set to 1 to log significant events to syslogd.
 */
extern int dosyslog;

/*
 * syslog priority.  Currently not changeable.
 */
extern int syslog_prio;

/*
 * For debugging, log to this file.  By default there is no file,
 * meaning that we don't do debug logging.
 *
 * To turn debugging off, specify the debugfile keyword without an
 * argument.
 */
extern char debugfile [];

/*
 * Part 2: temperature control outputs.
 * relayline is the (parallel) port controlling the relays.
 */
extern char relayline [];

/*
 * We define two relays for controlling the temperature.  These values
 * specify the output bits on relayline needed to set them.
 */
extern int coolrelay;
extern int heatrelay;

/*
 * We can't turn things on and off all the time.  In particular,
 * refrigerators would die quickly.  It also confuses the regulation.
 * The following two variables specify the minimum times, in seconds,
 * that the heater and cooler should be on and off.
 */
extern int heateronmin;
extern int heateroffmin;
extern int cooleronmin;
extern int cooleroffmin;

/*
 * To avoid oscillation, it's probably a good idea to wait longer
 * betweeen changing tack.  These are the minimum times from cooler
 * off to heater on and heater off to cooler on.
 */

extern int coolertoheaterdelay;
extern int heatertocoolerdelay;

/*
 * Temperatures.  All temperatures are in Celsius (or Kelvin where it
 * doesn't make any difference).  If you really want to use Fahrenheit,
 * either change the source, or better, don't.  Instead, convert to
 * Celsius with the formulae C = (F - 32) / 1.8 and F = C * 1.8 + 32.
 */

/*
 * Initial goal temperature.  This is the temperature you want to aim
 * for when you start the program.  Depending on what you're doing,
 * you can maintain this temperature throughout the fermentation or
 * gradually change to the end temperature at a fixed rate.
 *
 * This variable has a relatively sensible default, but you'll almost
 * certainly want to change it.
 */
extern float starttemp;

/*
 * Final goal temperature.  This is the temperature you want to aim
 * for later in fermentation.  The goal temperature changes from
 * starttemp to endtemp at the rate specified by the second parameter,
 * which specifies the number of seconds to take to perform the
 * change.  So, for example, you could complete the transition from
 * 20 to 17 in 10 hours with:
 *
 * starttemp 20
 * endtemp 17 36000
 *
 * To disable this feature, set the second paramter to 0.  Yes, this
 * should mean that it happens immediately, but it's an easier way of
 * doing things.
 *
 * Internally the second parameter is called tempchangetime, and the
 * current goal temperature is called goaltemp.
 */
extern float endtemp;
extern float tempchangetime;
extern float goaltemp;

/*
 * It's easy to overshoot the temperature we're aiming for.  We need a
 * middle ground where we're neither heating nor cooling.  These values
 * specify how far the temperature should drop below the goal
 * temperature before turning on the heating and how far the
 * temperature should rise above the goal temperature before turning on
 * the cooling.
 */
extern float heaterholdoff;
extern float coolerholdoff;

/*
 * On the other hand, if there's no or only minimal overrun, stopping
 * dead on the temperature can mean that the average is offset.
 * Counter this by not stopping until we have overrun a little.  This
 * can use a lot of tuning.
 */

extern float coolerovershoot;
extern float heaterovershoot;

/*
 * Large volumes of liquid change temperatures slowly.  Air changes its
 * temperature much more quickly.  It's probably safe to let the air
 * temperature do what it wants, but if we have an ambient temperature
 * probe, we can limit the ratio of the temperature differences.  For
 * example, if the wort temperature is 19.8 and it should be 19.0, it
 * would be counterproductive to limit the air temperature to 19, or
 * even 18.  On the other hand, if it drops to 0, it might have a
 * negative effect on the overall fermentation.  I don't know about
 * this one, but it's here for experimentation.  Again there are two
 * variables, one for heating and one for cooling.  They specify the
 * ratio between the temperature difference between desired and actual
 * wort temperature and the temperature difference beweeen ambient
 * temperature and desired wort temperature.  In algebraic form:
 *
 * W0	current wort temperature
 * Wn	desired wort temperature
 * Ta	current ambient temperature
 * Rt	temperature ratio
 *
 * Then the program enforces (Wn - Ta) / (W0 - Wn) <= Rt.
 *
 * In the example given above, the following ratio mean that the
 * ambient temperature would not drop below 11.  Maybe the values are
 * too conservative.
 */

extern float coolambientratio;
extern float heatambientratio;

/*
 * In addition to this, we have some absolute values for the difference
 * between ambient temperatures and desired wort temperature.  They're
 * differences, not absolute temperatures, so they depend on the
 * desired wort temperature.  I'm particularly concerned about
 * overheating worts, so this one is lower.
 */
extern float maxcooltempdiff;
extern float maxheattempdiff;

/*
 * Finally, for lagers, we need to ensure that we don't freeze the
 * thing.  We also don't want to boil it.  These are absolute
 * temperatures.
 */
extern float maxambienttemp;
extern float minambienttemp;

