/*
 * Definitions for temperature control state machine.
 * Greg Lehey, 5 June 2004
 *
 * $Id: statemachine.h,v 1.3 2004/06/20 06:22:29 grog Exp $
 *
 * Copyright (c) 2004 by Greg Lehey
 * 
 *  This software is distributed under the so-called ``Berkeley 
 *  License'': 
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution. 
 * 
 * This software is provided ``as is'', and any express or implied 
 * warranties, including, but not limited to, the implied warranties of 
 * merchantability and fitness for a particular purpose are disclaimed. 
 * In no event shall Domenick Venezia be liable for any 
 * direct, indirect, incidental, special, exemplary, or consequential 
 * damages (including, but not limited to, procurement of substitute 
 * goods or services; loss of use, data, or profits; or business 
 * interruption) however caused and on any theory of liability, whether 
 * in contract, strict liability, or tort (including negligence or 
 * otherwise) arising in any way out of the use of this software, even if 
 * advised of the possibility of such damage. 
 */

/* What are we doing at the moment? */
extern enum coolstatus
{
  cooling,						    /* currently cooling */
  idle,							    /* not doing anything */
  heating						    /* currently heating */
  }
coolstatus;

/* In more detail: what are we doing at the moment? */
enum machinestate
{
  M_INIT,						    /* initializing */
  M_IDLE,						    /* not doing anything */
  M_COOLING,						    /* actively cooling */
  M_COOL_ON_WAIT,					    /* waiting for cooler on time */
  M_COOL_OFF_WAIT,					    /* waiting for cooler off time */
  M_COOL_AMBIENT_ABS,					    /* waiting for absolute ambient temperature
							     * difference to decrease */
  M_HEATING,						    /* actively heating */
  M_HEAT_ON_WAIT,					    /* waiting for heater on time */
  M_HEAT_OFF_WAIT,					    /* waiting for heater off time */
  M_HEAT_AMBIENT_ABS					    /* waiting for absolute ambient temperature
							     * difference to decrease */
  };

extern char *machinestatetext [];			    /* text description of above */
